<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if(isset(Yii::app()->session['job'])){
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label'=>'Back to : ' . $job->jobNum, 'url'=>array('jobs/view','id'=>$job->id));
}

if(!empty($jobmenu)){
    $jobclosemenu = array('label'=>'Close Job Session', 'url'=>array('jobs/closesession'));
}

$this->menu = array(
        $jobmenu,
        $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Jobs by Coordinator</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
        'header'=>'No.',
        'value'=>'$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
      ),
        array(
            'name'=>'createdDtm',
            'value'=>'date("Y-m-d",strtotime($data->createdDtm))'
        ),
        array(
            'name'=>'jobNum',
            'value'=>'CHtml::link($data->jobNum,array("jobs/view","id"=>$data->id),array("target"=>"_blank"))',
            'type'=>'raw',
            ),
        'jobname',
        array(
            'name'=>'quoteNum',
            'value'=>'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type'=>'raw',
        ),
        array(
            'name'=>'workorder_id',
            'value'=>'CHtml::link($data->workorder->salesorderNumber ,array("workorderdetails/admin","wid"=>$data->workorder->id),array("target"=>"_blank"))',
            'type'=>'raw',
            ),
        
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type'=>'raw',
        ),
//        array(
//            'name' => 'workorder.quotation.customer.cusmcussno',
//            'value' => '$data->workorder->quotation->getMasterCustomerLink()',
//            'type'=>'raw',
//        ),
//        array(
//            'name'=>'workorder.quotation.customer.cusnam',
//            'value'=>'$data->workorder->quotation->getCustomerLink()',
//            'type'=>'raw',
//        ),
            array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type'=>'raw',
            ),
            array(
            'name' => 'prdcoordinator_search',
            'value' => 'User::model()->findByPk($data->prd_cordinator_id)->username',
            
            ),
        
        
        //'createdDtm',
        
        array(
            'name'=>'status_id',
            'value'=>'Status::model()->findByPk($data->status_id)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,18,17)")), 'id', 'name'),
            
        ),
        array(
            'name'=>'urgent_status',
            'value'=>'Status::model()->findByPk($data->urgent_status)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (19,20)")), 'id', 'name'),
            
        ),
        /*
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{jobcomplete}{sep2}{processinv}{sep3}{viewinv}{sep4}{print}',
            'buttons' => array(                
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                    
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible'=>'in_array($data->status_id, array(1,18))',
                    
                ),
                'jobcomplete' => array
                    (
                    'label' => 'Job Complete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/jobsComplete", array("id"=>$data->id))',
                    'visible'=>'in_array($data->status_id, array(1,18))',
                    
                ),
                
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                'processinv' => array
                    (
                    'label' => 'Create Invoice',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/create", array("id"=>$data->id))',
                    'visible'=>'$data->getInvoice() == null',
                    
                ),
                
                'sep3' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                
                
                'viewinv' => array
                    (
                    'label' => 'View Invoice',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/view", array("id"=>$data->getInvoice()->id))',
                    'visible'=>'$data->getInvoice() != null',
                    'options' => array('target' => '_blank'),
                    
                ),
                'sep4' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                'print' => array
                    (
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            ),
        ),
    ),
));
?>
