<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}

$this->menu = array(
    $jobmenu,
    $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Job Status Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        
        <div class="row">
            <?php echo $form->label($model, 'prd_cordinator_id'); ?>
            <?php
            echo $form->dropDownList($model, 'prd_cordinator_id',CHtml::listData(User::model()->findAll(), 'id', 'username'),array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'prd_cordinator_id'); ?>

        </div>
        <div class="clear"></div>
        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="clear"></div>
        <div>
            <?php echo CHtml::submitButton('Go');
            echo CHtml::button('Print PDF', array('onclick' => "printPDF('{$model->prd_cordinator_id}','{$model->datefrom}','{$model->dateto}');", 'style' => 'margin-left:5px;')); ?>
        </div>
        <?php $this->endWidget(); ?>
    </div>
    <div class="clear"></div>
</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))',
            //'filter'=>false,
        ),
        array(
            'name' => 'jobNum',
            'value' => 'CHtml::link($data->jobNum,array("jobs/view","id"=>$data->id),array("target"=>"_blank"))',
            'type' => 'raw',
            //'filter'=>false,
        ),
        array(
            'name' => 'quoteNum',
            'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
            //'filter'=>false,
        ),
        array(
            'name' => 'workorder_id',
            'value' => 'CHtml::link($data->workorder->salesorderNumber ,array("workorderdetails/admin","wid"=>$data->workorder->id),array("target"=>"_blank"))',
            'type' => 'raw',
            //'filter'=>false,
        ),
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type'=>'raw',
        ),
         array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type'=>'raw',
            ),
        array(
            'name' => 'prd_cordinator_id',
            'value' => 'User::model()->findByPk($data->prd_cordinator_id)->username',
            //'filter'=>false,
            
            ),
        //'createdDtm',
        array(
            'name' => 'status_id',
            'value' => 'Status::model()->findByPk($data->status_id)->name',
            //'filter' => false,
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,18,17)")), 'id', 'name'),
        ),
        array(
            'name'=>'urgent_status',
            'value'=>'Status::model()->findByPk($data->urgent_status)->name',
           // 'filter'=>false,
            
        ),
        /*
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => 'in_array($data->status_id, array(1,18))',
                ),
                'print' => array
                    (
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            ),
        ),
    ),
));
?>
<script>
    function printPDF(coordinatorID,datefrom,dateto) {
        //alert(status_id);
        var win = window.open('index.php?r=jobs/printCoordinatorReport&corid=' + coordinatorID + '&datefrom='+datefrom+ '&dateto='+dateto);
    }


</script>