<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}

$this->menu = array(
    $jobmenu,
    $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Outstanding Jobs Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">
            <label  for="dueDate">Created Date</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dueDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>    
        <div class="clear"></div>
        <div style="float: left;">
            <?php echo CHtml::submitButton('Go');
            ?>
        </div>
        <?php $this->endWidget(); ?>
        <div style="float: right;">
            <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>
            <?php echo CHtml::button('Generate Excel', array('style' => 'float:right;', 'onclick' => 'generateExcel();')); ?>
        </div>
    </div>
    <div class="clear"></div>
</div>
<div class="clear"></div>
<div style="margin-bottom: 5%;border-bottom: 1px solid #C9E0ED;border-top: 1px solid #C9E0ED;width: 100%;padding-top: 5px;padding-bottom: 5px;">
<div class="flowstatus" style="background-color: orange;"></div><span class="statuslbl">&nbsp;Not Complete&nbsp;</span>
<div class="flowstatus" style="background-color: red;"></div><span class="statuslbl">&nbsp;Past Due&nbsp;</span>
<div class="flowstatus" style="background-color: green;"></div><span class="statuslbl">&nbsp;Complete&nbsp;</span>
<div class="clear"></div>
</div>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->searchoutstandingjobs(),
    'filter' => $model,
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'dueDate',
            'value' => '(!empty($data->dueDate) ? date(GlobalVars::get("DateFormat"),strtotime($data->dueDate)) : "Not Set")',
            'filter' => false,
        ),
        array(
            'name' => 'jobNum',
            'value' => '$data->getColorCodedOutstandingHTML()',
            'type' => 'html',
            'htmlOptions' => array('style' => 'width:75%;')
        ),
        array(
            'name' => 'quoteNum',
            'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
            'filter' => false,
        ),
        array(
            'name' => 'workorder_id',
            'value' => 'CHtml::link($data->workorder->salesorderNumber ,array("workorderdetails/admin","wid"=>$data->workorder->id),array("target"=>"_blank"))',
            'type' => 'raw',
            'filter' => false,
        ),
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            'filter' => CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
        array(
            'name' => 'ws_user',
            'filter' => false,
        ),
    //'createdDtm',
//        array(
//            'name' => 'status_id',
//            'value' => 'Status::model()->findByPk($data->status_id)->name',
//            //'filter' => false,
//            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,18,17)")), 'id', 'name'),
//        ),
    /*
      'notation',
      'followupDate',
      'dueDate',
      'user_id',
      'status_id',
     */
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=jobs/generateOutstandingJobsExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=jobs/generateOutstandingJobsPDF');

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>