<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}

$this->menu = array(
    $jobmenu,
    $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Sales person Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        
        <div class="clear"></div>

        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <?php echo $form->labelEx($model, 'ws_user_id'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['sperson_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['sperson_selcted']);
                foreach ($stsArr as $key => $val) {
                    $optionsselected[$val] = array('selected' => true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'ws_user_id', CHtml::listData(SalesPerson::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array(
                'empty' => 'All Sales Persons',
                'multiple' => true,
                'options' => $optionsselected
                    )
            );
            ?>
            <?php echo $form->error($model, 'ws_user_id'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        
        <div class="clear"></div>
        <div style="float: left;">
<?php
echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
echo CHtml::submitButton('Go', array('name' => 'go_btn'));
?>
        </div>
            <?php $this->endWidget(); ?>
        <div style="float: right;">
        <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>

        </div>
    </div>
    <div class="clear"></div>
</div>
<div class="clear"></div>

<?php

$this->widget('ext.groupgridview.GroupGridView', array(
    'id' => 'sales-person-jobs-grid',
    'dataProvider' => $model->searchGrossProfit(),
    'filter' => null,
    'mergeColumns' => array('salesPersonName'),
    //'extraRowColumns' => array('salesPersonName'),
    'extraRowPos' => 'below',
    'extraRowTotals' => function($data, $row, &$totals) {
        //$workorder = Workorder::model()->findByPk($data['workorder_id']);
        
        //$totals['sub_tot'] += $workorder->getTotalWithoutGST();
    },
    //'extraRowExpression' => '"<span class=\"label label-success\">Sub Total : </span>"',
    'summaryText' => '',
    'columns' => array(
        array(
            'name' => 'salesPersonName',
            //'value' => 'SalesPerson::model()->findByPk($data->ws_user_id)->name',
            'type' => 'raw',
        ),
        array(
            'name' => 'customerName',
            //'value' => 'Refiner::getdatetext($data->dueDate,GlobalVars::get("DateFormat"))',
            'filter' => false,
        ),
        array(
            'name' => 'cusProductValue',
            'value' => 'number_format($data->cusProductValue, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => number_format($model->productValueTotal,2),
            'footerHtmlOptions'=>array('style'=>'text-align:right;font-weight:bold;font-size:1.1em;'),
        ),
        array(
            'name' => 'decoValue',
            'value' => 'number_format($data->decoValue, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'logoSetupValue',
            'value' => 'number_format($data->logoSetupValue, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'freightValue',
            'value' => 'number_format($data->freightValue, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),        
        array(
            'name' => 'salesInvoiceValue',
            'value' => 'number_format($data->salesInvoiceValue, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => number_format($model->salesInvoiceTotal,2),
            'footerHtmlOptions'=>array('style'=>'text-align:right;font-weight:bold;font-size:1.1em;'),
        ),
        array(
            'name' => 'otherCostCost',
            'value' => 'number_format($data->otherCostCost, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'supDecoCost',
            'value' => 'number_format($data->supDecoCost, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'logoSetupCost',
            'value' => 'number_format($data->logoSetupCost, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'usdFreightCost',
            'value' => 'number_format($data->usdFreightCost, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            //'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'supProductCost',
            'value' => 'number_format($data->supProductCost, 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => number_format($model->supplierProductCostTotal,2),
            'footerHtmlOptions'=>array('style'=>'text-align:right;font-weight:bold;font-size:1.1em;'),
        ),
        
        array(
            'header' => 'Total Cost of Order',
            'value' => 'number_format(($data->otherCostCost + $data->supDecoCost + $data->logoSetupCost + $data->usdFreightCost + $data->supProductCost),2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => number_format($model->costOfOrderTotal,2),
            'footerHtmlOptions'=>array('style'=>'text-align:right;font-weight:bold;font-size:1.1em;'),
        ),
        
        array(
            'name' => 'invoiceNumbersText',
            //'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))',
            'filter' => false,
        ),
        array(
            'header' => 'Gross Profit',
            'value' => 'number_format(($data->salesInvoiceValue - ($data->otherCostCost + $data->supDecoCost + $data->logoSetupCost + $data->usdFreightCost + $data->supProductCost) ) * 100 / ($data->salesInvoiceValue?:1) ,2) . "%"',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => number_format((($model->salesInvoiceTotal - $model->costOfOrderTotal) * 100 / ($model->salesInvoiceTotal?:1)),2) . "%",
            'footerHtmlOptions'=>array('style'=>'text-align:right;font-weight:bold;font-size:1.1em;'),
        ),
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=jobs/generateOutstandingJobsExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=jobs/printGrossProfitReportPDF');

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>