<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}

$this->menu = array(
    $jobmenu,
    $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Sales person Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">

            <?php echo $form->labelEx($model, 'spersonDateFlag'); ?>

            <?php
            echo $form->radioButtonList($model, 'spersonDateFlag', array(1 => 'Job Created Date', 2 => 'Job Due Date', 3 => 'Invoice Created Date'), array(
                'labelOptions' => array('style' => 'display:inline'),
                'separator' => '&nbsp;&nbsp;',
            ));
            ?>
        </div>
        <div class="clear"></div>

        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <?php echo $form->labelEx($model, 'ws_user_id'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['sperson_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['sperson_selcted']);
                foreach ($stsArr as $key => $val) {
                    $optionsselected[$val] = array('selected' => true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'ws_user_id', CHtml::listData(SalesPerson::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array(
                'empty' => 'All Sales Persons',
                'multiple' => true,
                'options' => $optionsselected
                    )
            );
            ?>
            <?php echo $form->error($model, 'ws_user_id'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        <div class="row">

<?php echo $form->checkBox($model, 'sperson_filter_jobinprogress'); ?>
            <?php echo $form->labelEx($model, 'sperson_filter_jobinprogress', array('style' => 'display:inline;')); ?>
            <div class="clear"></div>

<?php echo $form->checkBox($model, 'sperson_filter_jobinvoiced'); ?>
            <?php echo $form->labelEx($model, 'sperson_filter_jobinvoiced', array('style' => 'display:inline;')); ?>
        </div>
        <div class="clear"></div>
        <div style="float: left;">
<?php
echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
echo CHtml::submitButton('Go', array('name' => 'go_btn'));
?>
        </div>
            <?php $this->endWidget(); ?>
        <div style="float: right;">
        <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>

        </div>
    </div>
    <div class="clear"></div>
</div>
<div class="clear"></div>

<?php

$this->widget('ext.groupgridview.GroupGridView', array(
    'id' => 'sales-person-jobs-grid',
    'dataProvider' => $model->searchSperson(),
    'filter' => $model,
    'mergeColumns' => array('salesperson_search'),
    'extraRowColumns' => array('salesperson_search'),
    'extraRowPos' => 'below',
    'extraRowTotals' => function($data, $row, &$totals) {
        $workorder = Workorder::model()->findByPk($data['workorder_id']);
        
        $totals['sub_tot'] += $workorder->getTotalWithoutGST();
    },
    'extraRowExpression' => '"<span class=\"label label-success\">Sub Total : ".number_format($totals["sub_tot"], 2)."</span>"',
    'summaryText' => '',
    'columns' => array(
        array(
            'name' => 'salesperson_search',
            'value' => 'SalesPerson::model()->findByPk($data->ws_user_id)->name',
            'type' => 'raw',
        ),
        array(
            'name' => 'dueDate',
            'value' => 'Refiner::getdatetext($data->dueDate,GlobalVars::get("DateFormat"))',
            'filter' => false,
        ),
        array(
            'name' => 'jobNum',
            'value' => '$data->getNameWithTotalExGst()',
            'type' => 'raw',
            
        ),
        array(
            'header' => 'Price',
            'value' => 'number_format($data->rel_workorder()->getTotalWithoutGST(), 2)',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => $model->footerTemplate()
        ),
         array(
            'header' => 'Cost',
            'value' => 'number_format($data->rel_workorder()->getItemCosts(), 2)',
            'type' => 'raw',
             'htmlOptions'=>array('style'=>'text-align:right;'),
            'footer' => $model->footerTemplateCost()
        ),
        array(
            'header' => 'GP',
            'value' => 'round($data->rel_workorder()->getGrossProfitMarginPercentage(), 2) . "%"',
            'htmlOptions'=>array('style'=>'text-align:center;'),
            'type' => 'raw',
        ),
        array(
            'name' => 'invoice_number_search',
            'value' => '$data->getInvoicesLinkHtml()',
            'type' => 'html',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'Job'", 'order' => 'status ASC')), 'id', 'status'),
        // 'type' => 'raw',
        ),
        //'createdDtm',
//        array(
//            'name' => 'status_id',
//            'value' => 'Status::model()->findByPk($data->status_id)->name',
//            'filter' => false,
//        //filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,18,17)")), 'id', 'name'),
//        ),
        array(
            'name' => 'urgent_status',
            'value' => 'Status::model()->findByPk($data->urgent_status)->name',
            'filter' => false,
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))',
            'filter' => false,
        ),
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=jobs/generateOutstandingJobsExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=jobs/printSalespersonPDF');

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>