<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);



Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Summary Reports Of Jobs</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->searchSummary(),
    'filter' => $model,
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))'
        ),
        array(
            'name' => 'quoteNum',
            'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'workorder_id',
            'value' => 'CHtml::link($data->workorder->salesorderNumber ,array("workorderdetails/admin","wid"=>$data->workorder->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'jobNum',
            'value' => 'CHtml::link($data->jobNum,array("jobs/view","id"=>$data->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type' => 'raw',
        ),

        //'createdDtm',

        array(
            'name' => 'status_id',
            'value' => 'Status::model()->findByPk($data->status_id)->name',
            'filter' => CHtml::listData(Status::model()->findAll(array('condition' => "id IN (1,3,18,17)")), 'id', 'name'),

        ),
        /*
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{summary}{sep1}{print}',
            'buttons' => array(
                'summary' => array(
                    'label' => 'Summary',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/summary", array("id"=>$data->id))',

                ),
                'sep1' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,


                ),

                'print' => array(
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/printSummary", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            ),
        ),
    ),
));
?>