<?php
$datetype = '';
if (isset(Yii::app()->session['sperson_date_type_flag'])) {
    switch (Yii::app()->session['sperson_date_type_flag']) {
        case 1: $datetype = "Job created date";
            break;
        case 2: $datetype = "Job due date";
            break;
        case 3: $datetype = "Invoice created date";
            break;
    }
}
$datefrom = '';
$dateto = '';
if (isset(Yii::app()->session['sperson_datefrom'])) {
    $datefrom = Refiner::getdatetext(Yii::app()->session['sperson_datefrom'], GlobalVars::get("DateFormat"));
}
if (isset(Yii::app()->session['sperson_dateto'])) {
    $dateto = Refiner::getdatetext(Yii::app()->session['sperson_dateto'], GlobalVars::get("DateFormat"));
}

$datetext = '';
if ($datefrom && $dateto) {
    $datetext = $datetype . ' between [ ' . $datefrom . ' to ' . $dateto . ' ]';
} else if ($datefrom && !$dateto) {
    $datetext = $datetype . ' from [ ' . $datefrom . ' ]';
} else if (!$datefrom && $dateto) {
    $datetext = $datetype . ' to [ ' . $dateto . ' ]';
}
?>

<table style="width:100%;"><tr><td style="width:100%;text-align:right;font-size:1em;">Date : <?php echo date(GlobalVars::get("DateFormat"), strtotime('now')); ?></td></tr></table><br/><br/>

<table style="width:100%;">
    <tr>
        <td style="width:100%;text-align:center;font-size:2em;">
            JOBS BY SALESPERSON REPORT<br>
            <small><?php echo $datetext; ?></small>
        </td>
    </tr>
</table>
<br/>


<?php
$salesPersonArray = array();
foreach ($rawData as $item) {
    if (empty($item['ws_user_id'])) {
        $item['ws_user_id'] = 'x';
    }
    if (array_key_exists($item['ws_user_id'], $salesPersonArray)) {
        $salesPersonArray[$item['ws_user_id']] += 1;
    } else {
        $salesPersonArray[$item['ws_user_id']] = 1;
    }
}

echo '<table style="width:100%;">';
echo '<tr style="font-size:8pt;font-weight:bold;">        
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Sales Person</td>
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Due Date</td>
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Job #</td>  
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Price</td>
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Cost</td>
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 8%;">GP</td>   
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 8%;">Invoice #</td>
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Customer</td>  
        <td style="border-top:1px solid #000; border-bottom:1px solid #000;width: 12%;">Created Date</td>
    </tr>';
echo '</table>';

$allTotalExGST = 0;
$allTotalCost = 0;
foreach ($salesPersonArray as $key => $value) {
    $mergecount = 0;
    $subjobtotal = 0;
    $subjob_cost_total = 0;
    foreach ($rawData as $item) {
        if (empty($item['ws_user_id'])) {
            $item['ws_user_id'] = 'x';
        }
        if ($key == $item['ws_user_id']) {
            $count += 1;
            $job = $this->loadModel($item['id']);
            $salesperson = SalesPerson::model()->findByPk($item['ws_user_id'])->name;
            $sonumber = $job->workorder->salesorderNumber;
            $customerText = $job->customer->cusnam;
            $customerContactName = '<br><div style="border-top:1px solid #C9E0ED;">' . $job->customer->cuscontact . '</div>';
            $urgentStatus = Status::model()->findByPk($job->urgent_status)->name;

            $jobnumber = $job->jobNum;

            $selling_price = $job->rel_workorder()->getTotalWithoutGST();
            $cost_price = $job->rel_workorder()->getItemCosts();

            $subjobtotal += $selling_price;
            $subjob_cost_total += $cost_price;
            
            $gp = round($job->rel_workorder()->getGrossProfitMarginPercentage(), 2) . "%";

                echo '<table style="width:100%;">';           
                echo '<tr style="font-size:8pt;">            
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 6pt;width: 12%;">'.$salesperson.'</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">'.Refiner::getdatetext($item["dueDate"], GlobalVars::get("DateFormat")).'</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;width: 12%;">'.$jobnumber.'</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;text-align: right;width: 12%;">'. number_format($selling_price,2).'</td> 
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;text-align: right;width: 12%;">'. number_format($cost_price,2).'</td>     
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;text-align: right;width: 8%;">'.$gp.'</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;width: 8%;">'.$job->getInvoicesLinkHtml().'</td>                    
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">'.$customerText . $customerContactName.'</td> 
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">'.date(GlobalVars::get("DateFormat"), strtotime($job->createdDtm)).'</td>
                       </tr>';
                echo '</table>';
            

           
        }
    }
    echo '<table style="width:100%;">';  
    echo '<tr>            
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;font-weight: bold;width: 12%;">Sub Total : '.number_format($subjobtotal, 2).'</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>   
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td> 
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 8%;">&nbsp;</td>
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;width: 8%;">&nbsp;</td>                    
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>                            
                            <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
                       </tr>';
    echo '</table>';  
    $allTotalExGST += $subjobtotal;
    $allTotalCost += $subjob_cost_total;
}
echo '<table style="width:100%;">';  
echo '<tr>
        
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;"></td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;text-align: right;font-size: 8pt;font-weight: bold;width: 12%;">Total : </td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;text-align: right;font-size: 9pt;font-weight: bold;width: 12%;">'.number_format($allTotalExGST, 2).'</td> 
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;text-align: right;font-size: 9pt;font-weight: bold;width: 12%;">'.number_format($allTotalCost, 2).'</td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 8%;">&nbsp;</td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;font-size: 7pt;width: 8%;">&nbsp;</td>    
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
        <td style="border-bottom:1px solid #eee;border-left:1px solid #eee;width: 12%;">&nbsp;</td>
    </tr>';

echo '</table>';





?>

<style>
    body { font-family: Arial, Helvetica, sans-serif; font-size: 10pt; }
</style>