<?php
$this->breadcrumbs = array(
    'Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}

$this->menu = array(
    $jobmenu,
    $jobclosemenu
        //array('label'=>'List Jobs', 'url'=>array('index')),
        //array('label'=>'Create Jobs', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Job Status Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>
        
        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  

        <div class="row">
            <?php echo $form->labelEx($model, 'followupStatus'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['job_sts_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['job_sts_selcted']);
                foreach ($stsArr as $key=>$val){
                    $optionsselected[$val] = array('selected'=>true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'followupStatus', 
                    CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = 'Job'", 'order'=>'status')), 'id', 'status'), 
                    array('empty' => '',
                        'multiple'=>true,
                            'options'=>$optionsselected
                        )
                    );
            ?>
            <?php echo $form->error($model, 'followupStatus'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        
        <div class="row">
            <?php echo Chtml::label('Urgent Status', 'urgent_status'); ?>
            <?php
            echo $form->dropDownList($model, 'urgent_status',CHtml::listData(Status::model()->findAll(array('condition' => "id IN (19,20)")), 'id', 'name'),array('empty' => 'Select Urgent Status'));
            ?>
            <?php echo $form->error($model, 'urgent_status'); ?>

        </div>        
        <div class="clear"></div>
        <div >
            <?php
            echo CHtml::submitButton('Go',array('name'=>'go_btn'));
            echo CHtml::submitButton('Reset',array('name'=>'reset_btn'));
            //echo CHtml::button('Print PDF', array('onclick' => "printPDF('{$model->status_id}','{$model->urgent_status}');", 'style' => 'margin-left:5px;')); 
            ?>
            <?php $this->endWidget(); ?>
            <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>
            <?php echo CHtml::button('Generate Excel', array('style' => 'float:right;', 'onclick' => 'generateExcel();')); ?>
        </div>
        
        
        <div class="clear"></div>
    </div>
    <div class="clear"></div>
</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->searchstatus(),
    'filter' => $model,
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))',
            'filter'=>false,
        ),
        array(
            'name' => 'jobNum',
            'value' => 'CHtml::link($data->jobNum,array("jobs/view","id"=>$data->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'quoteNum',
            'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'salesorder_search',
            'value' => 'CHtml::link($data->workorder->salesorderNumber ,array("workorderdetails/admin","wid"=>$data->workorder->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
         array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type'=>'raw',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type'=>'raw',
            ),
        'ws_user',
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            //'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = 'Job'", 'order' => 'status ASC')), 'id', 'status'),
            'filter'=>false,
           // 'type' => 'raw',
        ),
        //'createdDtm',
//        array(
//            'name' => 'status_id',
//            'value' => 'Status::model()->findByPk($data->status_id)->name',
//            'filter' => false,
//        //filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,18,17)")), 'id', 'name'),
//        ),
        array(
            'name'=>'urgent_status',
            'value'=>'Status::model()->findByPk($data->urgent_status)->name',
            'filter'=>false,
            
        ),
        /*
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => 'in_array($data->status_id, array(1,18))',
                ),
                'print' => array
                    (
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            ),
        ),
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=jobs/generateStatusReport');

    }

    function generatePDF() {
        var win = window.open('index.php?r=jobs/generateStatusPDF');

    }


</script>