<?php
$this->breadcrumbs=array(
	'Myoblogs'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List MYOBLog', 'url'=>array('index')),
	//array('label'=>'Create MYOBLog', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('myoblog-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage MYOB Logs</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'myoblog-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(		
		'table_name',
		
		array(
			'name'=>'table_reference_id',
			'value'=>'$data->refFormat()',			
		),
		array(
			'name'=>'log_type_id',
			'filter'=>CHtml::dropDownList('MYOBLog[log_type_id]', $model->log_type_id,  
                array(
                    ''=>'All',
                    MYOBLog::LOG_TYPE_SUCCESS => 'Success',
                    MYOBLog::LOG_TYPE_ERROR => 'Error',
                )
            ),
			'value'=>'$data->typeName()',			
		),
		array(
			'name'=>'log_message',
			'value'=>'$data->getMessage()',
			'type'=>'html'
		),
		'created_at',
	),
)); 
