<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'master-customer-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <div class="row">

        <?php echo $form->labelEx($model, 'Use Customer Details'); ?>
        <?php echo $form->dropDownList($model, 'subcustomerid', CHtml::listData(Customer::model()->findAll(array('condition' => 'cusnam not in("", " ", "-", "\"",".","=")', 'order' => 'cusnam ASC')), 'cussno', 'cusnam'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'subcustomerid'); ?>


    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'qca_ref'); ?>
        <?php echo $form->textField($model, 'qca_ref', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'qca_ref'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">

        <?php echo $form->labelEx($model, 'categoryId'); ?>
        <?php echo $form->dropDownList($model, 'categoryId', CHtml::listData(CustomerCategory::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'categoryId'); ?>


    </div>
    <div class="row">

        <?php echo $form->labelEx($model, 'industryId'); ?>
        <?php echo $form->dropDownList($model, 'industryId', CHtml::listData(CustomerIndustry::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'industryId'); ?>


    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'mcusnam'); ?>
        <?php echo $form->textField($model, 'mcusnam', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusnam'); ?>
    </div>



    <div class="row">
        <?php echo $form->labelEx($model, 'mcusadd1'); ?>
        <?php echo $form->textField($model, 'mcusadd1', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusadd1'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusadd2'); ?>
        <?php echo $form->textField($model, 'mcusadd2', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusadd2'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusadd3'); ?>
        <?php echo $form->textField($model, 'mcusadd3', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusadd3'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcustown'); ?>
        <?php echo $form->textField($model, 'mcustown', array('size' => 40, 'maxlength' => 40)); ?>
        <?php echo $form->error($model, 'mcustown'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusstate'); ?>
        <?php echo $form->textField($model, 'mcusstate', array('size' => 30, 'maxlength' => 30)); ?>
        <?php echo $form->error($model, 'mcusstate'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcuspostcode'); ?>
        <?php echo $form->textField($model, 'mcuspostcode', array('size' => 10, 'maxlength' => 10)); ?>
        <?php echo $form->error($model, 'mcuspostcode'); ?>
    </div>


    <div class="row">
        <?php echo $form->labelEx($model, 'mcustel'); ?>
        <?php echo $form->textField($model, 'mcustel', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcustel'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusfax'); ?>
        <?php echo $form->textField($model, 'mcusfax', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusfax'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusemail'); ?>
        <?php echo $form->textField($model, 'mcusemail', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusemail'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusdispcn'); ?>
        <?php echo $form->textField($model, 'mcusdispcn'); ?>
        <?php echo $form->error($model, 'mcusdispcn'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcusimgpath'); ?>
        <?php echo $form->textField($model, 'mcusimgpath', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'mcusimgpath'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'mcuscontact'); ?>
        <?php echo $form->textField($model, 'mcuscontact', array('size' => 50, 'maxlength' => 50)); ?>
        <?php echo $form->error($model, 'mcuscontact'); ?>
    </div>

    <div class="row">

        <?php echo $form->labelEx($model, 'salesPersonId'); ?>
        <?php echo $form->dropDownList($model, 'salesPersonId', CHtml::listData(SalesPerson::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'salesPersonId'); ?>


    </div>




    <div class="clear"></div>
    <hr>
    <div class="column">
        <?php echo $form->labelEx($model, 'payment_type_days'); ?>
        <?php echo $form->textField($model, 'payment_type_days', array('size' => 50, 'maxlength' => 50)); ?>
        <?php echo $form->error($model, 'payment_type_days'); ?>
    </div>
    <div class="column">
        <?php echo $form->labelEx($model, 'payment_type_id'); ?>
        <?php echo $form->dropDownList($model, 'payment_type_id', CHtml::listData(PaymentTerm::model()->findAll(array('order' => 'description ASC')), 'id', 'description'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'payment_type_id'); ?>
    </div>

    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'xeroContactID'); ?>
        <?php echo $form->textField($model, 'xeroContactID', array('size' => 50, 'maxlength' => 50)); ?>
        <?php echo $form->error($model, 'xeroContactID'); ?>
    </div>

    <div class="clear"></div>
    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->

<script>
    $("#MasterCustomer_subcustomerid").change(function () {

        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("customer/fetchCustomerData"); ?>',
            data: {'cussno': this.value},
            dataType: 'json',
            success: function (data) {
                //alert(data);
                $("#MasterCustomer_mcusadd1").val(data.add1);
                $("#MasterCustomer_mcusadd2").val(data.add2);
                $("#MasterCustomer_mcusadd3").val(data.add3);
                $("#MasterCustomer_mcustown").val(data.town);
                $("#MasterCustomer_mcusstate").val(data.state);
                $("#MasterCustomer_mcuspostcode").val(data.postcode);
                $("#MasterCustomer_mcustel").val(data.tel);
                $("#MasterCustomer_mcusfax").val(data.fax);
                $("#MasterCustomer_mcusemail").val(data.email);
                $("#MasterCustomer_mcusdispcn").val(data.discount);
                $("#MasterCustomer_mcuscontact").val(data.contact);


            },
            error: function (data) {
                alert('error');
            },
        });

    });
</script>