<?php
echo md5('Monaragala!M1');
$refreshMenu = null;
if (myob_api_oauth::hasAccess()) {
	$refreshMenu = array('label' => 'Refresh MYOB Master Customers', 'url' => array('refresh'), 'linkOptions' => array('style' => "background-color:green;"));
}

$this->menu = array(
	$refreshMenu,
	array('label' => 'Create Master Customer', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});

");
?>

<h1>Manage Master Customers</h1>
<div>
	<?php
	foreach (Yii::app()->user->getFlashes() as $key => $message) {
		echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
	}
	?>
</div>
<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('MYOB Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
	<?php
	$this->renderPartial('_search', array(
		'model' => $model,
	));
	?>
    <div class="clear"></div>
</div><!-- search-form -->

<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist" style="margin-top: 2%;">

    <li class="active"><a href="#admin-sec" role="tab" data-toggle="tab" >Master Customers</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import/Export</a></li>

</ul>
<div class="tab-content">
    <div class="tab-pane active view" id="admin-sec" style="padding-top: 0;margin-top: 0;">
		<?php
		$this->widget('zii.widgets.grid.CGridView', array(
			'id' => 'master-customer-grid',
			'dataProvider' => $model->search(),
			'filter' => $model,
			'columns' => array(
				array(
					'name' => 'categoryId',
					'value' => '$data->category ? $data->category->name : null',
					'filter' => CHtml::listData(CustomerCategory::model()->findall(), 'id', 'name'),
				),
				array(
					'name' => 'industryId',
					'value' => '$data->industry ? $data->industry->name : null',
					'filter' => CHtml::listData(CustomerIndustry::model()->findall(), 'id', 'name'),
				),
				//'mcussno',
				//'mcuscus',
				//'displayIdMYOB',
				//'mcuscus_fref',
				array(
					'name' => 'mcusnam',
					'value' => '$data->mcusnam . ($data->xeroContactID ? \'<br><span class="label label-info" title="Xero Customer">Xero</span>\' : "") ',
					'type' => 'html'
				),
				
				'firstName',
				'lastName',
				//'mcusfnam',
				//'mcussnam',
				array(
					'name' => 'mcusadd1',
					'value' => '$data->mcusadd1 . ", " . $data->mcusadd2 . ", " . $data->mcusadd3',
				),
				//'mcusadd2',
				//'mcusadd3',
				//'mcustown',
				//'mcusstate',
				//'mcuspostcode',
				//'mcuscousno',
				'mcustel',
				'mcusfax',
				'mcusemail',
				//'mcusdispcn',
				//'mcusimgpath',
				'mcuscontact',
				//'mcusucdnew',
				//'mcusentddt',
				//'mcusenttime',
				//'mcusucdame',
				//'mcusameddt',
				//'mcusametime',
				array(
					'class' => 'CButtonColumn',
					'template' => '{view}{sep1}{update}{sep2}{delete}',
					'buttons' => array(
						'view' => array
							(
							'label' => 'View',
							'imageUrl' => false,
						),
						'sep1' => array
							(
							'label' => ' | ',
							'imageUrl' => false,
						),
						'update' => array
							(
							'label' => 'Edit',
							'imageUrl' => false,
						),
						'sep2' => array
							(
							'label' => ' | ',
							'imageUrl' => false,
						),
						'delete' => array
							(
							'label' => 'Delete',
							'imageUrl' => false,
						),
					),
				),
			),
		));
		?>

	</div>
	<div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">
		<div class="view">
            <div class="form">
				<?php
				$form = $this->beginWidget('CActiveForm', array(
					'id' => 'master-customer-export-form',
					'enableAjaxValidation' => false,
				));
				?>


				<?php
				echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
				echo CHtml::submitButton('Export Master Customers as Excel', array('name' => 'master-customer-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



				$this->endWidget();
				?>
            </div>
            <div class="clear"></div>
        </div>
		<div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'customer-import-form',
                    'enableAjaxValidation' => false,
                    'htmlOptions' => array('enctype' => 'multipart/form-data'),
                ));
                ?>

                <div class="row">
                    <?php echo $form->labelEx($model, 'importFile'); ?>
                    <?php echo $form->fileField($model, 'importFile', array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo $form->error($model, 'importFile'); ?>

                    <?php echo CHtml::submitButton('Upload File', array('name' => 'import_btn')); ?>
                    <div>[Only XML,CSV file types are allowed] </div>
                </div>
                <div class="clear"></div>
                <?php
                //echo CHtml::submitButton('Reset', array('name' => 'reset_btn','style' => 'margin-left:5px;float:right;'));
                //echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
       
    </div>
</div>

