<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
	echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>

<?php
if (isset($flag)) {
	echo '<iframe style="display:none;" src="https://secure.myob.com/oauth2/Account/LogOff"></iframe>';
}
?>
<h1 class="form-signin-heading">Sign in to MYOB</h1>
<div class="view">
	<?php
	echo (isset($auth) && !$auth->checkAccess()) ? CHtml::link('Sign in to MYOB AccountRight', $auth->createSigninURL()) : '';
	if (isset($auth) && $auth->checkAccess()) {
		echo CHtml::link('Sign Out MYOB AccountRight', array('myob/signout'), array('style' => "background-color:#CC3300;"));
		echo '<h3 style="color:green;">You have connected with MYOB Account Right!<h3>';
		echo "<p>Account Name : {$auth->getGuide()->account_name} <small>[to change the account go to MYOB settings.]</small><p>";
		echo "<p>Account Owner : {$auth->getToken()->account_owner_username}<p>";
		echo '<hr />';
		/* register autoloading functions */
		/* each element should have two attributes.action URL and result_element_id which is used to show the MYOB streaming result on the fly */


		echo '<div id="myob_autoload_func_reg_div">';
		if (trim(MyobSetting::getSettings()->auto_send_invoice)) {
			echo '<div myob_url="' . Yii::app()->createUrl("invoice/MYOBSyncronizeAll") . '" result_element_id="auto_func_invoice"></div>';
		}

		if (trim(MyobSetting::getSettings()->auto_send_po)) {
			echo '<div myob_url="' . Yii::app()->createUrl("purchaseOrders/MYOBSyncronizeAll") . '" result_element_id="auto_func_po"></div>';
		}
		/* here you can register autoload functions as much as you need. however you need to provide seperate section for displaying the result for each */
		echo '</div>';
		/* end of autoloading functions registration */

		/* show autoloading functionality for invoice */
		/* Here you need to provide an element to show the MYOB streaming response result for each autoload */
		if (trim(MyobSetting::getSettings()->auto_send_invoice)) {
			echo CHtml::link('Manage Invoices', array('invoice/admin'));
			echo '<p>Invoice auto synchronizing option is on : <span id="auto_func_invoice" style="color:#005580;">Please Wait...</span>&nbsp;</p>';
		}

		if (trim(MyobSetting::getSettings()->auto_send_po)) {
			echo CHtml::link('Manage Purchase Orders', array('purchaseOrders/admin'));
			echo '<p>Invoice auto synchronizing option is on : <span id="auto_func_po" style="color:#005580;">Please Wait...</span>&nbsp;</p>';
		}
	}
	?>
</div>
<?php if (isset($auth) && !$auth->checkAccess()):?>
<div class="view">
	<?php
	echo '<div class="float:right;">' . CHtml::link('Reset MYOB local account', array('#'), array('onclick' => "resetMYOBLocal();return false;"));
	echo '<p style="color:red;">Warning! This will delete all MYOB related data including MYOB supplier, accounts and tax codes. Also this will wipe out the MYOB relations of products, customers, invoices, purchase orders etc.</p>';
	echo '</div>';
	?>
</div>
<?php endif;?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script>
    /* allow only for supuer admin */
    function resetMYOBLocal() {
        /* need to validate the user in the back end too */
        bootbox.prompt({
            title: "To reset (clear) the MYOB local account, please enter the word <b>'Reset MYOB'</b> then click 'OK'. (Letter case matters)",
            callback: function (result) {
                if (result == 'Reset MYOB') {
                    window.location = 'index.php?r=myob/resetLocalAccount'
                }
            }
        });
    }

    let funcState = null; /* this becomes true when MYOB calls happening for each function and become null after complete each function */
    $(document).ready(function () {
        var autoFunctionArr = {};
        $.each($('#myob_autoload_func_reg_div > div'), function (i, e) {

            autoFunctionArr[$(e).attr('result_element_id')] = $(e).attr('myob_url');

        });

        //console.log(Object.keys(autoFunctionArr).length);


        /* 
         * this function checking each myob functioning complete or not, if complete then it call next myob function if available 
         */
        var interval = setInterval(function () {

            if (Object.keys(autoFunctionArr).length > 0 && funcState === null) {

                funcState = true;
                for (var key in autoFunctionArr) {
                    var url = autoFunctionArr[key];
                    var resDisEle = key;
                    delete autoFunctionArr[key];

                    myobSynchronize(url, $('#' + resDisEle));
                    break;

                }
            } else if (0 === Object.keys(autoFunctionArr).length && funcState === null) {
                console.log('end of the interval');
                clearInterval(interval);
            } else {
                console.log('looping while synchronizing...');
            }
        }, 1000);




    });

    function myobSynchronize(url, $this) /*functionaing URL (should be a full url to the action) and an element id to display result*/
    {


        $($this).empty();
        $($this).text('MYOB syncronizing starting...');
        startMyobStreaming(url, $this);


        $.ajax({
            type: 'POST',
            url: url,
            data: {},
            dataType: 'json',
            success: function (result) {
                myobSynchronizeDone($this);
            },
            error: function (result) {
                //$this.button('done');
                console.log(result);
            },

        });
    }

    function startMyobStreaming(url, $this) { /* $this refer to trigered element */
        xhr = new XMLHttpRequest();
        xhr.open("GET", url, true);
        xhr.onprogress = function (e) {

            var str = e.currentTarget.responseText;
            var res = str.split("~");

            var num = [];
            $.each(res, function (index, value) {
                num.push(value.replace(/[^0-9\/]/g, ''));

            });

            var newArray = num.filter(function (v) {
                return v !== ''
            });

            console.log(num[num.length - 2]);


            $($this).empty();
            $($this).text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);



        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) { /* streaming DONE */
                myobSynchronizeDone($this);
                funcState = null;
            }
        }
        xhr.send();
    }

    function myobSynchronizeDone($this) {
        $($this).empty();
        $($this).text('MYOB syncronized!');
    }
</script>