<?php
//$myobsignMenu = null;
//$myobsignout = null;
//if (myob_api_oauth::hasAccess()) {
//    $myobsignMenu = array('label' => 'Connected to MYOB AccountRight', 'url' => array('#'), 'linkOptions' => array('style' => "background-color:green;", 'onclick' => "return false;"));
//    $myobsignout = array('label' => 'Sign Out MYOB AccountRight', 'url' => array('myob/signout'), 'linkOptions' => array('style' => "background-color:#CC3300;"));
//} else {
//    $myobsignMenu = array('label' => 'Sign in to MYOB AccountRight', 'url' => array('#'), 'linkOptions' => array('onclick' => "redirecttomyob();return false;"));
//}
//
//$this->menu = array(
//    $myobsignout,
//    $myobsignMenu,
//);
?>

<h1>Myob Settings</h1>

<span id="myob-auth-link" style="display: none;">
	<?php
	$auth = new MYOBAuth(MyobSetting::getSettings());

	echo $auth->createSigninURL();
	?>
</span>
<div>
	<?php	
	foreach (Yii::app()->user->getFlashes() as $key => $message) {
		echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
	}
	?>
</div>


<div class="form">

	<?php
	$form = $this->beginWidget('CActiveForm', array(
		'id' => 'myob-form',
		'enableAjaxValidation' => false,
	));
	?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>
    <div class="view">
        <div class="row">
			<?php echo $form->labelEx($model, 'auto_send_invoice'); ?>
			<?php echo $form->checkBox($model, 'auto_send_invoice'); ?>
			<?php echo $form->error($model, 'auto_send_invoice'); ?>
        </div>
		 <div class="row">
			<?php echo $form->labelEx($model, 'auto_send_po'); ?>
			<?php echo $form->checkBox($model, 'auto_send_po'); ?>
			<?php echo $form->error($model, 'auto_send_po'); ?>
        </div>
        <div class="clear"></div>
    </div>
    <div class="view">

		<?php
		if (in_array(strtolower(Yii::app()->user->title), array('superadmin'))) {
			?>
			<h3>General Settings</h3>
			<div class="row">
				<?php echo $form->labelEx($model, 'environment'); ?>
				<?php echo $form->dropDownList($model, 'environment', 
						array(
							MyobSetting::ENVIRONMENT_SANDBOX_ACCOUNT => 'SandBox Account (Development Environment)',
							MyobSetting::ENVIRONMENT_LIVE_ACCOUNT => 'Live Account (Client Live Account)'
							)
						); ?>
				<?php echo $form->error($model, 'environment'); ?>
			</div>
			<div class="clear"></div>
			
			<div class="row">
				<?php echo $form->labelEx($model, 'api_key'); ?>
				<?php echo $form->textField($model, 'api_key', array('size' => 60, 'maxlength' => 100)); ?>
				<?php echo $form->error($model, 'api_key'); ?>
			</div>
			<div class="row">
				<?php echo $form->labelEx($model, 'api_secret'); ?>
				<?php echo $form->textField($model, 'api_secret', array('size' => 60, 'maxlength' => 100)); ?>
				<?php echo $form->error($model, 'api_secret'); ?>
			</div>           
			<div class="clear"></div>
			<div class="row">
				<?php echo $form->labelEx($model, 'myob_company_name'); ?>
				<?php echo $form->textField($model, 'myob_company_name', array('size' => 60, 'maxlength' => 100, 'readonly' => MyobSetting::iscompanyRegisteredLocally())); ?>				
				<p style="color:red;">Once your local account bind with this company, you cannot change this account unless you reset the local account!</p>
				<?php echo $form->error($model, 'myob_company_name'); ?>
			</div>    
			<div class="clear"></div>
			<div class="row">
				<?php echo $form->labelEx($model, 'company_username'); ?>
				<?php echo $form->textField($model, 'company_username', array('size' => 60, 'maxlength' => 100)); ?>
				<?php echo $form->error($model, 'company_username'); ?>
			</div>
			<div class="row">
				<?php echo $form->labelEx($model, 'company_paassword'); ?>
				<?php echo $form->textField($model, 'company_paassword', array('size' => 60, 'maxlength' => 100)); ?>
				<?php echo $form->error($model, 'company_paassword'); ?>
			</div>
			<div class="clear"></div>
			<div class="row" style="width:100%;">
				<?php echo $form->labelEx($model, 'redirect_url'); ?>
				<?php echo $form->textField($model, 'redirect_url', array('style' => 'width:65%;')); ?>
				<?php echo $form->error($model, 'redirect_url'); ?>
			</div>
			<div class="clear"></div>
			<div class="row" style="width:100%;">
				<?php echo $form->labelEx($model, 'base_url'); ?>
				<?php echo $form->textField($model, 'base_url', array('style' => 'width:65%;')); ?>
				<?php echo $form->error($model, 'base_url'); ?>
			</div>
			<div class="clear"></div> 
			<div class="row">
				<?php echo $form->labelEx($model, 'access_token_expires_in'); ?>
				<?php echo $form->textField($model, 'access_token_expires_in', array('size' => 60, 'maxlength' => 100)); ?>
				<?php echo $form->error($model, 'access_token_expires_in'); ?>
			</div>
			<div class="clear"></div> 
			<div class="row">
				<?php echo $form->labelEx($model, 'myob_guid_uuid'); ?>
				<?php
				echo $form->dropDownList($model, 'myob_guid_uuid', CHtml::listData(MYOBGuide::model()->findAll(array('order' => 'account_name ASC')), 'uuid', 'account_name'), array('empty' => ''));
				?>
				<?php echo $form->error($model, 'myob_guid_uuid'); ?>
			</div>
			<div class="clear"></div> 

		</div>

		<div class="clear"></div> 
		<?php
	}
	?>
    <div class="view">
        <h4>Customer Related Settings</h4>
        <div class="clear"></div>
        <div class="row">

			<?php echo $form->labelEx($model, 'cus_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'cus_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'cus_taxcode_id'); ?>


        </div>
        <div class="row">

			<?php echo $form->labelEx($model, 'cus_freight_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'cus_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'cus_freight_taxcode_id'); ?>


        </div>
        <div class="clear"></div> 
    </div>
    <div class="clear"></div>
    <div class="view">
        <h4>Product Related Settings</h4>
		<div>&nbsp;</div>
		<div class="row">

			<?php echo $form->labelEx($model, 'update_products_from_myob'); ?>
			<?php echo $form->checkBox($model, 'update_products_from_myob'); ?>
			<?php echo $form->error($model, 'update_products_from_myob'); ?>


        </div>
        <div class="clear"></div>
        <div class="row">
			<?php echo $form->labelEx($model, 'prd_expns_accnt_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_expns_accnt_id', 
					CHtml::listData(MyobAccount::model()->findAll(
					array('condition' =>'type = "Expense"', 'select'=>"id, CONCAT(name, ' [ ', displayId, ' ]') AS accountDisplay")
					), 'id', 'accountDisplay'), 
					array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_expns_accnt_id'); ?>
        </div>
        <div class="row">
			<?php echo $form->labelEx($model, 'prd_incm_accnt_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_incm_accnt_id', 
					CHtml::listData(MyobAccount::model()->findAll(
					array('condition' =>'type = "Income"', 'select'=>"id, CONCAT(name, ' [ ', displayId, ' ]') AS accountDisplay")
					), 'id', 'accountDisplay'), 
					array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_incm_accnt_id'); ?>
        </div>

        <div class="row">
			<?php echo $form->labelEx($model, 'prd_buying_taxcode_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_buying_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_buying_taxcode_id'); ?>
        </div>

        <div class="row">
			<?php echo $form->labelEx($model, 'prd_selling_taxcode_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_selling_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_selling_taxcode_id'); ?>
        </div>
		
		 <div class="row">
			<?php echo $form->labelEx($model, 'prd_buying_freight_taxcode_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_buying_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_buying_freight_taxcode_id'); ?>
        </div>

        <div class="row">
			<?php echo $form->labelEx($model, 'prd_selling_freight_taxcode_id'); ?>
			<?php
			echo $form->dropDownList($model, 'prd_selling_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
			?>
			<?php echo $form->error($model, 'prd_selling_freight_taxcode_id'); ?>
        </div>
        <div class="clear"></div> 
    </div>
    <div class="clear"></div>
    <div class="view">
        <h4>Invoice Related Settings</h4>
        <div class="clear"></div>
        <div class="row">

			<?php echo $form->labelEx($model, 'inv_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'inv_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'inv_taxcode_id'); ?>


        </div>
		<div class="row">

			<?php echo $form->labelEx($model, 'inv_freight_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'inv_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'inv_freight_taxcode_id'); ?>


        </div>
        <div class="clear"></div> 
    </div>
	<div class="clear"></div>
    <div class="view">
        <h4>Purchase Order Related Settings</h4>
        <div class="clear"></div>
        <div class="row">

			<?php echo $form->labelEx($model, 'po_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'po_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'po_taxcode_id'); ?>


        </div>	
		<div class="row">

			<?php echo $form->labelEx($model, 'po_freight_taxcode_id'); ?>
			<?php echo $form->dropDownList($model, 'po_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
			<?php echo $form->error($model, 'po_freight_taxcode_id'); ?>


        </div>
        <div class="clear"></div> 
    </div>
    <div style="width: 100%;">
		<?php echo CHtml::submitButton('Save', array('style' => 'float:right;')); ?>
    </div>
    <div class="clear"></div>




	<?php $this->endWidget(); ?>

</div><!-- form -->

<script>
    function redirecttomyob() {
        window.location = $('#myob-auth-link').text();
    }
</script>


