<?php
$myobsignMenu = null;
$myobsignout = null;
if (myob_api_oauth::hasAccess()) {
    $myobsignMenu = array('label' => 'Connected to MYOB AccountRight', 'url' => array('#'), 'linkOptions' => array('style' => "background-color:green;", 'onclick' => "return false;"));
    $myobsignout = array('label' => 'Sign Out MYOB AccountRight', 'url' => array('myob/signout'), 'linkOptions' => array('style' => "background-color:#CC3300;"));
} else {
    $myobsignMenu = array('label' => 'Sign in to MYOB AccountRight', 'url' => array('#'), 'linkOptions' => array('onclick' => "redirecttomyob();return false;"));
}

$this->menu = array(
    $myobsignout,
    $myobsignMenu,
);
?>

<h1>Myob Settings</h1>

<span id="myob-auth-link" style="display: none;">
    <?php
    $settings = MyobSetting::getSettings();

    $encodedUrl = urlencode($settings->redirect_url);
    echo 'https://secure.myob.com/oauth2/account/authorize?client_id=' . $settings->api_key . '&redirect_uri=' . $encodedUrl . '&response_type=code&scope=' . $settings->api_scope;
    ?>
</span>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>


<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'myob-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <div class="view">

        <?php
        if (in_array(Yii::app()->user->title, array('SuperAdmin'))) {
            ?>
            <h3>General Settings</h3>
            <div class="row">
                <?php echo $form->labelEx($model, 'api_key'); ?>
                <?php echo $form->textField($model, 'api_key', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'api_key'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'api_secret'); ?>
                <?php echo $form->textField($model, 'api_secret', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'api_secret'); ?>
            </div>

            <div class="clear"></div>

            <div class="row">
                <?php echo $form->labelEx($model, 'api_scope'); ?>
                <?php echo $form->textField($model, 'api_scope', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'api_scope'); ?>
            </div>
            <div class="clear"></div>
            <div class="row">
                <?php echo $form->labelEx($model, 'company_username'); ?>
                <?php echo $form->textField($model, 'company_username', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'company_username'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'company_paassword'); ?>
                <?php echo $form->textField($model, 'company_paassword', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'company_paassword'); ?>
            </div>
            <div class="clear"></div>
            <div class="row" style="width:100%;">
                <?php echo $form->labelEx($model, 'api_url'); ?>
                <?php echo $form->textField($model, 'api_url', array('style' => 'width:65%;')); ?>
                <?php echo $form->error($model, 'api_url'); ?>
            </div>
            <div class="clear"></div>
            <div class="row" style="width:100%;">
                <?php echo $form->labelEx($model, 'redirect_url'); ?>
                <?php echo $form->textField($model, 'redirect_url', array('style' => 'width:65%;')); ?>
                <?php echo $form->error($model, 'redirect_url'); ?>
            </div>
            <div class="clear"></div>
            <div class="row" style="width:100%;">
                <?php echo $form->labelEx($model, 'base_url'); ?>
                <?php echo $form->textField($model, 'base_url', array('style' => 'width:65%;')); ?>
                <?php echo $form->error($model, 'base_url'); ?>
            </div>
            <div class="clear"></div> 

        </div>

        <div class="clear"></div> 
        <?php
    }
    ?>
    <div class="view">
        <h4>Customer Related Settings</h4>
        <div class="clear"></div>
        <div class="row">

            <?php echo $form->labelEx($model, 'cus_taxcode_id'); ?>
            <?php echo $form->dropDownList($model, 'cus_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'cus_taxcode_id'); ?>


        </div>
        <div class="row">

            <?php echo $form->labelEx($model, 'cus_freight_taxcode_id'); ?>
            <?php echo $form->dropDownList($model, 'cus_freight_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'cus_freight_taxcode_id'); ?>


        </div>
        <div class="clear"></div> 
    </div>
    <div class="clear"></div>
    <div class="view">
        <h4>Product Related Settings</h4>
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'prd_expns_accnt_id'); ?>
            <?php
            echo $form->dropDownList($model, 'prd_expns_accnt_id', CHtml::listData(MyobAccount::model()->findAll(), 'id', 'name'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'prd_expns_accnt_id'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'prd_incm_accnt_id'); ?>
            <?php
            echo $form->dropDownList($model, 'prd_incm_accnt_id', CHtml::listData(MyobAccount::model()->findAll(), 'id', 'name'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'prd_incm_accnt_id'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'prd_buying_taxcode_id'); ?>
            <?php
            echo $form->dropDownList($model, 'prd_buying_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'prd_buying_taxcode_id'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'prd_selling_taxcode_id'); ?>
            <?php
            echo $form->dropDownList($model, 'prd_selling_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'prd_selling_taxcode_id'); ?>
        </div>
        <div class="clear"></div> 
    </div>
    <div class="clear"></div>
    <div class="view">
        <h4>Invoice Related Settings</h4>
        <div class="clear"></div>
        <div class="row">

            <?php echo $form->labelEx($model, 'inv_taxcode_id'); ?>
            <?php echo $form->dropDownList($model, 'inv_taxcode_id', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'inv_taxcode_id'); ?>


        </div>
        <div class="clear"></div> 
    </div>
    <div style="width: 100%;">
        <?php echo CHtml::submitButton('Save', array('style' => 'float:right;')); ?>
    </div>
    <div class="clear"></div>




    <?php $this->endWidget(); ?>

</div><!-- form -->

<script>
    function redirecttomyob() {
        window.location = $('#myob-auth-link').text();
    }
</script>


