<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'myob-account-form',
	'enableAjaxValidation'=>false,
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

	

	<div class="row">
		<?php echo $form->labelEx($model,'name'); ?>
		<?php echo $form->textField($model,'name',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'displayId'); ?>
		<?php echo $form->textField($model,'displayId',array('size'=>6,'maxlength'=>6)); ?>
		<?php echo $form->error($model,'displayId'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'classification'); ?>
		<?php
                echo $form->dropDownList($model, 'classification', array(
                        'Asset' => 'Asset',
                        'Liability' => 'Liability',
                        'Equity' => 'Equity',
                        'Income' => 'Income',
                        'CostOfSales' => 'CostOfSales',
                        'Expense' => 'Expense',
                        'OtherIncome' => 'OtherIncome',
                        'OtherExpense' => 'OtherExpense'
                    ), array('empty' => '-- Select --'));
                ?>
		<?php echo $form->error($model,'classification'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'type'); ?>
		<?php echo $form->textField($model,'type',array('size'=>45,'maxlength'=>45, 'readonly'=>true,'value'=>'Bank')); ?>
		<?php echo $form->error($model,'type'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'number'); ?>
		<?php echo $form->textField($model,'number'); ?>
		<?php echo $form->error($model,'number'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'taxCodeId'); ?>
		<?php
                echo $form->dropDownList($model,'taxCodeId', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty'=>''));
                ?>
		<?php echo $form->error($model,'taxCodeId'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'openingBalance'); ?>
		<?php echo $form->textField($model,'openingBalance',array('size'=>13,'maxlength'=>13)); ?>
		<?php echo $form->error($model,'openingBalance'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'currentBalance'); ?>
		<?php echo $form->textField($model,'currentBalance',array('size'=>13,'maxlength'=>13)); ?>
		<?php echo $form->error($model,'currentBalance'); ?>
	</div>
        
        <div class="row" style="width: 100%;">
		<?php echo $form->labelEx($model,'description'); ?>
		<?php echo $form->textField($model,'description',array('maxlength'=>255,'style'=>"width:66%;")); ?>
		<?php echo $form->error($model,'description'); ?>
	</div>
	
        <div class="clear"></div>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->