<?php


$refreshMyobMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
	$refreshMyobMenu = array(
		'label' => 'Synchronize MYOB Suppliers',
		'url' => array('#'),
		'linkOptions' => array(
			'onclick' => 'myobSynchronizeAll(this);return false;',
			'data-loading-text' => "MYOB Suppliers Synchronizing...",
			'data-done-text' => "MYOB Suppliers Synchronized!",
			'data-error-text' => "MYOB Synchronizing Error!",
			'style' => 'background-color:#32cd32')
);
}

$this->menu = array(
	$refreshMyobMenu,
	
    //array('label' => 'Create Supplier', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('supplier-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
//$thissup = 'S0001';
//for($i=0;$i<10; $i++){
//    echo $thissup++ . '<br>';
//}
?>

<h1>Manage MYOB Suppliers</h1>
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist" style="margin-top: 2%;">

    <li class="active"><a href="#suppler-sec" role="tab" data-toggle="tab" >Suppliers</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import/Export</a></li>

</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="suppler-sec" style="padding-top: 0;margin-top: 0;">
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'supplier-grid',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'columns' => array(
                //'supsno',
                'supsup',
                'supsup_fref',
                'supnam',
                array(
                    'name' => 'supad1',
                    'value' => '$data->getFullAddress()',
                ),
                array(
                    'name' => 'suptel',
                    // 'value'=>'$data->getTelFax()',
                    'type' => 'raw',
                ),
                'supemail',
                'supcontact',
                /*
                  'supad3',
                  'suptown',
                  'supstate',
                  'suppostcode',
                  'supcousno',
                  'suptypsno',
                  'suptel',
                  'supfax',
                  'supemail',
                  'supmrate',
                  'supucdnew',
                  'supentddt',
                  'supenttime',
                  'supucdame',
                  'supameddt',
                  'supametime',
                 */
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}{sep1}{delete}',
                    'buttons' => array(
                        'view' => array
                            (
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                        'sep1' => array
                            (
                            'label' => ' | ',
                            'url' => '',
                            'imageUrl' => false,
                        ),                        
                        'delete' => array
                            (
                            'label' => 'Delete',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>

    </div>
    <div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">
        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'sup-export-form',
                    'enableAjaxValidation' => false,
                ));
                ?>


                <?php
                echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
                echo CHtml::submitButton('Export Suppliers as Excel', array('name' => 'sup-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>        
    </div>
</div>

<?php
if (!empty($message)) {
    ?>

    <div class="view" >
        <h3><a href="#" onclick="showlogdtl();return false;">Import Log Details</a></h3>
        <div id="log-dtl-sec" style="display: none;">
            <?php
            if (!empty($message['supplier_ok'])) {
                echo '<h4>Supplier Import Log <h4>';
                echo '<pre>' . $message['supplier_ok'] . '</pre>';
            }

            if (!empty($message['supplier_error'])) {
                echo '<h4>Error Import Log <h4>';
                echo '<pre>' . $message['supplier_error'] . '</pre>';
            }

            if (!empty($message['supplier_issue'])) {
                echo '<h4>Issues Import Log <h4>';
                echo '<pre>' . $message['supplier_issue'] . '</pre>';
            }
            ?>
        </div>
    </div>

    <?php
}
?>

<script>

    function showlogdtl() {
        $('#log-dtl-sec').toggle();
    }    
	
	function myobSynchronizeAll(e)
    {
        var $this = $(e);
        startMyobStreaming($this);
        $this.button('loading');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("myobSupplier/MYOBSyncronizeAll"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
				 myobSynchronizeDone($this);
            },
            error: function (result) {
                //$this.button('error');
                console.log(result);
            }
        });
    }

    function startMyobStreaming($this) { /* $this refer to trigered element */
        xhr = new XMLHttpRequest();
        xhr.open("GET", "<?php echo Yii::app()->createUrl("myobSupplier/MYOBSyncronizeAll"); ?>", true);
        xhr.onprogress = function (e) {

            var str = e.currentTarget.responseText;
            var res = str.split("~");

            var num = [];
            $.each(res, function (index, value) {
                num.push(value.replace(/[^0-9\/]/g, ''));

            });

            var newArray = num.filter(function (v) {
                return v !== ''
            });

            console.log(num[num.length - 2]);


            $this.empty();
            $this.text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);



        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) { /* streaming DONE */
                myobSynchronizeDone($this);
            }
        }
        xhr.send();
    }

    function myobSynchronizeDone($this) {
        $this.button('done');
        $('#supplier-grid').yiiGridView('update');
    }
</script>