<?php
$this->breadcrumbs=array(
	'Suppliers'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List Supplier', 'url'=>array('index')),
	array('label'=>'Create Supplier', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('supplier-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Suppliers</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'supplier-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		//'supsno',
		'supsup',
		'supsup_fref',
		'supnam',
		array(
                    'name'=>'supad1',
                    'value'=>'$data->getFullAddress()',
                ),
                array(
                    'name'=>'suptel',
                    'value'=>'$data->getTelFax()',
                    'type'=>'raw',
                ),
                'supemail',
            'supmrate',
		/*
		'supad3',
		'suptown',
		'supstate',
		'suppostcode',
		'supcousno',
		'suptypsno',
		'suptel',
		'supfax',
		'supemail',
		'supmrate',
		'supucdnew',
		'supentddt',
		'supenttime',
		'supucdame',
		'supameddt',
		'supametime',
		*/
		array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'update' => array
                 (
                    'label' => 'Update',
                    'imageUrl' => false,                    
                ),
                'sep2' => array
                 (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'delete' => array
                (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
	),
)); ?>
