<?php


$this->menu = array(
    array('label' => 'Refresh MYOB Tax Codes', 'url' => array('refresh'),'linkOptions'=>array('style'=>"background-color:green;")),
    array('label' => 'Create MYOB Tax Code', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('myob-tax-code-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage MYOB Tax Codes</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'myob-tax-code-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        'uuid',
        'code',
        'description',
        'type',
        'rate',
        array(
            'name' => 'taxCollectedAccountId',
            'value' => 'MyobAccount::model()->findByPk($data->taxCollectedAccountId)->name'
        ),
        array(
            'name' => 'taxPaidAccountId',
            'value' => 'MyobAccount::model()->findByPk($data->taxPaidAccountId)->name'
        ),
        /*
          'row_version',
         */
        array(
            'class' => 'CButtonColumn',
        ),
    ),
));
?>
