<?php

$refreshMyobMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
	$refreshMyobMenu = array(
		'label' => 'Synchronize MYOB Tax Codes',
		'url' => array('#'),
		'linkOptions' => array(
			'onclick' => 'myobSynchronizeAll(this);return false;',
			'data-loading-text' => "MYOB Tax Codes Synchronizing...",
			'data-done-text' => "MYOB Tax Codes Synchronized!",
			'data-error-text' => "MYOB Synchronizing Error!",
			'style' => 'background-color:#32cd32')
	);
}
$this->menu = array(
    $refreshMyobMenu,
    array('label' => 'Create MYOB Tax Code', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('myob-tax-code-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage MYOB Tax Codes</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'myob-tax-code-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        'uuid',
        'code',
        'description',
        'type',
        'rate',
        array(
            'name' => 'taxCollectedAccountId',
            'value' => 'MyobAccount::model()->findByPk($data->taxCollectedAccountId)->name'
        ),
        array(
            'name' => 'taxPaidAccountId',
            'value' => 'MyobAccount::model()->findByPk($data->taxPaidAccountId)->name'
        ),
        /*
          'row_version',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
<script type="text/javascript">
    function myobSynchronizeAll(e)
    {
        var $this = $(e);
        startMyobStreaming($this);
        $this.button('loading');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("myobTaxCode/MYOBSyncronizeAll"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
				 myobSynchronizeDone($this);
            },
            error: function (result) {
                //$this.button('error');
                console.log(result);
            }
        });
    }

    function startMyobStreaming($this) { /* $this refer to trigered element */
        xhr = new XMLHttpRequest();
        xhr.open("GET", "<?php echo Yii::app()->createUrl("myobTaxCode/MYOBSyncronizeAll"); ?>", true);
        xhr.onprogress = function (e) {

            var str = e.currentTarget.responseText;
            var res = str.split("~");

            var num = [];
            $.each(res, function (index, value) {
                num.push(value.replace(/[^0-9\/]/g, ''));

            });

            var newArray = num.filter(function (v) {
                return v !== ''
            });

            console.log(num[num.length - 2]);


            $this.empty();
            $this.text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);



        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) { /* streaming DONE */
                myobSynchronizeDone($this);
            }
        }
        xhr.send();
    }

    function myobSynchronizeDone($this) {
        $this.button('done');
        $('#myob-tax-code-grid').yiiGridView('update');
    }
</script>