<?php
$myobAuth = new MYOBAuth(MyobSetting::getSettings());
$myobSyncronizeMenu = null;
if ($myobAuth->checkAccess()) {
	//$loadinghtml = '&nbsp;<img class="loading-myob" src="images/loading_bar.gif" style="width:60px;height:25px;display:none;">';
	$myobSyncronizeMenu = array(
		'label' => 'Synchronize MYOB',
		'url' => array('#'),
		'linkOptions' => array(
			'id' => $model->id,
			'onclick' => 'myobSynchronize(this);return false;',
			'data-loading-text' => "MYOB Synchronizing...",
			'data-done-text' => "MYOB Synchronized!",
			'data-error-text' => "MYOB Synchronizing Error!",
			'style' => 'background-color:#32cd32')
	);
}

$this->menu = array(
	$myobSyncronizeMenu,
	//array('label'=>'List MyobTaxCode', 'url'=>array('index')),
	//array('label'=>'Create MYOB Tax Code', 'url'=>array('create')),
	array('label' => 'Update MYOB Tax Code', 'url' => array('update', 'id' => $model->id)),
	array('label' => 'Delete MYOB Tax Code', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
	array('label' => 'Manage MYOB Tax Codes', 'url' => array('admin')),
);
?>

<h1>View MYOB Tax Code [ <?php echo $model->code; ?> ]</h1>
<div>
	<?php
	foreach (Yii::app()->user->getFlashes() as $key => $message) {
		echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
	}
	?>
</div>
<?php echo $model->getMYOBError(); ?>


<?php
$this->widget('zii.widgets.CDetailView', array(
	'data' => $model,
	'attributes' => array(
		'id',
		'uuid',
		'code',
		'description',
		'type',
		'rate',
		array(
			'name' => 'taxCollectedAccountId',
			'value' => MyobAccount::model()->findByPk($model->taxCollectedAccountId)->name
		),
		array(
			'name' => 'taxPaidAccountId',
			'value' => MyobAccount::model()->findByPk($model->taxPaidAccountId)->name
		),
		array(
			'name' => 'systemTaxRateId',
			'value' => $model->systemTaxRateId ? (SystemTaxCode::model()->findByPk($model->systemTaxRateId)->code . ' [ ' . SystemTaxCode::model()->findByPk($model->systemTaxRateId)->rate . ' ]') : ""
		),
	),
));
?>
<script type="text/javascript">
    function myobSynchronize(e)
    {
        var $this = $(e);
        $this.button('loading');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("myobTaxCode/MYOBSyncronize"); ?>',
            data: {'id': $(e).attr('id')},
            dataType: 'json',
            success: function (result) {
                $this.button('done');
            },
            error: function (result) {
                $this.button('error');
                console.log(result);
            }
        });
    }
</script>