<?php


$this->menu=array(
	//array('label'=>'List OtherCostType', 'url'=>array('index')),
	array('label'=>'Create Other Cost Type', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('other-cost-type-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Other Cost Types</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'other-cost-type-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
            array(
                'name'=>'cost_group_name_search',
                'value'=>'$data->other_cost_group_id ? OtherCostGroup::model()->findByPk($data->other_cost_group_id)->name : null',
                
            ),
		'name',
            
            array(
                'name'=>'default_cost',
                'value'=>'number_format($data->default_cost,2)',
                'htmlOptions'=>array('style'=>"text-align:right")
            ),
            array(
                'name'=>'devide_by_qty',
                'value'=>'$data->devide_by_qty?"YES":"NO"'
            ),
		array(
                    'name'=>'created_by',
                    'value'=>'User::model()->findByPk($data->created_by)->username'
                ),
		'created_date',
		array(
            'class' => 'CButtonColumn',
            'template' => '{update}{sep1}{delete}',
            'buttons' => array(  
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),                
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
	),
)); ?>
