<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'pdsub-job-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'PDSubJobName'); ?>
<?php
echo $form->textField($model, 'jobId', array('value'=>$model->jobId, 'style'=>'display:none;'));
echo $form->textField($model, 'PDSubJobName', array('size' => 60, 'maxlength' => 100));
?>
<?php echo $form->error($model, 'PDSubJobName'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'dueDate'); ?>
        <?php
        
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'dueDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
<?php echo $form->error($model, 'dueDate'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'followUpDate'); ?>
<?php
        
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followUpDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
<?php echo $form->error($model, 'followUpDate'); ?>
    </div>

    <div class="clear"></div>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'sales-order-grid',
        'dataProvider' => $dataProvider,
        'filter' => null,
        'columns' => array(
            'id',
            array(
                'name' => 'id',
                'value' => 'CHtml::textField("JobProductDecorations[ids][$data->id]",$data->id)',
                'type' => 'raw',
                'headerHtmlOptions' => array('style' => 'display:none'),
                'htmlOptions' => array('style' => 'display:none'),
            ),
            array(
                'name' => 'workorderDtl.image',
                'type' => 'raw',
                'value' => 'CHtml::image($data->workorderDtl->getImg())',
                'htmlOptions' => array('style' => 'width:100px;'),
            ),
            array(
                'name' => 'workorderDtl.productsku',
                'value' => '!empty($data->workorderDtl->productsku) ? $data->workorderDtl->prdsrtdesc . $data->workorderDtl->getProdSupplierLink() : $data->workorderDtl->custmproduct . $data->workorderDtl->getProdSupplierLink()',
                'type' => 'raw',
            ),
            array(
                'name' => 'workorderDtl.prdlngdesc',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:200px;'),
                'value' => '$data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
            ),
            array(
                'name' => 'decprtnam',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:150px;'),
                'value' => '$data->getProductDecorationRaw()',
                'footer' => 'Total',
            ),
            array(
                'name' => 'decoQty',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
        ),
    ));
    ?>
    <?php
    if(isset($pdsubjoblist)){
    ?>
    <div class="view">
    <h3>Sub Jobs</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'product-decoration-subjob-grid',
        'dataProvider' => $pdsubjoblist->search(),
        'filter' => null,
        'columns' => array(
            array(
                'name' => 'sortOrderval',
                'type' => 'raw',
                'value' => 'CHtml::textField(PDSubJobList::model()->sortOrderval,$data->sortOrderval,array("style"=>"width:85%;", "id"=>"sortOrderval_" . $data->id,"onchange"=>"subjobupdate($data->id,\'sortOrderval\');"))',
                'htmlOptions' => array('style' => 'width:8%;')
            ),
            array(
                'name' => 'subjob.jobCategory',
            //'value' => '$data->subjob->name',
            ),
            array(
                'name' => 'subJobId',
                'value' => '$data->subjob->name',
            ),
            //'jobArtworkId',
            array(
                'name' => 'note',
                'type' => 'raw',
                'value' => 'CHtml::textField(PDSubJobList::model()->note,$data->note,array("style"=>"width:98%;", "id"=>"note_" . $data->id,"onchange"=>"subjobupdate($data->id,\'note\');"))',
                'htmlOptions' => array('style' => 'width:25%;')
            ),
            array(
                'name' => 'statusId',
                'type' => 'raw',
                //'value'=>'$data->RelStatus->name',
                'value' => 'CHtml::dropDownList(PDSubJobList::model()->statusId,$data->RelStatus->id, Chtml::listData(Status::model()->findAll(array("condition"=>"id in (1,4,10,11,17,18,19,22,23)","order"=>"name asc")), "id", "name"),array("style"=>"width:90%;", "empty"=>"Select", "id"=>"statusId_" . $data->id, "onchange"=>"subjobupdate($data->id,\'statusId\');"))',
                'htmlOptions'=>array('style'=>'width:20%;')
            ),
            array(
                'name' => 'statusDate',
                'value' => 'date("Y-m-d H:i:s",strtotime($data->statusDate))'
            ),
            array(
                'name' => 'duedate',
                'value' => 'date("Y-m-d",strtotime($data->duedate))'
            ),
            array(
                            'class' => 'CButtonColumn',
                            'template' => '{delete}',
                            'buttons' => array(
                                'delete' => array
                                    (
                                    'label' => 'Delete',
                                    'imageUrl' => false,
                                    'url' => 'Yii::app()->createUrl("pdSubJobList/delete", array("id"=>$data->id))',
                                ),
                            ),
                        ),
        /*
          'createdBy',

          array(
          'class'=>'CButtonColumn',
          ),
         * 
         */
        ),
    ));
    ?>
    <div class="clear"></div>
    <div style="color: lightgreen;">All changes are saved automatically when change values.</div>
</div>
    <?php 
    }
    ?>
    <div class="view">
        <h3>Add Sub Jobs</h3>
        <?php
    Yii::app()->clientScript->registerScript('tr-event-propagation', '$("#sub-artwork-job-grid tr").click(function(event){
    event.stopPropagation();
});');
        
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'sub-artwork-job-grid',
            'dataProvider' => $subjobs->search(),
            'filter' => $subjobs,
            'selectableRows' => 100,
            'columns' => array(
                array(
                    'class' => 'CCheckBoxColumn',
                ),
                array(
                    'name'=>'jobCategory',
                    'filter'=>false,
                ),
                'productCategory',
                'name',
                array(
                    'name' => 'dueDate',
                    'value' => function ($data, $row, $column) {
                        $controller = $column->grid->owner;
                        $controller->widget('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker', array(
                            'model' => new SubArtworkJob(), //Model object
                            'attribute' => 'dueDate', //attribute name
                            'mode' => 'date', //use "time","date" or "datetime" (default)
                            'options' => array("dateFormat" => 'yy-mm-dd', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
                            'htmlOptions' => array('id' => 'dueDate_' . $data->id, 'value' => $data->dueDate, 'name' => "SubArtworkJob[dueDate][$data->id]"),
                            'language' => 'en-GB'
                        ));
                    },
                ),
            ),
        ));
        ?>

    </div>
    <div class="clear"></div>
    <div class="row buttons">
<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

<?php $this->endWidget(); ?>

</div><!-- form -->

<script>

    function checkDueDate() {

        var checkedcount = 0;
        var validdatecount = 0;
        var r = /^(\d{4})\-(\d{2})\-(\d{2})$/;
        $('#sub-artwork-job-grid table tbody tr').each(function(index, element) {
            var dateval = $(this).children('td:last-child').children('input').val();
            if (($(this).children('td:first-child').children('input[type=checkbox]').is(':checked') === true)) {
                checkedcount++;
                if (r.test(dateval))
                    validdatecount++;
            }

        });

        if (checkedcount !== 0 && validdatecount !== 0 && (checkedcount === validdatecount)) {
            $("#pdsub-job-form").submit();
        } else {
            alert('Date format not valid!');
        }
        ;
    }
    
    
    function subjobupdate(id, field) {
        var value = $('#' + field + '_' + id).val();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("pdSubJobList/updateField"); ?>',
            data: {'id': id, 'field': field, 'value': value},
            dataType: 'json',
            success: function(result) {

                //$.fn.yiiGridView.update("sales-log-grid");
                $.fn.yiiGridView.update("product-decoration-subjob-grid");
            },
            error: function(result) {
                alert('error in update');
            }
        });
    }

</script>