<?php
if (Yii::app()->user->checkAccess('Jobs.Admin')) {
    $backtojob = array('label' => 'Back to : ' . $model->job->jobNum, 'url' => array('jobs/view', 'id' => $model->job->id));
}

$this->menu = array(
    $backtojob,
    //array('label'=>'List PDSubJob', 'url'=>array('index')),
    //array('label'=>'Create PDSubJob', 'url'=>array('create')),
    array('label' => 'Update', 'url' => array('update', 'id' => $model->id)),
    //array('label'=>'Delete PDSubJob', 'url'=>'#', 'linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    array('label' => 'Manage', 'url' => array('admin')),
);
?>

<h1>View Product-Decoration Sub Job #<?php echo $model->id; ?></h1>

<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        array(
            'name'=>'jobId',
            'value'=>$model->job->jobNum
        ),
        'PDSubJobNum',
        'PDSubJobName',
        'dueDate',
        'followUpDate',
        'createdDate',
        'createdBy',
    ),
));
?>

<div class="view">
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'sales-order-grid',
        'dataProvider' => $dataProvider,
        'filter' => null,
        'columns' => array(
            'id',
            array(
                'name' => 'id',
                'value' => 'CHtml::textField("JobProductDecorations[ids][$data->id]",$data->id)',
                'type' => 'raw',
                'headerHtmlOptions' => array('style' => 'display:none'),
                'htmlOptions' => array('style' => 'display:none'),
            ),
            array(
                'name' => 'workorderDtl.image',
                'type' => 'raw',
                'value' => 'CHtml::image($data->workorderDtl->getImg())',
                'htmlOptions' => array('style' => 'width:100px;'),
            ),
            array(
                'name' => 'workorderDtl.productsku',
                'value' => '!empty($data->workorderDtl->productsku) ? $data->workorderDtl->prdsrtdesc . $data->workorderDtl->getProdSupplierLink() : $data->workorderDtl->custmproduct . $data->workorderDtl->getProdSupplierLink()',
                'type' => 'raw',
            ),
            array(
                'name' => 'workorderDtl.prdlngdesc',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:200px;'),
                'value' => '$data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
            ),
            array(
                'name' => 'decprtnam',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:150px;'),
                'value' => '$data->getProductDecorationRaw()',
                'footer' => 'Total',
            ),
            array(
                'name' => 'decoQty',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
        ),
    ));
    ?>
</div>

<div class="view">
    <h3>Sub Jobs</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'product-decoration-subjob-grid',
        'dataProvider' => $pdsubjoblist->search(),
        'filter' => null,
        'columns' => array(
            array(
                'name' => 'sortOrderval',
                'type' => 'raw',
                'value' => 'CHtml::textField(PDSubJobList::model()->sortOrderval,$data->sortOrderval,array("style"=>"width:85%;", "id"=>"sortOrderval_" . $data->id,"onchange"=>"subjobupdate($data->id,\'sortOrderval\');"))',
                'htmlOptions' => array('style' => 'width:8%;')
            ),
            array(
                'name' => 'subjob.jobCategory',
            //'value' => '$data->subjob->name',
            ),
            array(
                'name' => 'subJobId',
                'value' => '$data->subjob->name',
            ),
            //'jobArtworkId',
            array(
                'name' => 'note',
                'type' => 'raw',
                'value' => 'CHtml::textField(PDSubJobList::model()->note,$data->note,array("style"=>"width:98%;", "id"=>"note_" . $data->id,"onchange"=>"subjobupdate($data->id,\'note\');"))',
                'htmlOptions' => array('style' => 'width:25%;')
            ),
            array(
                'name' => 'statusId',
                'type' => 'raw',
                //'value'=>'$data->RelStatus->name',
                'value' => 'CHtml::dropDownList(PDSubJobList::model()->statusId,$data->RelStatus->id, Chtml::listData(Status::model()->findAll(array("condition"=>"id in (1,4,10,11,17,18,19,22,23)","order"=>"name asc")), "id", "name"),array("empty"=>"Select", "id"=>"statusId_" . $data->id, "onchange"=>"subjobupdate($data->id,\'statusId\');"))',
            //'htmlOptions'=>array('style'=>'width:45%;')
            ),
            array(
                'name' => 'statusDate',
                'value' => 'date("Y-m-d H:i:s",strtotime($data->statusDate))'
            ),
            array(
                'name' => 'duedate',
                'value' => 'date("Y-m-d",strtotime($data->duedate))'
            ),
        /*
          'createdBy',

          array(
          'class'=>'CButtonColumn',
          ),
         * 
         */
        ),
    ));
    ?>
    <div class="clear"></div>
    <div style="color: lightgreen;">All changes are saved automatically when change values.</div>
</div>

<script>
    function subjobupdate(id, field) {
        var value = $('#' + field + '_' + id).val();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("pdSubJobList/updateField"); ?>',
            data: {'id': id, 'field': field, 'value': value},
            dataType: 'json',
            success: function(result) {

                //$.fn.yiiGridView.update("sales-log-grid");
                $.fn.yiiGridView.update("product-decoration-subjob-grid");
            },
            error: function(result) {
                alert('error in update');
            }
        });
    }
</script>