<?php
$this->breadcrumbs=array(
	'Pdsub Job Lists'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List PDSubJobList', 'url'=>array('index')),
	//array('label'=>'Create PDSubJobList', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('pdsub-job-list-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Product-Decoration Sub Job Report</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'pdsub-job-list-grid',
	'dataProvider'=>$model->reportSearch(),
	'filter'=>$model,
	'columns'=>array(
		//'id',
                array(
                    'name'=>'job_search',
                    //'value'=>'$data->RelPDSubJob->job->jobNum',
                    'value'=>'CHtml::link($data->RelPDSubJob->job->jobNum,array("jobs/view","id"=>$data->RelPDSubJob->job->id),array("target"=>"_blank"))',
                'type'=>'raw',
                ),
		array(
                    'name'=>'pdsubjob_search',
                    //'value'=>'$data->RelPDSubJob->PDSubJobNum',
                    'value'=>'CHtml::link($data->RelPDSubJob->PDSubJobNum,array("pdSubJob/view","id"=>$data->RelPDSubJob->id),array("target"=>"_blank"))',
                    'type'=>'raw',
                ),
                'sortOrderval',
                array(
                    'name'=>'subjob_search',
                    'value'=>'$data->subjob->name'
                ),
		
		'note',
                 array(
                'name'=>'duedate',
                'value'=>'!empty($data->duedate) ? date(GlobalVars::get("DateFormat"),strtotime($data->duedate)) : null'
                ),
		array(
                'name'=>'statusId',
                'value'=>'$data->RelStatus->name',
                'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,4,10,11,17,18,19,22,23)")), 'id', 'name'),
            ),
                array(
                'name'=>'statusDate',
                'value'=>'!empty($data->statusDate) ? date(GlobalVars::get("DateFormat"),strtotime($data->statusDate)) : null'
                ),
            array(
                'name'=>'RelPDSubJob.createdDate',
                'value'=>'!empty($data->RelPDSubJob->createdDate) ? date(GlobalVars::get("DateFormat"),strtotime($data->RelPDSubJob->createdDate)) : null'
                ),
		
	),
)); ?>
