<?php


$this->menu = array(
    //array('label'=>'List ProductCategory', 'url'=>array('index')),
    array('label' => 'Create Category', 'url' => array('create')),
    array('label' => 'Update Category', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete Category', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Category', 'url' => array('admin')),
    array('label'=>'Manage Sub Category', 'url'=>array('productSubCategory/admin')),
    array('label'=>'Manage Products', 'url'=>array('productLine/admin')),
);
?>

<h1>View Product Category #<?php echo $model->id; ?></h1>

<div class="view">
    <h3>Category</h3>
    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model,
        'attributes' => array(
            'id',
            'name',
            'description',
            'createdDate',
            array(
                'name' => 'createdBy',
                'value' => $model->userRel->username,
            )
        ),
    ));
    ?>
</div>

<div class="view">
    <h3>Add Sub Category</h3>
<?php echo $this->renderPartial('_form', array('model' => $subcategory)); ?>
    <div class="clear"></div>
</div>
<div class="view">
    <h3>Sub Categories</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'product-sub-category-grid',
        'dataProvider' => $subcategory->search(),
        'filter' => $subcategory,
        'columns' => array(
            'id',
            //'productCategoryId',
            'name',
            'description',
            //'createdDate',
            //'createdBy',
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("productSubCategory/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));
    ?>

</div>
