<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'product-group-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'categoryId'); ?>
        <?php
        echo $form->dropDownList($model, 'categoryId', CHtml::listData(ProductCategory::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'categoryId'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'subCategoryId'); ?>
        <?php
        echo $form->dropDownList($model, 'subCategoryId', CHtml::listData(ProductSubCategory::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'subCategoryId'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'short_desc'); ?>
        <?php echo $form->textField($model, 'short_desc', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'short_desc'); ?>
    </div>

    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'long_desc'); ?>
        <?php echo $form->textArea($model, 'long_desc', array('rows' => 6, 'style' => 'width:610px;')); ?>
        <?php echo $form->error($model, 'long_desc'); ?>
    </div>

    <div class="clear"></div>



    <div class="row">
        <?php echo $form->labelEx($model, 'uploadimg'); ?>
        <?php echo $form->fileField($model, 'uploadimg', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'uploadimg'); ?>
    </div>

    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'image_url'); ?>
        <?php echo $form->textField($model, 'image_url', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'image_url'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'productDetailUrl'); ?>
        <?php echo $form->textField($model, 'productDetailUrl', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'productDetailUrl'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'downloadStyleSheetUrl'); ?>
        <?php echo $form->textField($model, 'downloadStyleSheetUrl', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'downloadStyleSheetUrl'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'quizAndAnswerUrl'); ?>
        <?php echo $form->textField($model, 'quizAndAnswerUrl', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'quizAndAnswerUrl'); ?>
    </div>
    <div class="clear"></div>
    


    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->