<?php

$this->menu = array(
    //array('label'=>'List ProductGroup', 'url'=>array('index')),
    array('label' => 'Create Product Group', 'url' => array('create')),
);


?>

<h1>Manage Product Groups</h1>

<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#product-sec" role="tab" data-toggle="tab" >Product Groups</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import/Export</a></li>

</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="product-sec" style="padding-top: 0;margin-top: 0;">
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'product-group-grid',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'columns' => array(
                'code',
                array(
                    'name'=>'category_name_search',
                    'value'=>'$data->categoryId?ProductCategory::model()->findByPk($data->categoryId)->name:null'
                    
                ),
                array(
                    'name'=>'sub_category_name_search', 
                    'value'=>'$data->subCategoryId?ProductSubCategory::model()->findByPk($data->subCategoryId)->name:null'
                    
                ),
                'short_desc',
                'long_desc',
                array(
                    'name' => 'image',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
                ),
                array(
                    'name' => 'productDetailUrl',
                    'type' => 'raw',
                    'value' => 'CHtml::link($data->productDetailUrl, $data->productDetailUrl, array("target" => "_blank"))',
                ),
                array(
                    'name' => 'created_date',
                    'value' => 'date("Y-m-d",strtotime($data->created_date))'
                ),
                array(
                    'name' => 'created_by',
                    'value' => 'User::model()->findbyPk($data->created_by)->username'
                ),
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}{sep}{update}{sep2}{delete}',
                    'buttons' => array(
                        'view' => array(
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                        'sep' => array(
                            'label' => ' | ',
                            'imageUrl' => false,
                        ),
                        'update' => array(
                            'label' => 'Update',
                            'imageUrl' => false,
                        ),
                        'sep2' => array(
                            'label' => ' | ',
                            'imageUrl' => false,
                        ),
                        'delete' => array(
                            'label' => 'Delete',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>
    </div>
    <div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">
        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'product-export-form',
                    'enableAjaxValidation' => false,
                ));
                ?>


                <?php
                echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
                echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>

        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'product-import-form',
                    'enableAjaxValidation' => false,
                    'htmlOptions' => array('enctype' => 'multipart/form-data'),
                ));
                ?>

                <div class="row">
                    <?php echo $form->labelEx($model, 'importFile'); ?>
                    <?php echo $form->fileField($model, 'importFile', array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo $form->error($model, 'importFile'); ?>

                    <?php echo CHtml::submitButton('Upload File', array('name' => 'import_btn')); ?>
                    <div>[Only xls, xlsx file types are allowed] </div>
                </div>
                <div class="clear"></div>
                <?php
                //echo CHtml::submitButton('Reset', array('name' => 'reset_btn','style' => 'margin-left:5px;float:right;'));
                //echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>


