<?php
$this->breadcrumbs = array(
    'Product Groups' => array('index'),
    $model->id,
);

$this->menu = array(
    //array('label'=>'List ProductGroup', 'url'=>array('index')),
    array('label' => 'Create', 'url' => array('create')),
    array('label' => 'Update', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage', 'url' => array('admin')),
);
?>

<h1>View Product Group #<?php echo $model->id; ?></h1>

<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'code',
        'short_desc',
        'long_desc',
        array(
            'name' => 'image',
            'type' => 'raw',
            'value' => CHtml::image($model->getImg(), '', array('width' => 100)),
        ),
        array(
            'name' => 'productDetailUrl',
            'type' => 'raw',
            'value' => CHtml::link($model->productDetailUrl, $model->productDetailUrl, array('target' => '_blank')),
        ),
        array(
            'name' => 'downloadStyleSheetUrl',
            'type' => 'raw',
            'value' => CHtml::link($model->downloadStyleSheetUrl, $model->downloadStyleSheetUrl, array('target' => '_blank')),
        ),
        array(
            'name' => 'quizAndAnswerUrl',
            'type' => 'raw',
            'value' => CHtml::link($model->quizAndAnswerUrl, $model->quizAndAnswerUrl, array('target' => '_blank')),
        ),
        
        
        'created_date',
        'created_by',
    ),
));
?>


<div class="tab-pane active view" id="product-sec" style="padding-top: 0;margin-top: 0;">
    <h3>Select Products to Group</h3>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'select-product-form',
    ));

    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'product-line-grid',
        'dataProvider' => $productline->searchForGroup(),
        'filter' => $productline,
        'selectableRows' => 100,
        'columns' => array(
            array(
                'class' => 'CCheckBoxColumn',
            ),
            'pdlsno',
            array(
                'name' => 'category_name_search',
                'value' => '$data->subcategoryRel->categoryRel->name'
            ),
            array(
                'name' => 'sub_category_name_search',
                'value' => '$data->subcategoryRel->name'
            ),
            array(
                'name' => 'pdlimage1',
                'type' => 'raw',
                'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
            ),
            array(
                'name' => 'pdlpdl',
                'value' => '$data->getCodeHtml()',
                'type' => 'html'
            ),
            //'pdlprdsno',
            'pdlprdline',
            //'pdlprinted',
            //'pdlcustomyn',
            'pdldes',
            //'pdlcolour',
            //'pdlflag',
            //'pdlimage2',
            //'pdlimage3',
            array(
                'name' => 'supplier_search',
                'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
            ),
            'pdluntprice',
            'sellingPrice',
            'qty_on_hand',
            // 'pdlleadtime',
            // 'pdlduration',
            //'pdlmob',
            // 'pdldecorationtype',
            //'pdlucdnew',
            // 'pdlentddt',
            // 'pdlenttime',
            // 'pdlucdame',
            // 'pdlameddt',
            // 'pdlametime',
            array(
                'class' => 'CButtonColumn',
                'template' => '{view}',
                'buttons' => array(
                    'view' => array(
                        'label' => 'View',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("productLine/view", array("id"=>$data->pdlsno))',
                    ),
                    
                )
            ),
        ),
    ));
    ?>
    <div class="buttons">
        <?php echo CHtml::submitButton('Add'); ?>
    </div>
    <?php $this->endWidget(); ?>
</div>



<div class="view">
    <h3>Grouped Products</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'grouped-product-grid',
        'dataProvider' => $productGRoupDtl->search(),
        'filter' => $productGRoupDtl,
        
        'columns' => array(   
            array(
                'header' => 'Image',
                'type' => 'raw',
                'value' => '$data->productLineRel?CHtml::image($data->productLineRel->getImg(), "", array("width" => 100)) : $data->id',
                
            ),
            array(
                'header' => 'Product Code',
                'value' => '$data->productLineRel?$data->productLineRel->getCodeHtml(): "this is not rel"',
                'type' => 'html'
            ),
            //'pdlprdsno',
            array(
                'header' => 'Short Description',
                'value' => '$data->productLineRel?$data->productLineRel->pdlprdline: "no rel"',
                'type' => 'html'
            ),
            
            //'pdlprinted',
            //'pdlcustomyn',
            array(
                'header' => 'Long Description',
                'value' => '$data->productLineRel?$data->productLineRel->pdldes:"no rel"',
                'type' => 'html'
            ),           
            //'pdlcolour',
            //'pdlflag',
            //'pdlimage2',
            //'pdlimage3',
            array(
                'header' => 'Supplier',
                'value' => '$data->productLineRel? (!empty($data->productLineRel->supplier)? $data->productLineRel->supplier->supnam : ""): "no rel"',
            ),
            array(
                'header' => 'Unit Cost',
                'value' => '$data->productLineRel?$data->productLineRel->pdluntprice:"no rel"',
                'type' => 'html'
            ),   
            array(
                'header' => 'Selling Price',
                'value' => '$data->productLineRel?$data->productLineRel->sellingPrice:"no rel"',
                'type' => 'html'
            ),  
            array(
                'header' => 'Qty On Hand',
                'value' => '$data->productLineRel?$data->productLineRel->qty_on_hand:"no rel"',
                'type' => 'html'
            ),  
            
            // 'pdlleadtime',
            // 'pdlduration',
            //'pdlmob',
            // 'pdldecorationtype',
            //'pdlucdnew',
            // 'pdlentddt',
            // 'pdlenttime',
            // 'pdlucdame',
            // 'pdlameddt',
            // 'pdlametime',
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("productGroupDetail/delete", array("id"=>$data->id))',
                    ),
                    
                )
            ),
        ),
    ));
    ?>
</div>

