<?php
Yii::app()->clientScript->registerScript('searchProduct', "

$('.product-search-form form').submit(function(){
	$.fn.yiiGridView.update('product-line-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>
<div class="product-search-form">
    <div class="form view">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'action' => Yii::app()->createUrl($this->route),
            'method' => 'get',
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <div class="row">
            <?php echo $form->labelEx($model, 'pdlpdl'); ?>
            <?php echo $form->textField($model, 'pdlpdl'); ?>
            <?php echo $form->error($model, 'pdlpdl'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'pdlprdline'); ?>
            <?php echo $form->textField($model, 'pdlprdline'); ?>
            <?php echo $form->error($model, 'pdlprdline'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'pdldes'); ?>
            <?php echo $form->textField($model, 'pdldes'); ?>
            <?php echo $form->error($model, 'pdldes'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'supplier_search'); ?>
            <?php echo $form->textField($model, 'supplier_search'); ?>
            <?php echo $form->error($model, 'supplier_search'); ?>
        </div>
        <div class="clear"></div> 
        <div class="row buttons">
            <?php echo CHtml::submitButton('Search'); ?>
        </div>
        <div class="clear"></div> 
        <?php $this->endWidget(); ?>
    </div><!-- form -->
</div>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'product-line-grid',
    'dataProvider' => $model->searchForSelectPopup(),
    'filter' => null,
    'selectableRows' => 1,
    'columns' => array(
        array(
            'class' => 'CCheckBoxColumn',
        ),
        'pdlsno',
        array(
            'name' => 'pdlimage1',
            'type' => 'raw',
            'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
        ),
        array(
            'name' => 'pdlpdl',
            'value' => '$data->getCodeHtml()',
            'type' => 'html'
        ),
        //'pdlprdsno',
        'pdlprdline',
        //'pdlprinted',
        //'pdlcustomyn',
        array(
            'name' => 'pdldes',
            'value' => '$data->getHtmlWrapedDescription() . $data->getHtmlWrapedPriceLookUp()',
            'type' => 'raw',
        ),
        //'pdlcolour',
        //'pdlflag',
        //'pdlimage2',
        //'pdlimage3',
        array(
            'name' => 'supplier_search',
            'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
        ),
        array(
            'name' => 'pdluntprice',
        ),
    // 'pdlleadtime',
    // 'pdlduration',
    //'pdlmob',
    // 'pdldecorationtype',
    //'pdlucdnew',
    // 'pdlentddt',
    // 'pdlenttime',
    // 'pdlucdame',
    // 'pdlameddt',
    // 'pdlametime',
    ),
));
?>
<script>
    function showPriceLookUp(id) {
        $('#pricelookup_' + id + ' > tbody').toggle();
        return false;
    }
</script>