<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'product-line-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <div class="row">
        <?php echo $form->labelEx($model, 'categoryId'); ?>
        <?php
        echo $form->dropDownList($model, 'categoryId', CHtml::listData(ProductCategory::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'categoryId'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'subCategoryId'); ?>
        <?php
        echo $form->dropDownList($model, 'subCategoryId', CHtml::listData(ProductSubCategory::model()->findAll(array('order' => 'name asc')), 'id', 'name'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'subCategoryId'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlcustomyn'); ?>
        <?php echo $form->dropDownList($model, 'pdlcustomyn', array("Y" => "Yes", "N" => "No")); ?>
        <?php echo $form->error($model, 'pdlcustomyn'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlcusno'); ?>
        <?php
        echo $form->dropDownList($model, 'pdlcusno', CHtml::listData(Customer::model()->findAll(), 'cussno', 'cusnam'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'pdlcusno'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlprdline'); ?>
        <?php echo $form->textField($model, 'pdlprdline', array('size' => 60, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'pdlprdline'); ?>
    </div>



    <div class="row">
        <?php echo $form->labelEx($model, 'pdlpdl'); ?>
        <?php echo $form->textField($model, 'pdlpdl', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'pdlpdl'); ?>
    </div>



    <div class="row">
        <?php echo $form->labelEx($model, 'pdldes'); ?>
        <?php echo $form->textArea($model, 'pdldes', array('rows' => 6, 'style' => 'width:610px;')); ?>
        <?php echo $form->error($model, 'pdldes'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdluntprice'); ?>
        <?php echo $form->textField($model, 'pdluntprice'); ?>
        <?php echo $form->error($model, 'pdluntprice'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'sellingPrice'); ?>
        <?php echo $form->textField($model, 'sellingPrice'); ?>
        <?php echo $form->error($model, 'sellingPrice'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'usdUnitFreightCost'); ?>
        <?php echo $form->textField($model, 'usdUnitFreightCost'); ?>
        <?php echo $form->error($model, 'usdUnitFreightCost'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'usdUnitFreightMarkupRate'); ?>
        <?php echo $form->textField($model, 'usdUnitFreightMarkupRate'); ?>
        <?php echo $form->error($model, 'usdUnitFreightMarkupRate'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'pdlsupsno'); ?>
        <?php
        echo $form->dropDownList($model, 'pdlsupsno', CHtml::listData(Supplier::model()->findAll(), 'supsno', 'supnam'), array('empty' => ''));
        ?>
        <?php echo $form->error($model, 'pdlsupsno'); ?>
    </div>



    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlleadtime'); ?>
        <?php echo $form->textField($model, 'pdlleadtime'); ?>
        <?php echo $form->error($model, 'pdlleadtime'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'uploadimg'); ?>
        <?php echo $form->fileField($model, 'uploadimg', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'uploadimg'); ?>
    </div>

    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'pdlimage1'); ?>
        <?php echo $form->textField($model, 'pdlimage1', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'pdlimage1'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlimage2'); ?>
        <?php echo $form->textField($model, 'pdlimage2', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'pdlimage2'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'pdlimage3'); ?>
        <?php echo $form->textField($model, 'pdlimage3', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'pdlimage3'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'qty_on_hand'); ?>
        <?php echo $form->textField($model, 'qty_on_hand', array('size' => 60, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'qty_on_hand'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'qty_available'); ?>
        <?php echo $form->textField($model, 'qty_available', array('size' => 60, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'qty_available'); ?>
    </div>
    <div class="clear"></div>
    
    <hr>
    <div class="row">
        <?php echo $form->labelEx($model, 'sup_product_code'); ?>
        <?php echo $form->textField($model, 'sup_product_code', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'sup_product_code'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'webstore_name'); ?>
        <?php echo $form->textField($model, 'webstore_name', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'webstore_name'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'webstore_uuid'); ?>
        <?php echo $form->textField($model, 'webstore_uuid', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'webstore_uuid'); ?>
    </div>

<hr>
    <?php if (intval(SystemOptions::getOptions()->enbleXero)) { ?>
        <div class="row">
            <?php echo $form->labelEx($model, 'pdlaccrefcode'); ?>
            <?php echo $form->textField($model, 'pdlaccrefcode', array('size' => 60, 'maxlength' => 255)); ?>
            <?php echo $form->error($model, 'pdlaccrefcode'); ?>
        </div>
    <?php } ?>
    
    <hr>

    <div class="clear"></div>
    <?php if (intval(SystemOptions::getOptions()->enableMyob)) { ?>
        <div class="row">
            <?php echo $form->labelEx($model, 'myobExpsAccntId'); ?>
            <?php
            echo $form->dropDownList($model, 'myobExpsAccntId', CHtml::listData(MyobAccount::model()->findAll(), 'id', 'name'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'myobExpsAccntId'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'myobIncmAccntId'); ?>
            <?php
            echo $form->dropDownList($model, 'myobIncmAccntId', CHtml::listData(MyobAccount::model()->findAll(), 'id', 'name'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'myobIncmAccntId'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'myobBuyingDtlTaxCodeId'); ?>
            <?php
            echo $form->dropDownList($model, 'myobBuyingDtlTaxCodeId', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'myobBuyingDtlTaxCodeId'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'myobSellingDtlTaxCodeId'); ?>
            <?php
            echo $form->dropDownList($model, 'myobSellingDtlTaxCodeId', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => ''));
            ?>
            <?php echo $form->error($model, 'myobSellingDtlTaxCodeId'); ?>
        </div>
    <?php } ?>



    <div class="clear"></div>
    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->
<div class="clear"></div>
<hr>
<div id="view">
    <h3>Quantity Break Levels</h3>
    <table class="fullwidth">                                                    
        <tr class="fullwidth">
            <td class="fullwidth">
                <div class="fullwidth sizeqtycolordiv" id="" >
                    <table  id="pdl_qty_breaks" >
                        <tr>
                            <th class="dl-n-clm">#</th>
                            <th class="dl-qty-clm">Quantity From</th>
                            <th class="dl-qty-clm">Quantity To</th>
                            <th class="dl-price-clm">Cost Price</th>
                            <th class="dl-price-clm">Selling Price</th>
                            <th class="dl-btn-clm"><div onclick="addQuantityBreak('<?php echo $model->pdlsno; ?>');" >+Add Row</div></th>
                        </tr>

                        <?php
                        $prdprices = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$model->pdlsno}'", "order" => 'pdpquantity asc'));

                        $count = 0;
                        foreach ($prdprices as $breaklevel):
                            $count++;
                            ?>
                            <tr id="qb_<?php echo $breaklevel->pdpsno; ?>" >
                                <td class="dl-n-clm"><?php echo $count; ?></td>
                                <td class="dl-qty-clm"><input onchange="saveqtybreakfrom('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo $breaklevel->pdpquantity; ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-qty-clm"><input onchange="saveqtybreakto('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo $breaklevel->pdpsquantity; ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-price-clm"><input onchange="saveqtybreakprice('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo round($breaklevel->pdpprice, 2); ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-price-clm"><input onchange="saveqtybreaksellprice('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo round($breaklevel->pdpsellprice, 2); ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-btn-clm"><a href="#" onclick="deleteQtyBreakRow('<?php echo $breaklevel->pdpsno; ?>');
                                            return false;">Delete</a></td>
                            </tr>


                            <?php
                        endforeach;
                        ?>

                    </table>
                </div>
            </td>
        </tr>
    </table>
    <div id="savesuccess_msg" class="savemessage">Changes are saved</div>
</div>


<script>
    function changessaved() {
        $('#savesuccess_msg').fadeIn(500).fadeOut(1500);
    }

    function addQuantityBreak(pdlid) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/createQtyBreak"); ?>',
            data: {'pdlid': pdlid},
            dataType: 'json',
            success: function (result) {
                if (result.rowid > 0) {
                    createQtyBreakRow(pdlid, result.rowid);
                }
            },
            error: function (result) {
                alert('error in create');
            }
        });
    }

    function createQtyBreakRow(productlineid, qtybreakid) {
        var html = '<tr id="qb_' + qtybreakid + '" >\n\
                        <td class="dl-n-clm"></td>\n\
                        <td class="dl-qty-clm"><input onchange="saveqtybreakfrom(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-qty-clm"><input onchange="saveqtybreakto(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs"/></td>\n\
                        <td class="dl-price-clm"><input onchange="saveqtybreakprice(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-price-clm"><input onchange="saveqtybreaksellprice(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-btn-clm"><a href="#" onclick="deleteQtyBreakRow(' + qtybreakid + ');return false;";>Delete</a></td>\n\
                        </tr>';
        $('#pdl_qty_breaks').append(html);
    }

    function saveqtybreakfrom(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakFrom"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreakto(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakTo"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreakprice(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakPrice"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreaksellprice(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakSellPrice"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function deleteQtyBreakRow(id) {
        var r = confirm("Are you sure you want to delete this record?");

        if (r === true) {

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("productPrice/ajaxDelete"); ?>',
                data: {'pdpsno': id},
                dataType: 'json',
                success: function (result) {


                    $('#qb_' + id).remove();



                },
                error: function (result) {
                    alert('error in delete');
                }
            });
        }
    }
</script>

<style>
    #delivery-labels-grid table thead tr th{
        background-image: none;
        background-color: #82B8D6;

    }

    .foo{
        background-color: #E5F1F4;
    }

    .bar{
        background-color: #FFFFFF;
    }

    .maindetailrow{
        width: 100%;
    }

    .maincell{
        width: 100%;        

    }

    .maintbl{
        width: 100%;

    }

    .maintbl tr{
        width: 100%;
    }

    .maintbl:first-child tr td:first-child{
        width: 5%;
    }

    .textinput{
        text-align: center;width: 5%;
    }

    .centercls{
        text-align: center;

    }   

    .rightcls{
        text-align: right;
    }   

    input.centercls{
        width: 40px;
    }

    input.rightcls{
        width: 50px;
    }



    .button-column img{
        cursor: pointer;
        width: 20px;
        height: 20px;
    }

    .subrow{
        width: 100%;
        border: 1px solid #666;

    }

    .subrow:first-child td{
        background-color: #FFFFFF;
    }

    .subrow:first-child td{
        width: 100%;

    }

    .fullwidth{
        width: 100%;
    }

    .subrowgrid tr{
        width: 100%;
    }

    .subrowgrid:first-child tr{
        background-color: #e5eCf9;
    }

    .subrowgrid:last-child tr{
        border: 1px solid #DDD;
    }

    .column1{
        width: 10%;
    }

    .column2{
        width: 35%;
    }

    .column3{
        width: 30%
    }

    .column2half{
        width: 25%;
    }

    .column1half{
        width: 15%;
    }

    .subrowgrid tr th{
        text-align: center;
    }

    .subrowgrid textArea{
        width: 100%;height: 100%;
    }

    .subrowgrid img{
        width:100px;
        height:100px;
    }


    .viewsizecolor{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;    
    }

    .uploadimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 10px;

    }

    .saveimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 5px;
        display: none;

    }

    .mouseoverbutton{
        background-color: #DDD;
        border: 1px solid #FFD324;
    }

    .sizeqtycolordiv{

    }

    .sizeqtycolordiv table{
        width: 100%;
    }

    .sizeqtycolordiv table tr{
        width: 100%;
    }

    .sizeqtycolordiv table:first-child tr{
        background-color: #DDD;
    }

    .sizeqtycolordiv table tr th,td{
        text-align: center;
    }

    .sizeqtycolordiv table:first-child tr div{
        border: 1px solid #FFFFFF;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        width: 50%;
        margin: auto;
    }

    .sizeqtycolordiv table tr:not(:first-child){
        background-color: #E6EFC2;
    }

    .sizeqtycolordiv table input{
        width: 100%;
    }

    .counter{

    }

    .savemessage{
        width: 100%;        
        font-weight: bold;
        color: #00aa00;
        display: none;

    }

    .prodecs{

    }

    .viewlongdesc{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        color: #BCE774;
        margin: 5px;
    }

    .prolngdesc{

    }

    #workorder-list-view tbody td{
        text-align: left;
        padding-left: 50px;

    }

    .dl-n-clm{
        width: 5%;
    }
    .dl-box-clm{
        width: 15%;
    }

    .dl-note-clm{
        width: 45%;
    }

    .dl-qty-clm{
        width: 15%;
    }

    .dl-price-clm{
        width: 22%;
    }

    .dl-btn-clm{
        width: 20%;
    }

    .dl-inputs{
        width: 95%;
        margin: 0;
        padding: 0;
    }

    .txt-center{
        text-align: center;
    }

</style>