<?php
$refreshMyobMenu = null;

if (intval(MyobSetting::getSettings()->update_products_from_myob)) {
    $auth = new MYOBAuth(MyobSetting::getSettings());
    if ($auth->checkAccess()) {
        //$loadinghtml = '&nbsp;<img class="loading-myob" src="images/loading_bar.gif" style="width:60px;height:25px;display:none;">';
        $refreshMyobMenu = array(
            'label' => 'Synchronize MYOB Items',
            'url' => array('#'),
            'linkOptions' => array(
                'onclick' => 'myobSynchronizeAll(this);return false;',
                'data-loading-text' => "MYOB Items Synchronizing...",
                'data-done-text' => "MYOB Items Synchronized!",
                'data-error-text' => "MYOB Synchronizing Error!",
                'style' => 'background-color:#32cd32')
        );
    }
}
$this->menu = array(
    $refreshMyobMenu,
     array('label' => 'API Client', 'url' => array('apiClient')),
    array('label' => 'Create Product', 'url' => array('create')),
    array('label' => 'Manage Category', 'url' => array('productCategory/admin')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('product-line-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Product</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist" style="margin-top: 2%;">

    <li class="active"><a href="#product-sec" role="tab" data-toggle="tab" >Products</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import/Export</a></li>

    <li><a href="#ex-up-log-sec" role="tab" data-toggle="tab" >FTP Excel Upload Log</a></li>

</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="product-sec" style="padding-top: 0;margin-top: 0;">
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'product-line-grid',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'columns' => array(
                'pdlsno',
                array(
                    'name' => 'category_name_search',
                    'value' => '$data->subcategoryRel->categoryRel->name'
                ),
                array(
                    'name' => 'sub_category_name_search',
                    'value' => '$data->subcategoryRel->name'
                ),
                array(
                    'name' => 'pdlimage1',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
                ),
                array(
                    'name' => 'pdlpdl',
                    'value' => '$data->getCodeHtml()',
                    'type' => 'html'
                ),
                //'pdlprdsno',
                'pdlprdline',
                //'pdlprinted',
                //'pdlcustomyn',
                'pdldes',
                //'pdlcolour',
                //'pdlflag',
                //'pdlimage2',
                //'pdlimage3',
                array(
                    'name' => 'supplier_search',
                    'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
                ),
                'pdluntprice',
                //'sellingPrice',
                //'qty_on_hand',
                'qty_available',
                 'sup_product_code',
                 'webstore_name',
                //'pdlmob',
                // 'pdldecorationtype',
                //'pdlucdnew',
                // 'pdlentddt',
                // 'pdlenttime',
                // 'pdlucdame',
                // 'pdlameddt',
                // 'pdlametime',
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}{sep}{update}{sep2}{delete}',
                    'buttons' => array(
                        'view' => array(
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                        'sep' => array(
                            'label' => ' | ',
                            'imageUrl' => false,
                        ),
                        'update' => array(
                            'label' => 'Update',
                            'imageUrl' => false,
                        ),
                        'sep2' => array(
                            'label' => ' | ',
                            'imageUrl' => false,
                        ),
                        'delete' => array(
                            'label' => 'Delete',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>
    </div>
    <div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">
        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'product-export-form',
                    'enableAjaxValidation' => false,
                ));
                ?>


                <?php
                echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
                echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>

        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'product-import-form',
                    'enableAjaxValidation' => false,
                    'htmlOptions' => array('enctype' => 'multipart/form-data'),
                ));
                ?>

                <div class="row">
                    <?php echo $form->labelEx($model, 'importFile'); ?>
                    <?php echo $form->fileField($model, 'importFile', array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo $form->error($model, 'importFile'); ?>

                    <?php echo CHtml::submitButton('Upload File', array('name' => 'import_btn')); ?>
                    <div>[Only xls, xlsx file types are allowed] </div>
                </div>
                <div class="clear"></div>
                <?php
                //echo CHtml::submitButton('Reset', array('name' => 'reset_btn','style' => 'margin-left:5px;float:right;'));
                //echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
    <div class="tab-pane view" id="ex-up-log-sec" style="padding-top: 0;margin-top: 0;">
        <div class="view">
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'product-excel-lookup-grid',
                'dataProvider' => $productExcelLookup->search(),
                'filter' => $productExcelLookup,
                'columns' => array(
                    array(
                        'name' => 'id',
                        'filter' => false,
                    ),
                    array(
                        'name' => 'created_date',
                        'value' => 'date("d/m/Y", strtotime($data->created_date))',
                        'filter' => false,
                    ),
                    array(
                        'name' => 'file_name',
                    ),
                    array(
                        'class' => 'CButtonColumn',
                        'template' => '{view}{sep1}{download}{sep2}{revoke}',
                        'buttons' => array(
                            'view' => array
                                (
                                'label' => 'View',
                                'imageUrl' => false,
                                'url' => 'Yii::app()->createUrl("productExcelLookup/view", array("id"=>$data->id))',
                            ),
                            'sep1' => array
                                (
                                'label' => ' | ',
                                'url' => '',
                                'imageUrl' => false,
                            ),
                            'download' => array
                                (
                                'label' => 'Download',
                                'imageUrl' => false,
                                'url' => 'Yii::app()->createUrl("productExcelLookup/download", array("id"=>$data->id))',
                            ),
                            'sep2' => array
                                (
                                'label' => ' | ',
                                'url' => '',
                                'imageUrl' => false,
                                'visible' => '!$data->to_be_read'
                            ),
                            'revoke' => array
                                (
                                'label' => 'Revoke',
                                'imageUrl' => false,
                                'url' => 'Yii::app()->createUrl("#", array("id"=>$data->id, "onclick"=>"return false;"))',
                                'visible' => '!$data->to_be_read',
                                'click' => 'js:function(){revokeCall($(this).parent().parent().children(":first-child").text()); return false;}',
                            ),
                        )
                    ),
                ),
            ));
            ?>

        </div>
    </div>

</div>


<?php
if (!empty($message)) {
    ?>

    <div class="view" >
        <h3><a href="#" onclick="showlogdtl();return false;">Import Log Details</a></h3>
        <div id="log-dtl-sec" style="display: none;">
            <?php
            if (!empty($message['supplier'])) {
                echo '<h4>Supplier Import Log <h4>';
                echo '<pre>' . $message['supplier'] . '</pre>';
            }

            if (!empty($message['subcategory'])) {
                echo '<h4>Sub Category Import Log <h4>';
                echo '<pre>' . $message['subcategory'] . '</pre>';
            }

            if (!empty($message['product'])) {
                echo '<h4>Product Import Log <h4>';
                echo '<pre>' . $message['product'] . '</pre>';
            }

            if (!empty($message['qty_brk'])) {
                echo '<h4>Qty Breaks Import Log <h4>';
                echo '<pre>' . $message['qty_brk'] . '</pre>';
            }
            ?>
        </div>
    </div>

    <?php
}
?>
<style>
    .grid-view table.items th {
        color: white;
        background-image: none;
        background-color: #65a5cc;
        text-align: center;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.3.3/bootbox.min.js"></script>
<script>

            function revokeCall(id) {

                bootbox.confirm({
                    message: "Are you sure you want to revoke all product related to this excel upload ?",
                    buttons: {
                        confirm: {
                            label: 'Yes',
                            className: 'btn-success'
                        },
                        cancel: {
                            label: 'No',
                            className: 'btn-danger'
                        }
                    },
                    callback: function (result) {
                        var obj = {};
                        obj.id = id;
                        if (result) {
                            revokeExcel(obj);
                        }
                    }
                });

            }

            function revokeExcel(obj) {

                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl("productExcelLookup/revoke"); ?>',
                    data: obj,
                    dataType: 'json',
                    success: function (result) {
                        $.fn.yiiGridView.update("product-excel-lookup-grid");
                        $.fn.yiiGridView.update("product-line-grid");
                    },
                    error: function (result) {

                    }
                });
            }

            function showlogdtl() {
                $('#log-dtl-sec').toggle();
            }

            function myobSynchronizeAll(e)
            {
                var $this = $(e);
                startMyobStreaming($this);
                $this.button('loading');
                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl("productLine/MYOBSyncronizeAll"); ?>',
                    data: {},
                    dataType: 'json',
                    success: function (result) {
                        myobSynchronizeDone($this);
                    },
                    error: function (result) {
                        //$this.button('error');
                        console.log(result);
                    }
                });
            }

            function startMyobStreaming($this) { /* $this refer to trigered element */
                xhr = new XMLHttpRequest();
                xhr.open("GET", "<?php echo Yii::app()->createUrl("productLine/MYOBSyncronizeAll"); ?>", true);
                xhr.onprogress = function (e) {

                    var str = e.currentTarget.responseText;
                    var res = str.split("~");

                    var num = [];
                    $.each(res, function (index, value) {
                        num.push(value.replace(/[^0-9\/]/g, ''));

                    });

                    var newArray = num.filter(function (v) {
                        return v !== ''
                    });

                    console.log(num[num.length - 2]);


                    $this.empty();
                    $this.text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);



                }
                xhr.onreadystatechange = function () {
                    if (xhr.readyState == 4) { /* streaming DONE */
                        myobSynchronizeDone($this);
                    }
                }
                xhr.send();
            }

            function myobSynchronizeDone($this) {
                $this.button('done');
                $('#product-line-grid').yiiGridView('update');
            }
</script>