<?php
$this->breadcrumbs = array(
    'Product Lines' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List ProductLine', 'url'=>array('index')),
    array('label' => 'Manage Product', 'url' => array('admin')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('product-line-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Allocate Products to Customer</h1>
<div class="view">
    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'allocate-customer-for-products-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">
            <?php echo CHtml::label('Customer', null); ?>
            <?php
            echo $form->dropDownList($customer, 'cussno', CHtml::listData(Customer::model()->findAll(), 'cussno', 'cusnam'), array('empty' => ''));
            ?>
            <?php echo $form->error($customer, 'cussno'); ?>
        </div>
        <div class="clear"></div>
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'allocate-product-line-grid',
            'dataProvider' => $model->allocateSearch(),
            'filter' => $model,
            'selectableRows' => 10,
            'columns' => array(
                array(
                    'class' => 'CCheckBoxColumn',
                ),
                'pdlsno',
                array(
                    'name' => 'pdlimage1',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
                ),
                'pdlpdl',
                //'pdlprdsno',
                'pdlprdline',
                //'pdlprinted',
                //'pdlcustomyn',
                'pdldes',
                //'pdlcolour',
                //'pdlflag',
                //'pdlimage2',
                //'pdlimage3',
                array(
                    'name' => 'pdlsupsno',
                    'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
                ),
                'pdluntprice',
                // 'pdlleadtime',
                // 'pdlduration',
                //'pdlmob',
                // 'pdldecorationtype',
                //'pdlucdnew',
                // 'pdlentddt',
                // 'pdlenttime',
                // 'pdlucdame',
                // 'pdlameddt',
                // 'pdlametime',
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}',
                    'buttons' => array(
                        'view' => array(
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>
        <div class="row buttons">
            <?php echo CHtml::submitButton('Allocate', array('name' => 'btn_allocate_prd')); ?>
        </div>

        <?php
        $this->endWidget();
        ?>
        <div class="clear"></div>
    </div>    
</div>
<div class="clear"></div>
<?php
if (!empty($customer->cussno)) {
    ?>

    <div class="view">
        <h3>Allocated Products</h3>
        <?php
        $allocatedpdl = new ProductLine();
        $allocatedpdl->pdlcusno = $customer->cussno;
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'cus-allocated-products-grid',
            'dataProvider' => $allocatedpdl->search(),
            'filter' => null,
            'columns' => array(
                'pdlsno',
                array(
                    'name' => 'pdlimage1',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
                ),
                'pdlpdl',
                //'pdlprdsno',
                'pdlprdline',
                //'pdlprinted',
                //'pdlcustomyn',
                'pdldes',
                //'pdlcolour',
                //'pdlflag',
                //'pdlimage2',
                //'pdlimage3',
                array(
                    'name' => 'pdlsupsno',
                    'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
                ),
                'pdluntprice',
                // 'pdlleadtime',
                // 'pdlduration',
                //'pdlmob',
                // 'pdldecorationtype',
                //'pdlucdnew',
                // 'pdlentddt',
                // 'pdlenttime',
                // 'pdlucdame',
                // 'pdlameddt',
                // 'pdlametime',
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{revoke}',
                    'buttons' => array(
                        'revoke' => array(
                            'label' => 'Revoke',
                            'imageUrl' => false,
                            'url' => 'Yii::app()->createUrl("productLine/revokeCustomer", array("id"=>$data->pdlsno))',
                            'click' => "function(){
    $.fn.yiiGridView.update('cus-allocated-products-grid', {  //change my-grid to your grid's name
        type:'POST',
        url:$(this).attr('href'),
        success:function(data) {
             // $.fn.yiiGridView.update('allocate-product-line-grid'); //change my-grid to your grid's name
        }
    })
    return false;
  }
",
                        ),
                    )
                ),
            ),
        ));
        ?>
    </div>

    <?php
}
?>