<?php
$refreshMyobMenu = null;
$myobUpload = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
    $refreshMyobMenu = array(
        'label' => 'Synchronize MYOB',
        'url' => array('#'),
        'linkOptions' => array(
            'id' => $model->pdlsno,
            'onclick' => 'myobSynchronize(this);return false;',
            'data-loading-text' => "MYOB Synchronizing...",
            'data-done-text' => "MYOB Synchronized!",
            'data-error-text' => "MYOB Synchronizing Error!",
            'style' => 'background-color:#32cd32')
    );
}
$this->menu = array(
    $refreshMyobMenu,
    array('label' => 'Create Product', 'url' => array('create')),
    array('label' => 'Update Product', 'url' => array('update', 'id' => $model->pdlsno)),
    array('label' => 'Delete Product', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->pdlsno), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Product', 'url' => array('admin')),
);
?>

<h1>View Product #<?php echo $model->pdlsno; ?></h1>
<input type="hidden" value="<?php echo $model->pdlsno; ?>" id="pdlsno"/>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>

<?php echo $model->getMYOBError(); ?>
<div class="view">
    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model,
        'attributes' => array(
            array(
                'name' => 'categoryId',
                'value' => $model->subcategoryRel->categoryRel->name
            ),
            array(
                'name' => 'subCategoryId',
                'value' => $model->subcategoryRel->name
            ),
//            array(
//                'name' => 'orderTypeId',
//                'value' => $model->orderTypeRel->name
//            ),
            //'pdlprdsno',
            'pdlprdline',
            //'pdlprinted',
            array(
                'name' => 'pdlpdl',
                'value' => $model->getCodeHtml(),
                'type' => 'html'
            ),
            'pdlcustomyn',
            array(
                'name' => 'pdlcusno',
                'value' => (!empty($model->customer) ? $model->customer->cusnam : "Not Set")
            ),
            'pdldes',
            //'pdlcolour',
            //'pdlflag',
            array(
                'name' => 'pdlimage1',
                'type' => 'raw',
                'value' => CHtml::image($model->getImg(), '', array('width' => 100)),
            ),
            array(
                'name' => 'pdlsupsno',
                'value' => Supplier::model()->findByPk($model->pdlsupsno)->supnam,
            ),
            'pdluntprice',
            'sellingPrice',
            'qty_on_hand',
            'qty_available',
            'usdUnitFreightCost',
            'usdUnitFreightMarkupRate',
            'pdlleadtime',
            array(
                'name' => 'pdlaccrefcode',
                'visible' => intval(SystemOptions::getOptions()->enbleXero)
            ),
            //'pdlduration',
            //'pdlmob',
            //'pdldecorationtype',
            array(
                'name' => 'myobExpsAccntId',
                'value' => MyobAccount::model()->findByPk($model->myobExpsAccntId)->name,
                'visible' => intval(SystemOptions::getOptions()->enableMyob)
            ),
            array(
                'name' => 'myobIncmAccntId',
                'value' => MyobAccount::model()->findByPk($model->myobIncmAccntId)->name,
                'visible' => intval(SystemOptions::getOptions()->enableMyob)
            ),
            array(
                'name' => 'myobBuyingDtlTaxCodeId',
                'value' => MyobTaxCode::model()->findByPk($model->myobBuyingDtlTaxCodeId)->code,
                'visible' => intval(SystemOptions::getOptions()->enableMyob)
            ),
            array(
                'name' => 'myobSellingDtlTaxCodeId',
                'value' => MyobTaxCode::model()->findByPk($model->myobSellingDtlTaxCodeId)->code,
                'visible' => intval(SystemOptions::getOptions()->enableMyob)
            ),
            'pdlucdnew',
            'pdlentddt',
            'pdlenttime',
        //'pdlucdame',
        //'pdlameddt',
        //'pdlametime',
        ),
    ));
    ?>
</div>




<div class="clear"></div>
<div id="view">
    <h3>Quantity Break Levels</h3>
    <?php 
        if($model->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) {
            echo $model->getHtmlWrapedPriceLookUp() ;
        } else {
            ?>
    <table class="fullwidth">                                                    
        <tr class="fullwidth">
            <td class="fullwidth">
                <div class="fullwidth sizeqtycolordiv" id="" >
                    <table  id="pdl_qty_breaks" >
                        <tr>
                            <th class="dl-n-clm">#</th>
                            <th class="dl-qty-clm">Quantity From</th>
                            <th class="dl-qty-clm">Quantity To</th>
                            <th class="dl-price-clm">Cost Price</th>
                            <th class="dl-price-clm">Selling Price</th>
                            <th class="dl-btn-clm"><div onclick="addQuantityBreak('<?php echo $model->pdlsno; ?>');" >+Add Row</div></th>
                        </tr>

                        <?php
                        $prdprices = ProductPrice::model()->findAll(array('condition' => "pdppdlsno = '{$model->pdlsno}'", "order" => 'pdpquantity asc'));
                        $count = 0;
                        foreach ($prdprices as $breaklevel):
                            $count++;
                            ?>
                            <tr id="qb_<?php echo $breaklevel->pdpsno; ?>" >
                                <td class="dl-n-clm"><?php echo $count; ?></td>
                                <td class="dl-qty-clm"><input onchange="saveqtybreakfrom('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo $breaklevel->pdpquantity; ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-qty-clm"><input onchange="saveqtybreakto('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo $breaklevel->pdpsquantity; ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-price-clm"><input onchange="saveqtybreakprice('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo round($breaklevel->pdpprice, 2); ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-price-clm"><input onchange="saveqtybreaksellprice('<?php echo $model->pdlsno; ?>', '<?php echo $breaklevel->pdpsno; ?>', this.value);" type="text"  value="<?php echo round($breaklevel->pdpsellprice, 2); ?>" class="dl-inputs txt-center"/></td>
                                <td class="dl-btn-clm"><a href="#" onclick="deleteQtyBreakRow('<?php echo $breaklevel->pdpsno; ?>');
                                        return false;">Delete</a></td>
                            </tr>


                            <?php
                        endforeach;
                        ?>

                    </table>
                </div>
            </td>
        </tr>
    </table>
    <?php
        }
    ?>
    <div id="savesuccess_msg" class="savemessage">Changes are saved</div>
</div>


<script>
    
    function showPriceLookUp(id) {
        $('#pricelookup_' + id + ' > tbody').toggle();
        return false;
    }

    function myobSynchronize(e)
    {
        var $this = $(e);
        $this.button('loading');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productLine/MYOBSyncronize"); ?>',
            data: {'id': $(e).attr('id')},
            dataType: 'json',
            success: function (result) {
                $this.button('done');
                location.reload();
            },
            error: function (result) {
                $this.button('error');
                location.reload();

            }
        });
    }

    function addsizesfromgrid() {
        var values = new Array();
        $.each($("input[name='product-sizes-grid_c0[]']:checked"), function () {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (values.length > 0) {
            var idarrstr = values + "";
            addProductSizes(idarrstr);
        }
    }

    function showSizesModel() {
        $('#add-sizes-model').modal('show');
    }

    function addProductSizes(sizesIds) {
        var pdslno = $('#pdlsno').val();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productLine/addProductSizes"); ?>',
            data: {'pdslno': pdslno, 'sizesIds': sizesIds},
            dataType: 'json',
            success: function (result) {

                $.fn.yiiGridView.update("product-by-size-grid");

            },
            error: function (result) {
                //('error in add products');
            }
        });
    }


    $(document.body).on('click', '.myob-upload-menu', function () {
        $('.loading-myob').show();
    });

    function changessaved() {
        $('#savesuccess_msg').fadeIn(500).fadeOut(1500);
    }

    function addQuantityBreak(pdlid) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/createQtyBreak"); ?>',
            data: {'pdlid': pdlid},
            dataType: 'json',
            success: function (result) {
                if (result.rowid > 0) {
                    createQtyBreakRow(pdlid, result.rowid);
                }
            },
            error: function (result) {
                alert('error in create');
            }
        });
    }

    function createQtyBreakRow(productlineid, qtybreakid) {
        var html = '<tr id="qb_' + qtybreakid + '" >\n\
                        <td class="dl-n-clm"></td>\n\
                        <td class="dl-qty-clm"><input onchange="saveqtybreakfrom(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-qty-clm"><input onchange="saveqtybreakto(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs"/></td>\n\
                        <td class="dl-price-clm"><input onchange="saveqtybreakprice(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-price-clm"><input onchange="saveqtybreaksellprice(' + productlineid + ',' + qtybreakid + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-btn-clm"><a href="#" onclick="deleteQtyBreakRow(' + qtybreakid + ');return false;";>Delete</a></td>\n\
                        </tr>';
        $('#pdl_qty_breaks').append(html);
    }

    function saveqtybreakfrom(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakFrom"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreakto(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakTo"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreakprice(productlineid, qtybreakid, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakPrice"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function saveqtybreaksellprice(productlineid, qtybreakid, inptval) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productPrice/saveQtyBreakSellPrice"); ?>',
            data: {'pdlid': productlineid, 'prdpriceid': qtybreakid, 'value': inptval},
            dataType: 'json',
            success: function (result) {

                if (result.status === 'success') {
                    changessaved();
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }

    function deleteQtyBreakRow(id) {
        var r = confirm("Are you sure you want to delete this record?");

        if (r === true) {

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("productPrice/ajaxDelete"); ?>',
                data: {'pdpsno': id},
                dataType: 'json',
                success: function (result) {


                    $('#qb_' + id).remove();



                },
                error: function (result) {
                    alert('error in delete');
                }
            });
        }
    }
</script>

<style>
    #delivery-labels-grid table thead tr th{
        background-image: none;
        background-color: #82B8D6;

    }

    .foo{
        background-color: #E5F1F4;
    }

    .bar{
        background-color: #FFFFFF;
    }

    .maindetailrow{
        width: 100%;
    }

    .maincell{
        width: 100%;        

    }

    .maintbl{
        width: 100%;

    }

    .maintbl tr{
        width: 100%;
    }

    .maintbl:first-child tr td:first-child{
        width: 5%;
    }

    .textinput{
        text-align: center;width: 5%;
    }

    .centercls{
        text-align: center;

    }   

    .rightcls{
        text-align: right;
    }   

    input.centercls{
        width: 40px;
    }

    input.rightcls{
        width: 50px;
    }



    .button-column img{
        cursor: pointer;
        width: 20px;
        height: 20px;
    }

    .subrow{
        width: 100%;
        border: 1px solid #666;

    }

    .subrow:first-child td{
        background-color: #FFFFFF;
    }

    .subrow:first-child td{
        width: 100%;

    }

    .fullwidth{
        width: 100%;
    }

    .subrowgrid tr{
        width: 100%;
    }

    .subrowgrid:first-child tr{
        background-color: #e5eCf9;
    }

    .subrowgrid:last-child tr{
        border: 1px solid #DDD;
    }

    .column1{
        width: 10%;
    }

    .column2{
        width: 35%;
    }

    .column3{
        width: 30%
    }

    .column2half{
        width: 25%;
    }

    .column1half{
        width: 15%;
    }

    .subrowgrid tr th{
        text-align: center;
    }

    .subrowgrid textArea{
        width: 100%;height: 100%;
    }

    .subrowgrid img{
        width:100px;
        height:100px;
    }


    .viewsizecolor{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;    
    }

    .uploadimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 10px;

    }

    .saveimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 5px;
        display: none;

    }

    .mouseoverbutton{
        background-color: #DDD;
        border: 1px solid #FFD324;
    }

    .sizeqtycolordiv{

    }

    .sizeqtycolordiv table{
        width: 100%;
    }

    .sizeqtycolordiv table tr{
        width: 100%;
    }

    .sizeqtycolordiv table:first-child tr{
        background-color: #DDD;
    }

    .sizeqtycolordiv table tr th,td{
        text-align: center;
    }

    .sizeqtycolordiv table:first-child tr div{
        border: 1px solid #FFFFFF;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        width: 50%;
        margin: auto;
    }

    .sizeqtycolordiv table tr:not(:first-child){
        background-color: #E6EFC2;
    }

    .sizeqtycolordiv table input{
        width: 100%;
    }

    .counter{

    }

    .savemessage{
        width: 100%;        
        font-weight: bold;
        color: #00aa00;
        display: none;

    }

    .prodecs{

    }

    .viewlongdesc{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        color: #BCE774;
        margin: 5px;
    }

    .prolngdesc{

    }

    #workorder-list-view tbody td{
        text-align: left;
        padding-left: 50px;

    }

    .dl-n-clm{
        width: 5%;
    }
    .dl-box-clm{
        width: 15%;
    }

    .dl-note-clm{
        width: 45%;
    }

    .dl-qty-clm{
        width: 15%;
    }

    .dl-price-clm{
        width: 22%;
    }

    .dl-btn-clm{
        width: 20%;
    }

    .dl-inputs{
        width: 95%;
        margin: 0;
        padding: 0;
    }

    .txt-center{
        text-align: center;
    }

</style>