<?php
$this->breadcrumbs = array(
    'Product Sizes' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List ProductSizes', 'url'=>array('index')),
    array('label' => 'Create Product Sizes', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('product-sizes-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Product Sizes</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'product-sizes-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        'size_name',
        'description',
        
        array(
            'name' => 'ordernumber',            
            'type'=>'raw',
            'value'=>'CHtml::textField(ProductSizes::model()->ordernumber,$data->ordernumber,array("id"=>$data->id,"name"=>"order_number","onchange"=>"updateSizeOrder(this.id,this.value);"))',
           
        ),
        array(
            'name' => 'addedby',
            'value' => 'User::model()->findByPk($data->addedby)->username',
        ),
        array(
            'name' => 'createddate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createddate))'
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
<script>
function updateSizeOrder(id,value){
    $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("productSizes/updateSizeOrder"); ?>',
            data: {'id': id, 'value': value},
            dataType: 'json',
            success: function(result) {
               console.log(result);
            },
            error: function(result) {
                console.log(result);
            }
        });
}
</script>