
<h1>Purchase Artwork</h1>
<div class="view">
    <div style="width: 50%;float: left;">
        <p style="font-size: 1.2em; font-weight: bold;">Artwork Main Details</p>
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $artwork,
            'attributes' => array(
                'id',
                'productColor',
                //'archiveImageLogo',
                'decorationType',
                'logoName',
                'printSize',
                'printColor',
                'designNumber',
                'isRepeatDesign',
                'comments',
                'signOffTerms',
                'jobType',
                array(
                    'name'=>'job_status_id',
                    'value'=>Status::getStatusName($artwork->job_status_id),
                ),
                array(
                    'name'=>'approve_status_id',
                    'value'=>Status::getStatusName($artwork->approve_status_id),
                ),
                
                'createdDate',
                'approveDate',
            ),
        ));
        ?>
    </div>
    <div style="width: 50%;float: right;">
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $artwork,
            'attributes' => array(
                array(
                    'name' => 'archiveImageLogo',
                    'value' => CHtml::image('images/artwork/job/' . $artwork->artworkjobNum . '/' . $artwork->archiveImageLogo, '', array('style' => 'width:150px;')),
                    'type' => 'raw',
                ),
            ),
        ));
        ?>
    </div>
    <div style="width: 50%;float: right;">
         <p style="font-size: 1.2em; font-weight: bold;">Item Details</p>
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'artwork-logo-archive-grid',
            'dataProvider' => $decorationproducts,
            'filter' => null,
             'summaryText' => '',
            'columns' => array(
                'id',
//                array(
//                    'name' => 'workorderDtl.image',
//                    'type' => 'raw',
//                    'value' => 'CHtml::image($data->workorderDtl->getImg())',
//                    'htmlOptions' => array('style' => 'width:100px;'),
//                ),
                array(
                    'name' => 'workorderDtl.productsku',
                    ),
                array(
                    'name' => 'workorderDtl.prdsrtdesc',
                    ),
              
            ),
        ));
        ?>
    </div>
    <div class="clear"></div>
</div>
<div class="view">
    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'po-artwork-form',
            'htmlOptions' => array('enctype' => 'multipart/form-data'),
            'enableAjaxValidation' => false,
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>

        
        <div class="row">
            <?php echo $form->labelEx($model, 'supplier_id'); ?>
            <?php echo CHtml::dropDownList('PurchaseOrders[supplier_id]', $model, CHtml::listData(Supplier::model()->findAll(array('order'=>'supnam asc')), 'supsno', 'supnam'), array('empty' => 'Select Supplier')); ?>
            <?php echo $form->error($model, 'supplier_id'); ?>
        </div>

        <div class="clear"></div>
        

        

        <div class="row">
            <?php echo $form->labelEx($model, 'followupDate'); ?>
            <?php
            $todayDate = date(GlobalVars::get("DateFormat")); // current date
            $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
            $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);

            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'followupDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
            <?php echo $form->error($model, 'followupDate'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'dueDate'); ?>
            <?php
            $todayDate = date(GlobalVars::get("DateFormat")); // current date
            $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
            $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);

            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dueDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                'language' => 'en-GB'
            ));
            
            echo $form->textfield($model, 'artwork_job_id', array('style' => 'display:none;', 'value' => $model->artwork_job_id)); 
            echo $form->textfield($model, 'job_id', array('style' => 'display:none;', 'value' => $model->job_id)); 
            ?>
            <?php echo $form->error($model, 'dueDate'); ?>
        </div>
        <div class="clear"></div>
        <div >
            <?php echo $form->labelEx($model, 'notation'); ?>
            <?php echo $form->textarea($model, 'notation', array('rows'=>5, 'style' => 'width:95%;',)); ?>
            <?php echo $form->error($model, 'notation'); ?>
        </div>

        <div class="clear"></div>

        



    </div><!-- form -->
</div>


<div class="clear"></div>
<div >
            <?php echo CHtml::submitButton('Create'); ?>
        </div>
    <?php $this->endWidget(); ?>