<div class="view"> 
    <?php
    /*
     * To change this license header, choose License Headers in Project Properties.
     * To change this template file, choose Tools | Templates
     * and open the template in the editor.
     */

    $this->widget('zii.widgets.CDetailView', array(
        'id' => 'po-view',
        'data' => $model,
        'attributes' => array(
            'id',
            'poNum',
            array(
                'name' => 'workorder_id',
                'value' => CHtml::link($model->workorder->salesorderNumber, array('workorderdetails/admin', 'wid' => $model->workorder_id), array("target" => "_blank")),
                'type' => 'raw',
            ),
            array(
                'name' => 'job.jobNum',
                'value' => CHtml::link($model->job->jobNum, array('jobs/view', 'id' => $model->job_id), array("target" => "_blank")),
                'type' => 'raw',
            ),
            array(
                'name' => 'supplier_id',
                'value' => CHtml::link(Supplier::model()->findByPk($model->supplier_id)->supnam, array('supplier/view', 'id' => $model->supplier_id), array("target" => "_blank")),
                'type' => 'raw',
            ),
            array(
                'name' => 'artwork_job_id',
                'value' => CHtml::link(JobArtwork::model()->findByPk($model->artwork_job_id)->artworkjobNum, array('jobArtwork/view', 'id' => $model->artwork_job_id), array("target" => "_blank")),
                'type' => 'raw',
                'visible' => $model->poType == 'Purchase Artwork',
            ),
            array(
                'name' => 'notation',
                'value' => nl2br($model->notation),
                'type' => 'raw',
            ),
            array(
                'name' => 'followup_status_id',
                'value' => FollowupStatus::model()->findByPk($model->followup_status_id)->status,
                'type' => 'raw',
            ),
            array(
                'name' => 'followupDate',
                'value' => date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->followupDate)),
            ),
            array(
                'name' => 'dueDate',
                'value' => date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->dueDate)),
            ),
            array(
                'name' => 'user_id',
                'value' => User::model()->findByPk($model->user_id)->username,
            ),
            array(
                'name' => 'status_id',
                'value' => Status::model()->findByPk($model->status_id)->name,
            ),
            array(
                'label' => 'MYOB',
                'value' => $model->getMYOBLabel(),
                'visible' => $model->getMYOBLabel(),
                'type' => 'raw',
            )
        ),
    ));
    ?>
</div>
<div class="clear"></div>
<div class="view">
    <h3 style="display: inline;">Purchased Products</h3>
    <?php
    echo CHtml::button('Add Items', array('id' => 'addItems', 'onclick' => "showJobProductItems();", 'style' => 'float: right;margin-top:5px;'));
    ?>
    <?php
    $podtls = new PurchaseOrderDetails();
    $podtls->po_id = $model->id;



    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'po-details-grid',
        'dataProvider' => $podtls->search(),
        'filter' => null,
        'columns' => array(
            'id',
            array(
                'name' => 'workorderDtl.image',
                'type' => 'raw',
                'value' => 'CHtml::image($data->workorderDtl->getImg())',
                'htmlOptions' => array('style' => 'width:100px;'),
            ),
            array(
                'name' => 'workorderDtl.productsku',
                'value' => '$data->workorderDtl->getProductColumnHtml()',
                'type' => 'raw',
            ),
            array(
                'name' => 'workorderDtl.prdlngdesc',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:200px;'),
                'value' => '$data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
            ),
            array(
                'name' => 'xero_account_id',
                'type' => 'raw',
                'value' => 'CHtml::dropDownList("PurchaseOrderDetails[xero_account_id][$data->id]",$data->xero_account_id,CHtml::listData(XeroAccount::model()->findAll('
                . '"code like \'4%\'"), "id", "name"),'
                . 'array("empty" => "", "class" => "xeroExpensesAccount",  "poDetailsId" => $data->id, "style" => "text-align:center;width:100px;"))',
                'htmlOptions' => array('style' => 'text-align:center'),
                'visible' => (int) SystemOptions::getOptions()->enbleXero
            ),
            array(
                'header' => 'Qty',
                'value' => '$data->workorderDtl->prodQty',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
            //for purchase product
            array(
                'name' => 'workorderDtl.prodCostPrice',
                'value' => 'number_format($data->workorderDtl->prodCostPrice,2)',
                'htmlOptions' => array('style' => 'text-align:right'),
            ),
            array(
                'header' => 'Amount',
                'value' => 'number_format($data->workorderDtl->prodCostPrice * $data->qty,2)',
                'htmlOptions' => array('style' => 'text-align:right'),
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("purchaseOrderDetails/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));
    ?>
</div>
<!-- Add job product detail items from grid -->
<div id="jobproduct-item-select-to-poproduct-model" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">

                <h3 style="text-align: center;">Select Item Details</h3>
            </div>
            <div class="modal-body">
                <?php
                $selectJobProducts = new JobProducts();
                $selectJobProducts->job_id = $model->job->id;

                $this->renderPartial('/jobProducts/_admin_select', array('model' => $selectJobProducts));
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="poDetailsFromJobProductGrid();">Add</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>

<script>
    function showJobProductItems() {
        $.fn.yiiGridView.update("job-product-item-select-grid");
        showcentermodel('jobproduct-item-select-to-poproduct-model');
    }

    function poDetailsFromJobProductGrid() {


        var values = new Array();
        $.each($("input[name='job-product-item-select-grid_c0[]']:checked"), function () {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        var obj = {};
        obj.poId = $('#po-id').val();
        obj.jobProductIds = values;

        if (values.length > 0) {

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("purchaseOrderDetails/addJobProductItems"); ?>',
                data: obj,
                dataType: 'json',
                success: function (result) {
                    if (result.success) {
                        $.fn.yiiGridView.update("po-details-grid");
                    }

                },
                error: function (result) {

                }
            });
        }


    }

    $(document).on('change', '.xeroExpensesAccount', function () {

        updateXeroExpensesAccount({id: $(this).attr('poDetailsId'), xeroExpensesAccountId: $(this).val()});

    });

    function updateXeroExpensesAccount(data) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("purchaseOrderDetails/updateXeroExpensesAccount"); ?>',
            data: data,
            dataType: 'json',
            success: function (result) {



            },
            error: function (result) {

            }
        });
    }

    function showcentermodel(id) {
        $("#" + id).modal('show').css(
                {
                    'margin-top': function () {
                        return -($(this).height() / 2);
                    },
                    'margin-left': function () {
                        return -($(this).width() / 2);
                    },
                })
    }
</script>
<style>

    #jobproduct-item-select-to-poproduct-model {
        width: 950px;  
    }
</style>