<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'purchase-orders-_poform-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>





    <div class="row">
        <?php echo $form->labelEx($model, 'supplier_id'); ?>
        <?php
        echo $form->dropDownList($model, 'supplier_id', CHtml::listData(Supplier::model()->findAll(array('order' => 'supnam asc')), 'supsno', 'supnam'), array('empty' => 'Select Supplier'));
        ?>
        <?php echo $form->error($model, 'supplier_id'); ?>
    </div>	

    <div class="clear"></div>

    <div style="width:100%;">
        <?php echo $form->labelEx($model, 'notation'); ?>
        <?php echo $form->textArea($model, 'notation', array('rows' => 4, 'style' => 'width:67%;')); ?>
        <?php echo $form->error($model, 'notation'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'followupDate'); ?>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
        <?php echo $form->error($model, 'followupDate'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'dueDate'); ?>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'dueDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
        <?php echo $form->error($model, 'dueDate'); ?>
    </div>



    <div class="clear"></div>

    <div class="view">
        <h3>Select Products</h3>
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'product-line-grid',
            'dataProvider' => $productline->search(),
            'filter' => $productline,
            'selectableRows' => 100,
            //'ajaxUrl' => array('productLine/admin'),
            'columns' => array(
                array(
                    'class' => 'CCheckBoxColumn',
                ),
                'pdlsno',
                array(
                    'name' => 'pdlimage1',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->getImg(), "", array("width" => 100))',
                ),
                'pdlpdl',
                //'pdlprdsno',
                'pdlprdline',
                //'pdlprinted',
                //'pdlcustomyn',
                'pdldes',
                //'pdlcolour',
                //'pdlflag',
                //'pdlimage2',
                //'pdlimage3',
                array(
                    'name' => 'pdlsupsno',
                    'value' => '!empty($data->supplier)? $data->supplier->supnam : ""',
                ),
                'pdluntprice',
            ),
        ));
        ?>

        <div class="row buttons">
            <?php echo CHtml::submitButton('Submit'); ?>
        </div>
        <div class="clear"></div>
    </div>






    <?php $this->endWidget(); ?>

</div><!-- form -->
<div class="clear"></div>
<div class="view">
    <h3>Purchase Order Details</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'purchase-orders-details-grid',
        'dataProvider' => $podetails->search(),
        'filter' => $podetails,
        'columns' => array(
            //'id',
            array(
                'header' => 'No.',
                'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
            ),
            array(
                'name' => 'productLine.pdlimage1',
                'type' => 'raw',
                'value' => '(!empty($data->productLine) ? CHtml::image($data->productLine->getImg(), "", array("width" => 100)) : "")',
            ),
            'productLine.pdlpdl',
            //'pdlprdsno',
            'productLine.pdlprdline',
            //'pdlprinted',
            //'pdlcustomyn',
            'productLine.pdldes',
            'qty',
            array(
                'name'=>'cost',
                'value'=>'number_format($data->cost,2)'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                    ),
                ),
            ),
        ),
    ));
    ?>

</div>