<?php

$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'po-details-grid',
    'dataProvider' => $podtls->search(),
    'filter' => null,
    'columns' => array(
        'id',
        array(
            'name' => 'workorderDtl.image',
            'type' => 'raw',
            'value' => 'CHtml::image($data->workorderDtl->getImg())',
            'htmlOptions' => array('style' => 'width:100px;'),
        ),
        array(
            'name' => 'workorderDtl.productsku',
            'value' => '$data->workorderDtl->getProductColumnHtml()',
            'type' => 'raw',
        ),
        array(
            'name' => 'workorderDtl.prdlngdesc',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:200px;'),
            'value' => '$data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
        ),
        array(
            'name' => 'xero_account_id',
            'value' => 'XeroAccount::model()->findByPk($data->xero_account_id)->code . " - " . XeroAccount::model()->findByPk($data->xero_account_id)->name',
            'type' => 'html',
            'htmlOptions' => array('style' => 'text-align:center'),
            'visible' => (int) SystemOptions::getOptions()->enbleXero
        ),
        array(
            'header' => 'Qty',
            'value' => '$data->workorderDtl->prodQty',
            'htmlOptions' => array('style' => 'text-align:center'),
        ),
        //for purchase product
        array(
            'name' => 'workorderDtl.prodCostPrice',
            'value' => 'number_format($data->workorderDtl->prodCostPrice,2)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
        array(
            'header' => 'Amount',
            'value' => 'number_format($data->workorderDtl->prodCostPrice * $data->qty,2)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
    ),
));
?>