<?php
$this->breadcrumbs = array(
    'Purchase Orders' => array('index'),
    'Manage',
);


$jobmenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}
$jobinfocusmenu = null;
if(isset(Yii::app()->session['job_in_focus_id'])){
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'),'linkOptions'=>array('style'=>'background-color:orange;'));
}
$refreshMyobMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
	$refreshMyobMenu = array(
		'label' => 'Synchronize MYOB POs',
		'url' => array('#'),
		'linkOptions' => array(
			'onclick' => 'myobSynchronizeAll(this);return false;',
			'data-loading-text' => "MYOB POs Synchronizing...",
			'data-done-text' => "MYOB POs Synchronized!",
			'data-error-text' => "MYOB Synchronizing Error!",
			'style' => 'background-color:#32cd32')
	);
}
$this->menu = array(
    $jobinfocusmenu,
	$refreshMyobMenu,
    $jobmenu,
        //array('label'=>'List PurchaseOrders', 'url'=>array('index')),
        //array('label'=>'Create Purchase Order', 'url'=>array('purchase')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('purchase-orders-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>
    Manage Purchase Orders&nbsp;
    <?php 
        if(isset($_GET['pastdue']) && $_GET['pastdue'] == 1) echo '[ PAST DUE DATE ]';
    ?>
</h1>

<div >
    <?php 
        foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
        }
    ?>
</div>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'purchase-orders-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        array(
            'name' =>  'poNum',
            'value' => '$data->getPONumberHtml()',
            'type' => 'raw',
        ),
       
        array(
            'name' => 'job_search',
            'value' => 'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'supplier_search',
            'value' => 'Supplier::model()->findByPk($data->supplier_id)->supnam',
            
        ),
        
        array(
            'name' => 'customer_search',
            'value' => '$data->job->customer->cusnam'
        ),
        array(
            'name' => 'followupDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))'
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))'
        ),
        'poType',
        array(
            'name'=>'status_id',
            'value'=>'Status::model()->findByPk($data->status_id)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,3,7,9,39)")), 'id', 'name'),
            
        ),
        //'workorder_id',
        //'quote_id',
        //'quoteNum',
        /*
          'poNum',
          'poType',
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{confirm}{sep2}{completed}{sep3}{print}',
            'buttons' => array(                
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                    
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible'=>'in_array($data->status_id,array(1))',
                ),
                
                'confirm' => array
                    (
                    'label' => 'Confirm',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("purchaseOrders/confirm", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                    'visible'=>'in_array($data->status_id,array(1))',
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible'=>'in_array($data->status_id,array(1,2))',
                    
                ),
                'completed' => array
                    (
                    'label' => 'Completed',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("purchaseOrders/complete", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                    'visible'=>'in_array($data->status_id,array(1,2))',
                ),
                'sep3' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                
                'print' => array
                    (
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("purchaseOrders/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                    
                   ),
            ),
        ),
    ),
));
?>
<script type="text/javascript">


    function myobSynchronizeAll(e)
    {
        var $this = $(e);
        startMyobStreaming($this);       
        $this.button('loading');

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("purchaseOrders/MYOBSyncronizeAll"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
                myobSynchronizeDone($this);
            },
            error: function (result) {
                //$this.button('done');
                 console.log(result);
            },

        });
    }

    function startMyobStreaming($this) { /* $this refer to trigered element */
        xhr = new XMLHttpRequest();
        xhr.open("GET", "<?php echo Yii::app()->createUrl("purchaseOrders/MYOBSyncronizeAll"); ?>", true);
        xhr.onprogress = function (e) {
			
            var str = e.currentTarget.responseText;
            var res = str.split("~");

            var num = [];
            $.each(res, function (index, value) {
                num.push(value.replace(/[^0-9\/]/g, ''));

            });

            var newArray = num.filter(function (v) {
                return v !== ''
            });

            console.log(num[num.length - 2]);
            
			
			$this.empty();
			$this.text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);
            


        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) { /* streaming DONE */
                myobSynchronizeDone($this);
            }
        }
        xhr.send();
    }

    function myobSynchronizeDone($this) {
        $this.button('done');
        $('#purchase-orders-grid').yiiGridView('update');
    }
</script>
