

<h1>Create Product-OtherCost PO</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<div class="view">
    <div class="view">
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                array(
                    'label' => 'Job',
                    'value' => $model->job->jobNum,
                ),
                array(
                    'name' => 'workorder_id',
                    'value' => $model->workorder->salesorderNumber,
                ),
                array(
                    'label' => 'Date',
                    'value' => date('Y-m-d', strtotime('now')),
                ),
            ),
        ));
        ?>
    </div>
    <div class="clear"></div>


    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));

        echo $form->dropDownList($model, 'supplier_id', CHtml::listData(Supplier::model()->findAll(array('order' => 'supnam asc')), 'supsno', 'supnam'), array('empty' => 'Select Supplier'));

        $todayDate = date(GlobalVars::get("DateFormat")); // current date
        $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
        $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);
        echo $form->labelEx($model, 'dueDate', array('style' => 'display:inline;margin-left:20px;margin-right:5px;'));
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'dueDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
            'language' => 'en-GB'
        ));

        echo $form->labelEx($model, 'followupDate', array('style' => 'display:inline;margin-left:20px;margin-right:5px;'));
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>





        <?php
        $grandTotal = 0;
        $count = 0;
        foreach ($jobProductMultiOtherCostArr as $workOrderDetailId => $otherCostArr) {
            ++$count;
            $data = Workorderdetails::model()->findByPk($workOrderDetailId);
            
            $productLineAmount = $data->prodCostPrice *  $data->prodQty;
            $grandTotal +=  $productLineAmount;
            ?>




            <table class="items" style="background-color: #EEE;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Image</th>
                        <th>Product</th>
                        <th>Product Description</th>						
                        <th>Quantity</th>
                        <th>Cost</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo $count; ?></td>
                        <td><?php echo CHtml::image($data->getImg(), '', array('style' => 'max-width:100px;')); ?></td>
                        <td>
                            <?php echo $data->productsku; ?>
                            <p>
                                <?php echo $data->prdsrtdesc; ?>
                            </p>
                        </td>
                        <td>
                            <p>
                                <?php
                                echo $data->prdlngdesc;
                                ?>
                            </p>
                        </td>


                        <td>
                            <?php
                            echo $data->prodQty;
                            ?>
                        </td>
                        <td>
                            <?php
                            echo number_format($data->prodCostPrice, 2);
                            ?>
                        </td>
                        <td>
                            <?php
                            echo number_format(($productLineAmount), 2);
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5">
                            <table>
                                <thead>
                                    <tr>
                                        <th>&nbsp;</th>
                                        <th>Group Name</th>
                                        <th>Cost Name</th>                                        
                                        <?php if ((int) SystemOptions::getOptions()->enbleXero): ?><th>Xero Account</th><?php endif; ?>
                                        <th>Cost Price</th>
                                        <th>Line Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sectionTotal = 0;
                                    foreach ($otherCostArr as $key => $jpdid) {
                                        $jpoc = JobProductOtherCost::model()->findByPk($jpdid);
                                        if (!in_array($jpoc->other_cost_name, array(JobProductDecorations::PRODUCT_DECORATION_LINE_CODE))) {
                                            ?>
                                            <tr>
                                                <td>
                                                    <input type="hidden" name="JobProductOtherCost[<?php echo $data->id; ?>][]" value="<?php echo $jpoc->id; ?>"/>&nbsp;&nbsp; 
                                                </td>
                                                <td>
                                                    <p>
                                                        <?php echo $jpoc->other_cost_group_name; ?>
                                                    </p>
                                                </td>
                                                <td>
                                                    <p>
                                                        <?php echo $jpoc->other_cost_name; ?>
                                                    </p>
                                                </td>
                                                <?php if ((int) SystemOptions::getOptions()->enbleXero): ?>
                                                    <td>
                                                        <?php
                                                        echo CHtml::dropDownList("Workorderdetails[xero_account_id][$jpoc->id]", trim(XeroSetting::getSetting()->defalutPOAccountId), CHtml::listData(XeroAccount::model()->findAll("code like '5%'"), "id", "name"), array("empty" => ""))
                                                        ?>
                                                    </td>
                                                <?php endif; ?>
                                                <td>
                                                    <?php
                                                    echo number_format($jpoc->cost_price, 2);
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $lineTotal = (round($jpd->cost_price, 2) * $data->prodQty);
                                                    $sectionTotal += $lineTotal;
                                                    $grandTotal += $lineTotal;
                                                    echo number_format($lineTotal, 2);
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }else {
                                            ?>
                                            <input type="hidden" name="JobProductOtherCost[<?php echo $data->id; ?>][]" value="<?php echo $jpoc->id; ?>"/>
                                            <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="5" style="text-align: right;">
                            Total :
                        </td>
                        <td>
                            <?php echo number_format($sectionTotal, 2); ?>
                        </td>
                    </tr>

                </tfoot>
                <tbody>

                </tbody>
            </table>


            <?php
        }
        ?>

        <table style="background-color: #EEE;width: 100%;">
            <tfoot>
                <tr>
                    <td style="text-align: right;font-weight: bold;width: 95%;">Grand Total : </td>
                    <td style="text-align: right;"><?php echo number_format($grandTotal, 2); ?></td>

                </tr>
            </tfoot>
        </table>


        <?php
        echo $form->textField($model, 'job_id', array('style' => 'display:none;', 'value' => $model->job_id));
        echo $form->textField($model, 'workorder_id', array('style' => 'display:none;', 'value' => $model->workorder_id));
        echo $form->textField($model, 'quote_id', array('style' => 'display:none;', 'value' => $model->quote_id));
        echo $form->textField($model, 'quoteNum', array('style' => 'display:none;', 'value' => $model->quoteNum));
        echo $form->textField($model, 'poType', array('style' => 'display:none;', 'value' => $model->poType));

//        echo $form->dropDownList($model, 'delivery_status_id', CHtml::listData(DeliveryStatus::model()->findAll(), 'id', 'name'), array('empty' => 'Select Status'));
//        
//        echo $form->labelEx($model, 'delivery_notes', array('style' => 'display:inline;margin-left:20px;margin-right:5px;'));
//        echo $form->textArea($model,'delivery_notes',array('rows'=>6, 'cols'=>10, 'style'=>'width:500px;'));
        ?>
    </div>
    <div class="clear"></div>
    <div>
        <?php
        echo CHtml::submitButton('Create', array('style' => 'float:left'));
        ?>
    </div>
    <div class="clear"></div>
    <?php $this->endWidget(); ?>

</div>


