<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>

<h1>Purchase Order Dashboard</h1>



<?php
$poGridColumns = array(
    //'id',
    //'ws_id',
    array(
        'header' => 'No.',
        'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
    ),
    array(
        'name' => 'createdDtm',
        'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
    ),
    array(
        'name' =>  'poNum',
        'value' => '$data->getPONumberHtml()',
        'type' => 'raw',
    ),
   
    array(
        'name' => 'job_search',
        'value' => 'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
        'type' => 'raw',
    ),
    array(
        'name' => 'supplier_search',
        'value' => 'Supplier::model()->findByPk($data->supplier_id)->supnam',
        
    ),
    
    array(
        'name' => 'notation',
        'value' => '$data->notation'
    ),
    array(
        'name' => 'followupDate',
        'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))'
    ),
    array(
        'name' => 'dueDate',
        'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))'
    ),
    'poType',
    array(
        'name' => 'followup_status_id',
        'value' => '$data->getFollowupStatus()',
        'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = '" . FollowupStatus::PURCHASE_ORDER . "'", 'order' => 'status ASC')), 'id', 'status'),
    // 'type' => 'raw',
    )
);



$poFollowUpStatuses = FollowupStatus::model()->findAll(array('condition' => "type = '" . FollowupStatus::PURCHASE_ORDER . "'", 'order' => 'status_sequence,status'));
foreach ($poFollowUpStatuses as $status) {
    $poGridColumns[] = array(
        'header' => $status->status,
        'value' => '',  
        'type' => 'html',
        'class' => 'DataColumn',
        'evaluateHtmlOptions' => true,
        'headerHtmlOptions' => array('style' => 'width:75px;'),
        'htmlOptions' => array(
            'style' => '$data->followup_status_id == ' . $status->id . ' ?  "background-color:' . $status->color_hex . ';font-weight:bold;" : "background-color:none;font-weight:bold;"'
        )
    );
}

$poGridColumns[] = array(
    'class' => 'CButtonColumn',
    'template' => '{view}',
    'buttons' => array(
        'view' => array(
            'label' => 'View',
            'imageUrl' => false,
        ),
    )
);


$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'po-grid',
    'dataProvider' => $model->searchDashboard(),
    'filter' => $model,
    'columns' => $poGridColumns,
));
?>


<style>
    #po-grid table thead tr th{
        background-image: none;
        background-color: #82B8D6;

    }
</style>
