<?php
$this->breadcrumbs = array(
    'Purchase Orders' => array('index'),
    'Manage',
);


$jobmenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

$this->menu = array(
    $jobmenu,
        //array('label'=>'List PurchaseOrders', 'url'=>array('index')),
        //array('label'=>'Create PurchaseOrders', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('purchase-orders-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Outstanding Purchase Orders List</h1>

<?php 
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'outstanding-form',
        'enableAjaxValidation' => false,
    ));
?>
<div class="form view">
    <!-- search on date between created date -->
    <div class="row">
        <label  for="createdDtm">Created Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Created Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between follow up dates -->
    <div class="row">
        <label  for="createdDtm">Follow-up Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Follow-up Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between expected date -->
    <div class="row">
        <label  for="createdDtm">Due Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'expecteddatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Due Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'expecteddateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <div class="clear"></div>
    <div class="buttons row">
        <?php echo CHtml::submitButton('Reset'); ?><?php echo CHtml::submitButton('Go'); ?>
        <?php $this->endWidget(); ?>
    </div>
    <div style="float: right;">
        <?php echo CHtml::button('Print PDF',array('style'=>'float:right;','onclick'=>'generatePDF();')); ?>
        <?php echo CHtml::button('Generate Excel',array('style'=>'float:right;','onclick'=>'generateExcel();')); ?>
    
    </div>
     <div class="clear"></div>
</div>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'purchase-orders-grid',
    'dataProvider' => $model->searchoutstadingpos(),
    'filter' => $model,
    'columns' => array(
        //'id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'jobDueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->job->dueDate))',
            'filter'=>false,
        ),
        array(
            'name' =>  'poNum',
            'value' => 'CHtml::link($data->poNum,array("purchaseOrders/view","id"=>$data->id),array("target"=>"_blank"))',
            'type' => 'raw',
            //'filter'=>false,
        ),
       
        array(
            'name' => 'jobNumber',
            'value' => 'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name'=>'supplier_id',
            'value'=>'Supplier::model()->findByPk($data->supplier_id)->supnam',
            'filter'=>CHtml::listData(Supplier::model()->findAll(array('order'=>'supnam asc')), 'supsno', 'supnam'),
            
        ), 
        
        array(
            'name' => 'notation',
            'value' => '$data->notation',
            'filter'=>false,
        ),
        array(
            'name' => 'followupDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))',
            'filter'=>false,
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))',
            'filter'=>false,
        ),
        
        array(
            'name'=>'poType',            
//            'filter'=>CHtml::listData(array(
//                'Purchase Product'=>'Purchase Product'
//                ,'Purchase Artwork'=>'Purchase Artwork'
//                ,'Purchase Product-Decoration'=>'Purchase Product-Decoration'
//                
//                )),
            'filter'=>CHtml::dropDownList('PurchaseOrders[poType]', '',  
                array(
                    ''=>'All',
                     'Purchase Product'=>'Purchase Product'
                    ,'Purchase Artwork'=>'Purchase Artwork'
                    ,'Purchase Product-Decoration'=>'Purchase Product-Decoration'
                )
            ),
            
        ),
        array(
            'name'=>'status_id',
            'value'=>'Status::model()->findByPk($data->status_id)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,3,7,9)")), 'id', 'name'),
            
        ),
        //'workorder_id',
        //'quote_id',
        //'quoteNum',
        /*
          'poNum',
          'poType',
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
       
    ),
));
?>

<script>
    function generateExcel(){
        var win = window.open('index.php?r=purchaseOrders/generateOutstandingPOsExcel');
   
    }
    
    function generatePDF(){
        var win = window.open('index.php?r=purchaseOrders/generateOutstandingPOsPDF');
   
    }
</script>
