<?php
Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');


$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}

$artworkmenu = null;
if (isset($artwork)) {
    $artworkmenu = array('label' => 'Artwork : ' . $artwork->artworkjobNum, 'url' => array('jobArtwork/view', 'id' => $artwork->id));
}

$consolidateMenu = null;
if ($model->supplier_id) {
    $consolidatedPO = $model->getMasterPO();
    $statusId = Status::model()->findByAttributes(array('name' => 'OPEN'))->id;
    $supOpenConsolidate = ConsolidatedPurchaseOrder::model()->find(array('condition' => "supplier_id = {$model->supplier_id} and status_id = {$statusId} and po_type = '{$model->poType}'", 'order' => "id desc"));


    if (!$consolidatedPO && $supOpenConsolidate) {

        $consolidateMenuName = 'Consolidate';
        $consolidateMenu = array('label' => $consolidateMenuName, 'url' => array('#', 'po' => $model->id), 'linkOptions' => array('style' => 'background-color:#d1a215', 'onclick' => 'showConsolidateModel();return false;'));
    } else if ($consolidatedPO) {

        $consolidateMenuName = 'Consolidated to [ ' . $consolidatedPO->po_number . ' ]';
        $consolidateMenu = array('label' => $consolidateMenuName, 'url' => array('consolidatedPurchaseOrder/consolidate', 'po' => $model->id), 'linkOptions' => array('style' => 'background-color:#00aa00'));
    } else {

        $consolidateMenu = array('label' => 'Consolidate New', 'url' => array('consolidatedPurchaseOrder/consolidate', 'po' => $model->id), 'linkOptions' => array('style' => 'background-color:#d1a215'));
    }
}

$myobSyncronizeMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
    //$loadinghtml = '&nbsp;<img class="loading-myob" src="images/loading_bar.gif" style="width:60px;height:25px;display:none;">';
    $myobSyncronizeMenu = array(
        'label' => 'Synchronize MYOB',
        'url' => array('#'),
        'linkOptions' => array(
            'id' => $model->id,
            'onclick' => 'myobSynchronize(this);return false;',
            'data-loading-text' => "MYOB Synchronizing...",
            'data-done-text' => "MYOB Synchronized!",
            'data-error-text' => "MYOB Synchronizing Error!",
            'style' => 'background-color:#32cd32')
    );
}

$xeroQueueMenu = null;

if (intval(SystemOptions::getOptions()->enbleXero)) {
    //check whethere the order is not uploaded successfully and is queued for revoke
    if ($model->xero_in_queue) {
        $xeroQueueMenu = array('label' => 'Revoke Xero Queue', 'url' => '#', 'linkOptions' => array('submit' => array('toggleXeroQueue', 'id' => $model->id), 'confirm' => 'Are you sure you want to revoke this item from the Xero queue?'));
    }
    if (!$model->xero_in_queue) {
        $xeroQueueMenu = array('label' => 'Add Xero Queue', 'url' => '#', 'linkOptions' => array('submit' => array('toggleXeroQueue', 'id' => $model->id), 'confirm' => 'Are you sure you want to add this item to the Xero queue?'));
    }
}


$this->menu = array(
    $jobinfocusmenu,
    array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id)),
    $xeroQueueMenu,
    $myobSyncronizeMenu,
    $artworkmenu,
    $consolidateMenu,
    array('label' => 'Update PO', 'url' => array('update', 'id' => $model->id), 'visible' => in_array($model->status_id, array(1)), 'linkOptions' => array()),
    //array('label'=>'List PurchaseOrders', 'url'=>array('index')),
    //array('label'=>'Create PurchaseOrders', 'url'=>array('create')),
    //array('label'=>'Update Purchase Orders', 'url'=>array('update', 'id'=>$model->id)),
    array('label' => 'Delete Purchase Orders', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Purchase Orders', 'url' => array('admin')),
);
?>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<?php echo $model->getMYOBError(); ?>
<h1>View PO #<?php echo $model->poNum; ?></h1>
<input type="hidden" id="po-id" value="<?php echo $model->id; ?>" />
<input type="hidden" id="po-type" value="<?php echo $model->poType; ?>" />
<div class="view">
    <p style="font-size: 1.2em; font-weight: bold;">Purchase Order Header Details</p>

    <?php
    /**
     * Followup date component
     */
    ob_start();


    Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
    $this->widget('CJuiDateTimePicker', array(
        'model' => $model, //Model object
        'attribute' => 'followupDate', //attribute name
        'mode' => 'date', //use "time","date" or "datetime" (default)
        'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
        'htmlOptions' => array('style' => 'text-align:center;', "id" => "followupDate_{$model->id}", 'onchange' => "onDateChange({id:{$model->id}, attribute:'followupDate', value:this.value});"),
        'language' => 'en-GB'
    ));

    $followupDateTimePicker = ob_get_contents();
    ob_end_clean();

    /**
     * Due date component
     */
    ob_start();


    Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
    $this->widget('CJuiDateTimePicker', array(
        'model' => $model, //Model object
        'attribute' => 'dueDate', //attribute name
        'mode' => 'date', //use "time","date" or "datetime" (default)
        'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
        'htmlOptions' => array('style' => 'text-align:center;', "id" => "dueDate_{$model->id}", 'onchange' => "onDateChange({id:{$model->id}, attribute:'dueDate', value:this.value});"),
        'language' => 'en-GB'
    ));

    $dueDateTimePicker = ob_get_contents();
    ob_end_clean();

    $this->widget('zii.widgets.CDetailView', array(
        'id' => 'po-view',
        'data' => $model,
        'attributes' => array(
            'id',
            array(
                'name' => 'poNum',
                'value' => $model->getPONumberHtml(),
                'type' => 'html',
            ),
            array(
                'name' => 'workorder_id',
                'value' => CHtml::link($model->workorder->salesorderNumber, array('workorderdetails/admin', 'wid' => $model->workorder_id), array("target" => "_blank")),
                'type' => 'raw',
            ),
            array(
                'name' => 'job.jobNum',
                'value' => CHtml::link($model->job->jobNum, array('jobs/view', 'id' => $model->job_id), array("target" => "_blank")),
                'type' => 'raw',
            ),
            /*
              array(
              'name' => 'supplier_id',
              'value' => CHtml::link(Supplier::model()->findByPk($model->supplier_id)->supnam, array('supplier/view', 'id' => $model->supplier_id), array("target" => "_blank")),
              'type' => 'raw',
              ),
             * 
             */
            array(
                'name' => 'supplier_id',
                'value' => CHtml::dropDownList('supplier_id', $model->supplier_id, CHtml::listData(Supplier::model()->findAll(array('order' => 'supnam asc')), 'supsno', 'supnam'), array('empty' => 'Select Supplier', "id" => "supplier_" . $model->id))
                . '<span id="save_supplier_' . $model->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                'type' => 'raw',
            ),
            array(
                'name' => 'artwork_job_id',
                'value' => CHtml::link(JobArtwork::model()->findByPk($model->artwork_job_id)->artworkjobNum, array('jobArtwork/view', 'id' => $model->artwork_job_id), array("target" => "_blank")),
                'type' => 'raw',
                'visible' => $model->poType == 'Purchase Artwork',
            ),
            //'quote_id',
            //'quoteNum',
            'poType',
            //'notation',
//        array(
//            'name' => 'image',
//            'type' => 'raw',
//            'value' => CHtml::image("images/artwork/" . $model->image, '', array('width' => 100)),
//            'visible' => $model->poType == 'Purchase Artwork',
//        ),
            array(
                'name' => 'notation',
                'value' => $model->getTextAreaForPOView('notation', $model->notation, $model->id),
                //'value' => CHtml::textArea('quotecomments', $model->quotecomments, array("style" => "width:300px;", "rows" => 5, "id" => "quote_" . $model->id)),
                'type' => 'raw',
            ),
            array(
                'name' => 'followup_status_id',
                'value' => CHtml::dropDownList('followup_status_id', $model->followup_status_id, CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = '" . FollowupStatus::PURCHASE_ORDER . "'", 'order' => '-status_sequence DESC, id DESC')), 'id', 'status'), array('empty' => 'Select Follow-Up', "id" => "followup_" . $model->id))
                . '<span id="save_followup_' . $model->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>',
                'type' => 'raw',
            ),
            array(
                'name' => 'followupDate',
                'value' => $followupDateTimePicker,
                'type' => 'raw',
            ),
            array(
                'name' => 'dueDate',
                'value' => $dueDateTimePicker,
                'type' => 'raw',
            ),
            array(
                'name' => 'user_id',
                'value' => User::model()->findByPk($model->user_id)->username,
            ),
            array(
                'name' => 'status_id',
                'value' => Status::model()->findByPk($model->status_id)->name,
            ),
            array(
                'label' => 'MYOB',
                'value' => $model->getMYOBLabel(),
                'visible' => $model->getMYOBLabel(),
                'type' => 'raw',
            )
        ),
    ));
    ?>
</div>
<div class="clear"></div>

<?php
if ($model->poType == 'Purchase Artwork') {
    echo $this->renderPartial('_view_artwork', array(
        'decorationproducts' => $decorationproducts,
        'artwork'=>$artwork      
    ));
} else {
    
    $podtls = new PurchaseOrderDetails();
    $podtls->po_id = $model->id;
    if ($model->poType == PurchaseOrders::PO_TYPE_PROUDCT) {
        echo $this->renderPartial('_view_product', array(
            'model' => $model,    
            'podtls' => $podtls        
        ));
        
    } else if ($model->poType == PurchaseOrders::PO_TYPE_PROUDCT_DECORATION) {
        echo $this->renderPartial('_view_product_decoration', array(
            'podtls' => $podtls,            
        ));
        
    } else if ($model->poType == PurchaseOrders::PO_TYPE_PROUDCT_OTHER_COST) {
        echo $this->renderPartial('_view_product_othercost', array(
            'podtls' => $podtls,            
        ));
        
    }
}
?>

<div class="clear"></div>
<div class="view">
    <h3>Sales Contacts & Activities</h3>   
    <?php
    $salesLog = new SalesLog();
    $salesLog->tbl_id = $model->id;
    $salesLog->category = SalesLog::CATEGORY_PURCHASE_ORDER;

    $this->renderPartial('/salesLog/_crmgrid', array('salesLog' => $salesLog));
    ?>    


    <span style="font-size: 1em;font-weight: bold;">Add Sales Contact or Activity</span>  <br> 
    <div class="form">

        <?php
        $this->renderPartial('/salesLog/_crmform', array('salesLog' => $salesLog));
        ?>
        <div class="clear"></div>
    </div>
</div>
<div class="clear"></div>

<?php
if ($model->poType != 'Purchase Artwork') {
    ?>

    <div class="view">
        <h3>Delivery Details</h3>   
        <?php
        $signofflog = new SignOffLog();
        $signofflog->model = 'PurchaseOrder';
        $signofflog->model_id = $model->id;

        $this->renderPartial('/signOffLog/_admin', array('signoffLog' => $signofflog));
        ?>    



        <div class="view">
            <span style="font-size: 1em;font-weight: bold;">Add Delivery Details</span>  <br> 
            <?php
            $this->renderPartial('/signOffLog/_inc_form', array('signoffLog' => $signofflog));
            ?>
            <div class="clear"></div>
        </div>



        <div class="clear"></div>
    </div>

<?php } ?>   

<div class="clear"></div>
<div style="display: inline;float: right;margin-right: 5px;">

    <?php
    echo CHtml::button('PO Settings', array('onclick' => "poSettings($model->id)", 'style' => 'background-color:#00aa00;'));
    if ((int) SystemOptions::getOptions()->enbleXero) {
        echo CHtml::button('Update Xero', array('onclick' => "xeroUpdate($model->id)"));
    }
    echo CHtml::button('EXPORT PO as XML', array('onclick' => "exportPOXML($model->id)", 'style' => 'background-color:#C45C1B;'));
    echo CHtml::button('Send Purchase Order', array('onclick' => "sendEmail($model->id,'PurchaseOrder')"));
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)"));
    ?>
</div>

<!--end new product model-->
<div id="consolidate-model" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">

                <h3 style="text-align: center;">Consolidate</h3>
            </div>
            <div class="modal-body">
                <h5>Available open master purchase orders for supplier '<?php echo Supplier::model()->findByPk($model->supplier_id)->supnam; ?>'</h5>
                <?php
                $this->widget('zii.widgets.grid.CGridView', array(
                    'id' => 'consolidated-purchase-order-grid',
                    'dataProvider' => $supOpenConsolidates->search(),
                    'filter' => $supOpenConsolidates,
                    'selectableRows' => 1,
                    'columns' => array(
                        array(
                            'class' => 'CCheckBoxColumn',
                        ),
                        'po_number',
                        array(
                            'name' => 'search_supplier',
                        ),
                        'comments',
                        array(
                            'name' => 'due_date',
                            'value' => 'Refiner::getdatetext($data->due_date, GlobalVars::get("DateFormat"))'
                        ),
                        array(
                            'name' => 'created_date',
                            'value' => 'Refiner::getdatetext($data->created_date, GlobalVars::get("DateFormat"))'
                        )
                    ),
                ));
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="newconsolidate();">Consolidate New</button>
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="consolidateInto();">Consolidate to Selected</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
        </div>

    </div>
</div>
<style type="text/css">
    .price{
        text-align: right;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script>




                    function onDateChange(obj) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/onDateChange"); ?>',
                            data: obj,
                            dataType: 'json',
                            success: function (result) {

                                console.log(result);
                            },
                            error: function (result) {
                                console.log('error in update');
                            }
                        });
                    }

                    function myobSynchronize(e)
                    {
                        var $this = $(e);
                        $this.button('loading');
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/MYOBSyncronize"); ?>',
                            data: {'id': $(e).attr('id')},
                            dataType: 'json',
                            success: function (result) {
                                $this.button('done');
                                location.reload(true);
                            },
                            error: function (result) {
                                $this.button('error');
                                location.reload(true);
                            }
                        });
                    }


                    function exportPOXML(id) {
                        var win = window.open('index.php?r=purchaseOrders/exportPOXML&id=' + id);
                    }

                    function showConsolidateModel() {
                        $('#consolidate-model').modal('show');
                    }

                    function consolidateInto() {
                        var poId = $('#po-id').val();
                        var values = new Array();
                        $.each($("input[name='consolidated-purchase-order-grid_c0[]']:checked"), function () {
                            values.push($(this).val());
                            // or you can do something to the actual checked checkboxes by working directly with  'this'
                            // something like $(this).hide() (only something useful, probably) :P
                        });

                        if (values.length > 0) {
                            window.location = 'index.php?r=consolidatedPurchaseOrder/consolidate&po=' + poId + '&conin=' + values[0];
                        }
                    }

                    function newconsolidate() {
                        var poId = $('#po-id').val();
                        window.location = 'index.php?r=consolidatedPurchaseOrder/consolidate&po=' + poId + '&newcon=true';
                    }



                    function poSettings(id) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/fetchPurchaseOrderFlags"); ?>',
                            data: {id: $('#po-id').val()},
                            dataType: 'json',
                            success: function (result) {


                                var options = {};
                                options.selected = result.flags;
                                if ($('#po-type').val() === 'Purchase Product') {
                                    options.inputOptions = [
                                        {
                                            text: 'Show Price on PDF',
                                            value: 'show_price_on_pdf',
                                        },
                                        {
                                            text: 'Show Product Cost',
                                            value: 'show_product_cost',
                                        },
                                        {
                                            text: 'Show SO Customisation Details',
                                            value: 'show_so_customisation',
                                        },
                                        {
                                            text: 'Show SO Notes',
                                            value: 'show_notes',
                                        },
                                        {
                                            text: 'Show Job Info',
                                            value: 'show_job_info',
                                        },
                                        {
                                            text: 'Show Website Ordering Info',
                                            value: 'show_website_ordering_info',
                                        },
                                    ];

                                } else if ($('#po-type').val() === 'Purchase Product-Decoration') {
                                    options.inputOptions = [
                                        {
                                            text: 'Show Price on PDF',
                                            value: 'show_price_on_pdf',
                                        },
                                        {
                                            text: 'Show Product Cost',
                                            value: 'show_product_cost',
                                        },
                                        {
                                            text: 'Show Decoration',
                                            value: 'show_decoration',
                                        },
                                        {
                                            text: 'Show Decoration Cost',
                                            value: 'show_decoration_cost',
                                        },
                                        {
                                            text: 'Show Logo Setup',
                                            value: 'show_logo_setup',
                                        },
                                        {
                                            text: 'Show Decoration Customisation Details',
                                            value: 'show_customisation_details',
                                        },
                                        {
                                            text: 'Show SO Customisation Details',
                                            value: 'show_so_customisation',
                                        },
                                        {
                                            text: 'Show SO Notes',
                                            value: 'show_notes',
                                        },
                                        {
                                            text: 'Show Job Info',
                                            value: 'show_job_info',
                                        },
                                        {
                                            text: 'Show Website Ordering Info',
                                            value: 'show_website_ordering_info',
                                        },
                                    ];

                                }else if ($('#po-type').val() === 'Purchase Product-OtherCost') {
                                    options.inputOptions = [
                                        {
                                            text: 'Show Price on PDF',
                                            value: 'show_price_on_pdf',
                                        },
                                        {
                                            text: 'Show Product Cost',
                                            value: 'show_product_cost',
                                        },                                        
                                        {
                                            text: 'Show Customisation Details',
                                            value: 'show_customisation_details',
                                        },
                                        {
                                            text: 'Show SO Customisation Details',
                                            value: 'show_so_customisation',
                                        },
                                        {
                                            text: 'Show SO Notes',
                                            value: 'show_notes',
                                        }                                        
                                    ];

                                }

                                bootbox.prompt({
                                    title: "Purchase Order Settings",
                                    value: options.selected,
                                    inputType: 'checkbox',
                                    inputOptions: options.inputOptions,
                                    callback: function (result) {
                                        if (result) {
                                            var obj = {};
                                            obj.id = id;
                                            obj.flags = result;
                                            updatePurchaseOrderFlags(obj);
                                        }
                                    }
                                });


                            },
                            error: function (result) {
                                console.log(result);
                            }
                        });



                    }

                    function updatePurchaseOrderFlags(obj) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/updatePurchaseOrderFlags"); ?>',
                            data: obj,
                            dataType: 'json',
                            success: function (result) {


                            },
                            error: function (result) {
                                console.log(result);
                            }
                        });
                    }

                    function printPDF(id) {




                        var win = window.open('index.php?r=purchaseOrders/print&id=' + id);
                    }

                    function sendEmail(id, emailtype) {



                        var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
                    }

                    function xeroUpdate(id) {
                        initFlags();
                        var win = window.open('index.php?r=purchaseOrders/xeroUpdate&id=' + id);
                    }

                    $(document).ready(function () {
                        $('#po-view input, textarea, select').change(function () {
                            var strid = $(this).attr('id');
                            var arr = strid.split('_');
                            var value = $(this).val();

                            if (arr[0] == 'notation') {
                                updatePOnotation(arr[1], value);
                            } else if (arr[0] == 'followup') {
                                updateFollowUpStatus(arr[1], value);
                            } else if (arr[0] == 'supplier') {
                                updateSupplier(arr[1], value);
                            }

                        })
                    });

                    function updatePOnotation(id, value) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/updatePOnotation"); ?>',
                            data: {'id': id, 'value': value},
                            dataType: 'json',
                            success: function (result) {

                                if (result.success == true) {
                                    changessaved(id, 'notation');
                                }
                            },
                            error: function (result) {
                                console.log('error in update');
                            }
                        });
                    }

                    function updateSupplier(id, value) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/updateSupplier"); ?>',
                            data: {'id': id, 'value': value},
                            dataType: 'json',
                            success: function (result) {

                                if (result.success == true) {
                                    changessaved(id, 'supplier');
                                }
                            },
                            error: function (result) {
                                console.log('error in update');
                            }
                        });
                    }

                    function updateFollowUpStatus(id, value) {
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/updateFollowUpStatus"); ?>',
                            data: {'id': id, 'value': value},
                            dataType: 'json',
                            success: function (result) {

                                if (result.success == true) {
                                    changessaved(id, 'followup');
                                }
                            },
                            error: function (result) {
                                console.log('error in update');
                            }
                        });
                    }

                    function saveDeliveryNote() {
                        var po_id = $('#po_id').val();
                        var delivery_status_id = $('#delivery_status_id').val();
                        var delivery_note_txt = $('#deliverynotes').val();
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("purchaseOrders/updateDeliveryNote"); ?>',
                            data: {'id': po_id, 'delivery_status_id': delivery_status_id, 'delivery_note_txt': delivery_note_txt},
                            dataType: 'json',
                            success: function (result) {

                                if (result.success == true) {
                                    $('#delivery_note_msg').fadeIn(500).fadeOut(1500);
                                    $('#deliverynotes').empty();
                                    $('#deliverynotes').val(result.delivery_note);
                                }
                            },
                            error: function (result) {
                                alert('error in update');
                            }
                        });
                    }


                    function changessaved(id, elementname) {
                        $('#save_' + elementname + '_' + id).fadeIn(500).fadeOut(1500);
                    }



</script>