<?php

require 'vendor/autoload.php';

//require_once('storage.php');
// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

// Storage Classe uses sessions for storing token > extend to your DB of choice
$storage = new StorageClass();
$xeroTenantId = (string) $storage->getSession()['tenant_id'];

if ($storage->getHasExpired()) {
	$provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

	$newAccessToken = $provider->getAccessToken('refresh_token', [
		'refresh_token' => $storage->getRefreshToken()
	]);

	// Save my token, expiration and refresh token
	$storage->setToken(
			$newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
}

$config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
$config->setHost("https://api.xero.com/api.xro/2.0");

$apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
		new GuzzleHttp\Client(), $config
);

//po flag options
$show_price = $model->flag->show_price;

try {

	$addresses = [];
	$address = new XeroAPI\XeroPHP\Models\Accounting\Address;
	$address->setAddressType('POBOX');
	$address->setAddressLine1($model->supplier_->supad1);
	$address->setAddressLine2($model->supplier_->supad2);
	$address->setAddressLine3($model->supplier_->supad3);
	$address->setCity($model->supplier_->suptown);
	$address->setRegion($model->supplier_->supstate);
	$address->setPostalCode($model->supplier_->suppostcode);

	array_push($addresses, $address);

	$phones = [];
	$phone = new XeroAPI\XeroPHP\Models\Accounting\Phone;
	$phone->setPhoneType('DEFAULT');
	$phone->setPhoneNumber($model->supplier_->suptel);
	array_push($phones, $phone);

//	$phone2 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
//	$phone2->setPhoneType('MOBILE');
//	$phone2->setPhoneNumber($model->job->customer->cusmobtel);
//
//	array_push($phones, $phone2);

	$phone3 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
	$phone3->setPhoneType('FAX');
	$phone3->setPhoneNumber($model->supplier_->supfax);

	array_push($phones, $phone3);

	$xeroSupplier = XeroSupplier::model()->find("xeroContactID = '{$model->supplier_->xeroContactID}'");

	if (!$xeroSupplier) {
		//cannot upload the PO, 
		$message = 'Cannot find the relationship between Xero supplier and the system supplier!';
		$this->redirect(array('purchaseOrders/view', 'id' => $model->id, 'xrerr' => $message));
	}


	$contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
	if (trim($model->supplier_->xeroContactID)) {
		$contact->setContactId($model->supplier_->xeroContactID);
	}

//	$contact->setName($model->supplier_->supnam);
//	$contact->setAddresses($addresses);
//	$contact->setEmailAddress($model->supplier_->supemail);
//	$contact->setPhones($phones);
//	$contact->setIsSupplier(true);
//	$contact->setContactNumber($model->supplier_->supsup_fref);
	//echo 'going to find the contact ' ,$model->supplier_->supnam, ' xeroContactID', $model->supplier_->xeroContactID;		exit();


	$po = new XeroAPI\XeroPHP\Models\Accounting\PurchaseOrder;
	$po->setPurchaseOrderNumber($model->poNum);
	$po->setStatus("DRAFT");
	$po->setContact($contact);
	$dateObj = new DateTime($model->createdDtm);
	$dateObj->format('Y-m-d');
	$po->setDate($dateObj);
	$po->setLineAmountTypes('Exclusive');
	$reference = 'PO: ' . ($model->job->customerpono?:'-') . ' Job:' . $model->job->jobNum;
	$po->setReference($reference);

	$lineItems = [];

	foreach ($modelDetial as $dtl) {
		
		$xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id);
		
		if (!$xeroAccount) {
			$xeroAccount = XeroAccount::model()->findByPk(XeroSetting::getSetting()->defalutPOAccountId); //sales default
			
		}
		$accountCode = $xeroAccount->code;
		$i = 0;
		$record = $dtl->workorderDtl;

		if (isset($show_price) && $show_price) {

                       $colorSizeQtyBreakText = '';
                       foreach ( $record->rel_size_qty_colors() as $breakUp) {
                           $colorSizeQtyBreakText .= '<br>[ ' .$breakUp->color. ' - ' . $breakUp->size . ' - ' . $breakUp->qty . ' ]';
                       }

			$item_description = trim($record->productsku . ' - ' . strip_tags(nl2br($record->prdsrtdesc))) . ' - ' . strip_tags(nl2br($record->customizationDetails)) . $colorSizeQtyBreakText;
			$productLineItem = getLineItem(array(
				'LineItemID' => $dtl->xeroLineItemID,
				'Description' => $item_description,
				'Quantity' => $record->prodQty,
				'UnitAmount' => round($record->prodCostPrice, 2),
				'LineAmount' => round($record->prodCostPrice * $record->prodQty, 2),
				'AccountCode' => $accountCode,
			));

			array_push($lineItems, $productLineItem);
		}


		$jobproddecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$dtl->po_id} and workorderDtl_id = {$dtl->workorderDtl_id}"));
		foreach ($jobproddecorations as $jobprddata) {
			/**
			 * We cannot get outer loop purchase order details directly because of it has been grouped by work order detail id
			 * so we have to find to correct purchaser order details id to get Xero account id through job product decoration model
			 */
			$jobprddecopodtl = PurchaseOrderDetails::model()->findByPk($jobprddata->po_detail_id);
			$xeroDecoAccount = XeroAccount::model()->findByPk($jobprddecopodtl->xero_account_id);

			$workorderDetailsDecoration = WorkorderDetailsDecoration::model()->findByPk($jobprddata->work_order_detail_decoration_id);

			$item_deco_description = trim($jobprddata->decprtnam . ' - ' . strip_tags(nl2br($jobprddata->decdesc))) . ' - ' . strip_tags(nl2br($jobprddata->customizationDetails));

			$decorationLineItem = getLineItem(array(
				'LineItemID' => '',
				'Description' => $item_deco_description,
				'Quantity' => $record->prodQty,
				'UnitAmount' => round($jobprddata->decoCostPrice, 2),
				'LineAmount' => round($jobprddata->decoCostPrice * $record->prodQty, 2),
				'AccountCode' => ($xeroDecoAccount ? $xeroDecoAccount->code : $accountCode )
			));

			array_push($lineItems, $decorationLineItem);



			if (!$logoSetup = $jobprddata->logo_setup) {
				$logoSetup = $workorderDetailsDecoration ? $workorderDetailsDecoration->logo_setup : 0;
			}
			$logosetupLineItem = getLineItem(array(
				'LineItemID' => '',
				'Description' => 'Logo Setup',
				'Quantity' => 1,
				'UnitAmount' => round($logoSetup, 2),
				'LineAmount' => round($logoSetup, 2),
				'AccountCode' => ($xeroDecoAccount ? $xeroDecoAccount->code : $accountCode )
			));
			array_push($lineItems, $logosetupLineItem);
		}


		$i++;
	}

	$po->setLineItems($lineItems);





	if ($model->xeroPurchaseOrderID) {

		$remote_xero_po = $apiInstance->getPurchaseOrder($xeroTenantId, $model->xeroPurchaseOrderID)->getPurchaseOrders()[0];		
		
		$po->setStatus($remote_xero_po->getStatus());

		$apiResponse = $apiInstance->updatePurchaseOrder($xeroTenantId, $model->xeroPurchaseOrderID, $po);

		$this->redirect(array('purchaseOrders/view', 'id' => $model->id, 'xr' => 1));
	} else {

		$apiResponse = $apiInstance->createPurchaseOrder($xeroTenantId, $po);
		$model->xeroPurchaseOrderID = $apiResponse->getPurchaseOrders()[0]->getPurchaseOrderId();
		if ($model->save(false)) {
			$this->redirect(array('purchaseOrders/view', 'id' => $model->id, 'xr' => 1));
		}
	}
} catch (\XeroAPI\XeroPHP\ApiException $e) {
	$error = AccountingObjectSerializer::deserialize(
					$e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
	);
	$message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
	//print_r($e->getMessage());	exit();
	$this->redirect(array('purchaseOrders/view', 'id' => $model->id, 'xrerr' => $message ?: $e->getMessage()));
}

function getLineItem($data = array())
{
	$lineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
	$lineItem->setLineItemId($data['LineItemID']);
	$lineItem->setDescription($data['Description']);
	$lineItem->setQuantity($data['Quantity']);
	$lineItem->setUnitAmount($data['UnitAmount']);
	$lineItem->setLineAmount($data['LineAmount']);
	$lineItem->setAccountCode($data['AccountCode']);



	return $lineItem;
}
