<?php
$refreshXeroMenu = array(
        'label' => 'Synchronize Xero Invoices',
        'url' => array('#'),
        'linkOptions' => array(
            'onclick' => 'xeroSynchronizeAll(this);return false;',
            'data-loading-text' => "Xero Invoices Synchronizing...",
            'data-done-text' => "Xero Invoices Synchronized!",
            'data-error-text' => "Xero Synchronizing Error!",
            'data-auth-text' => "Xero Authentication Error!",
            'style' => 'background-color:#32cd32')
    );


$this->menu = array(
    //$jobinfocusmenu,
    $refreshXeroMenu,
        //$createinvoicemenu,
        //array('label' => 'Xero Update', 'url' => array('invoice/xeroUpdate')),
);
?>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<h1>Xero Purchase Order Queue </h1>

<section>
    <div id="xero-message" style="color: #F19031;">Xero Response messages</div>
</section>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'po-queue-grid',
    'dataProvider' => $model->searchXeroQueue(),
    'filter' => $model,
    'columns' => array(
        array(
            'name' => 'xero_to_be_sent',
            'value' => 'CHtml::checkBox($data->id,$data->xero_to_be_sent,array("class" => "toXeroCheckbox"))',
            'type' => 'raw',
            'htmlOptions' => array('class' => 'toXeroCheckbox'),
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        array(
            'name' =>  'poNum',
            'value' => '$data->getPONumberHtml()',
            'type' => 'raw',
        ),
       
        array(
            'name' => 'job_search',
            'value' => 'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'supplier_search',
            'value' => 'Supplier::model()->findByPk($data->supplier_id)->supnam',
            
        ),
        
        array(
            'name' => 'customer_search',
            'value' => '$data->job->customer->cusnam'
        ),
        array(
            'name' => 'followupDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))'
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))'
        ),
        'poType',
        array(
            'name'=>'status_id',
            'value'=>'Status::model()->findByPk($data->status_id)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,3,7,9, 41, 39)")), 'id', 'name'),
            
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}{sep2}{revoke}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'print' => array
                    (
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("purchaseOrders/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'revoke' => array
                    (
                    'label' => 'Revoke',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("purchaseOrders/toggleXeroQueue", array("id"=>$data->id))',
                    'click' => 'js: function(){toggleQueue($(this).attr("href"));return false;}'
                ),
            )
        ),
    ),
));
?>
<script type="text/javascript">

    $('.toXeroCheckbox').on('change', function () {
        if($(this).prop('checked')) {
            if($(this).attr('id')) {
                 toggleXeroSync({id:$(this).attr('id'), xeroSync:1});
            }
        } else {
             if($(this).attr('id')) {
                 toggleXeroSync({id:$(this).attr('id'), xeroSync:0});
             }
        }
        
    });

    function toggleXeroSync(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("purchaseOrders/toggleXeroSync"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {
                
            },
            error: function (result) {
                console.log(result);
            },

        });
    }

    /**
    * revoke from the Xero queue
    * */
    function toggleQueue(url) {
        $.ajax({
            type: 'POST',
            url: url,
            data: {},
            dataType: 'json',
            success: function (result) {
                if (result.success) {
                    $.fn.yiiGridView.update("po-queue-grid");
                }
            },
            error: function (result) {

            },

        });
    }

    function xeroSynchronizeAll(e)
    {
        $('#xero-message').html('');
        const $this = $(e);        
        $this.button('loading');

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("purchaseOrders/xeroQueuePush"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) { 
                
                if (result?.messages) {
                    //array of message
                    const markupArr = result.messages.map( msg => `<p>${msg}</p>` );
                    let markupHtml = '';
                    markupArr.forEach(element => markupHtml += element);                  
                    $('#xero-message').html(markupHtml);
                    
                    
                }
                
                if (!result.success && result?.type === 'auth') {
                    $this.button('auth');
                    return;
                }
               
                if (!result.success) {
                    $this.button('error');
                    return;
                }
                
                if (result.success) {
                    $this.button('done');
                    $('#po-queue-grid').yiiGridView('update');
                    return;
                }                    
            },
            error: function (result) {                
                $this.button('error');
            },

        });
    }
    
</script>



