<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script>
    /*
     * popup line options functionality
     * peform on _quote_detail_row_html.php also
     **/

    $(document).on('click', '.lineOptionRow', function () {

        showLineFlagSettings($(this).attr('lineOptionRowId'));
    });

    function showLineFlagSettings(id) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/fetchDetailFlags"); ?>',
            data: {id: id},
            dataType: 'json',
            success: function (result) {


                var options = {};
                options.selected = result.flags;

                options.inputOptions = [
                    {
                        text: 'Hide on PDF',
                        value: 'hide_on_pdf',
                    },
                ];

                bootbox.prompt({
                    title: "Line Options",
                    value: options.selected,
                    inputType: 'checkbox',
                    inputOptions: options.inputOptions,
                    callback: function (result) {
                        if (result) {
                            var obj = {};
                            obj.id = id;
                            obj.flags = result;

                            //if no flag has been selected  then 'flags' array will be empty, so we need to add the flag attributes manually to the object to turn them off
                            if (!obj.flags.length) {
                                obj.offFlags = ['hide_on_pdf'];
                            }
                            updateLineOptionFlags(obj);
                        }
                    }
                });


            },
            error: function (result) {
                console.log(result);
            }
        });



    }

    function updateLineOptionFlags(obj) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/updateDetailFlags"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {

                if (result.success) {
                    refreshLineOptionsFlagsLabels(obj);
                }
            },
            error: function (result) {
                console.log(result);
            }
        });
    }


    function refreshLineOptionsFlagsLabels(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/onFlagsLabelsHtml"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {

                $('#flagLabelTextDiv_' + obj.id).empty();
                $('#flagLabelTextDiv_' + obj.id).html(result.html);

            },
            error: function (result) {
                console.log(result);
            }
        });
    }



    /**
     * 
     * */
    /**
     *Currently opened calscreen row id
     */
    var after_row_id = null;


    /**
     * quote detail image change
     * trigger to open file window
     */
    $(document).on('click', '.quote-dtl-img', function () {
        $(this).closest('td').find('.ImageBrowse').trigger('click');
    });

    /**
     * If an image file selected then find closest form and submit
     * */
    $(document).on('change', '.ImageBrowse', function (e) {
        //store img element because of $(this) would be replaced by another object after submit the form
        var imgElement = $(this).closest('td').find('img');
        if ($(this).val()) {


            e.preventDefault();



            var formData = new FormData($(this).closest('form')[0]);
            //formData.append( 'id', $( this ).closest('form').find('input[name="QuatationDetails[id]"]').val() );
            //formData.append( 'productimg', $( this )[0].files[0] );

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("quatationDetails/updateImage"); ?>',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (result) {
                    var json = $.parseJSON(result);

                    if (json.status == true) {
                        imgElement.attr('src', json.image_file);
                    }
                },
                error: function (result) {

                }
            });
        }
    });

    /*
     * clone current line from cal screen by entering new qty
     */
    $(document).on('click', '#af_edit_clone_line', function () {
        bootbox.prompt({
            title: "Add Another Quantity!",
            centerVertical: true,
            callback: function (result) {
                if (result && !isNaN(result)) {
                    var obj = {};
                    obj.quantity = result;
                    obj.quoteDetailId = after_row_id;
                    cloneLineFromCalScreenQty(obj);
                }

            }
        });
    });

    function cloneLineFromCalScreenQty(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/cloneLineByQuantity"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {
                after_row_id = result.newLineId;
                var obj = {};
                obj.id = result.newLineId;
                loadEditPriceCalScreen(obj);
                addmainrow(result.newLineHTML);
            },
            error: function (result) {
                console.log(result);
            }
        });
    }


    /*
     *Markup/margin overidde fucntionality 
     * 
     */
    $(document).on('click', '#af_edit_override_markup_margin, #addnew_override_markup_margin', function () {
        overrideMarkupMargins();
        if ($(this).attr('id') === 'af_edit_override_markup_margin') {
            //fire cal screen calculating
            doPricePlayingCal();
        } else if ($(this).attr('id') === 'addnew_override_markup_margin') {
            //fire cal screen calculating event in _model_popup.php
            doAddNewPricePlayingCal();
        }
    });

    var focusObj;
    $(document).on('focus', '[mark-up="rate"],[mark-up="percentage"]', function () {
        focusObj = $(this);

    });

    function overrideMarkupMargins() {
        if (focusObj) {


            var type = $(focusObj).attr('mark-up');
            var val = parseFloat($(focusObj).val());
            var result = 0;

            if (type === 'rate') {

                result = val;


            } else if (type === 'percentage') {
                result = getMarkupMultiplierOutOfMargin(val);


            }





            var objVal = result;
            var supplierMarkUpRate = parseFloat($('#SupplierMarkUp').val());
            var pass = true;

            if (objVal < supplierMarkUpRate) {
                pass = confirm("You are changing the Markup / Margin below the system global rate, Continue??");

            }


            if (pass && objVal == 0) {
                pass = confirm("Are you realy want to override all rates and percentages with Zero?");

            }






            if (pass) {

                if (focusObj.attr('mark-up') === 'rate') {
                    var percentageObj = $(focusObj).closest('td').find('[mark-up="percentage"]');
                    $.each($('[mark-up="rate"]'), function () {
                        if (focusObj.attr('name') !== $(this).attr('name')) {
                            //don't override freight
                            if (jQuery.inArray($(this).attr('name'), ['adnew_freight_percentage', 'adnew_freight_rate', 'af_freight_rate', 'af_freight_percentage']) === -1) {
                                $(this).val(focusObj.val());
                            }


                        }

                    });
                    $.each($('[mark-up="percentage"]'), function () {
                        if (percentageObj.attr('name') !== $(this).attr('name')) {
                            //don't override freight
                            if (jQuery.inArray($(this).attr('name'), ['adnew_freight_percentage', 'adnew_freight_rate', 'af_freight_rate', 'af_freight_percentage']) === -1) {
                                $(this).val(percentageObj.val());
                            }

                        }
                    });
                } else if (focusObj.attr('mark-up') === 'percentage') {
                    var rateObj = $(focusObj).closest('td').find('[mark-up="rate"]');
                    $.each($('[mark-up="percentage"]'), function () {
                        if (focusObj.attr('name') !== $(this).attr('name')) {
                            //don't override freight
                            if (jQuery.inArray($(this).attr('name'), ['adnew_freight_percentage', 'adnew_freight_rate', 'af_freight_rate', 'af_freight_percentage']) === -1) {
                                $(this).val(focusObj.val());
                            }

                        }

                    });
                    $.each($('[mark-up="rate"]'), function () {
                        if (rateObj.attr('name') !== $(this).attr('name')) {
                            //don't override freight
                            if (jQuery.inArray($(this).attr('name'), ['adnew_freight_percentage', 'adnew_freight_rate', 'af_freight_rate', 'af_freight_percentage']) === -1) {
                                $(this).val(rateObj.val());
                            }

                        }
                    });
                }

            }



        }


    }



    /*
     * Get markup multiplier (rate) out of margin percentage
     * example: if you pass "36" it will return "1.56" as markup multiplier (rate)
     * @returns {float} 
     */
    function getMarkupMultiplierOutOfMargin(margin) {

        if (!margin || margin === '0') {
            return 0;
        }

        var margin_value = parseInt(margin);
        var retail_lavel = 100;
        var buffer_value = retail_lavel - margin_value;
        var markup_percentage = ((retail_lavel / buffer_value) - 1);
        var markup_value = ((100 + markup_percentage * 100) / 100).toFixed(2);


        if (isNaN(markup_value)) {
            return 0;
        }

        if (!isFinite(markup_value)) {
            return 0;
        }

        return markup_value;

    }

    /*
     * Get margin percentage out of markup multiplier (rate)
     * example: if you pass "1.56" it will return "36" as margin percentage
     * @returns {integer} 
     */
    function getMarginOutOfMarkupMultiplier(rate) {

        if (!rate || rate === '0') {
            return 0;
        }

        var markup_decimal_value = rate;
        var hold_value = markup_decimal_value * 100;
        var hold_value2 = hold_value - 100;
        var new_margin_percentate = (hold_value2 / markup_decimal_value).toFixed();

        if (isNaN(rate)) {
            return 0;
        }

        if (!isFinite(rate)) {
            return 0;
        }

        return new_margin_percentate;

    }

    /*
     * calculate margin from rate and vise versa
     */
    $(document).on('keyup', '#edit_price_cal_row :input', function () {
        marginMarkupLookup($(this));

    });

    function marginMarkupLookup(obj) {

        if ($(obj).attr('mark-up')) {
            var type = $(obj).attr('mark-up');
            var val = parseFloat($(obj).val());
            var result = 0;

            if (type === 'rate') {

                result = getMarginOutOfMarkupMultiplier(val);

                $(obj).closest('td').find('[mark-up="percentage"]').val(result);
            } else if (type === 'percentage') {
                result = getMarkupMultiplierOutOfMargin(val);
                $(obj).closest('td').find('[mark-up="rate"]').val(result);

            }

        }
    }





    $(document).on('change', '#edit_price_cal_row :input', function () {
        var escapeAttr = ['af_edit_subtotal_with_setup', 'aFLockSellPrice'];
        var attrId = $(this).attr('id');

        if (attrId === 'af_edit_itm_qty') {

            saveEditOtherCostCalOnServer();

        } else if ($.inArray(attrId, escapeAttr) === -1) {
            //without lock sell price related inputs
            doPricePlayingCal();

        } else if ($.inArray(attrId, escapeAttr) !== -1) {
            //only for lock sell price inputs
            if (attrId === 'af_edit_subtotal_with_setup') {
                showZeroSellPriceAlert('#af_edit_subtotal_with_setup');
            }
            doMarginPlayingCalForProductCost();

        }

    });

    $(document).on('change', '#af_edit_subtotal_with_setup', function () {
        //doMarginPlayingCalForProductCost();
    });


    function showZeroSellPriceAlert(selector) {
        const sellPrice = +$(selector).val();
        if (sellPrice === 0) {
            bootbox.alert("If you need to set sell price zero, please set all the markup rates including decoration and other costs to zero!");
        }
    }



    function showEditPriceModal(id) {

        after_row_id = id;

        var obj = {};
        obj.id = id;
        loadEditPriceCalScreen(obj);
        showcentermodel('editPriceInDetailsModel');
        //$('#editPriceInDetailsModel').modal('show');


    }

    function loadEditPriceCalScreen(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/fetchDetailsPrices"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {
                $('#af_edit_cost_price').val(result.prodCostPrice);
                $('#af_edit_prd_markup').val(result.prodMarkupRate);
                $('#af_edit_prd_markup_percentage').val(result.prodMarkupPercentage);
                $('#af_prd_markedup_discounted_price').val(result.prodDiscountedPrice);

                $('#af_usd_freight').val(result.usdFreight);
                /*
                 * new USD frieght values for product
                 * sent from front end web service
                 * 2018-10-10
                 * 
                 * */

                $('#af_usd_freight_unit_cost').val(result.usdFreightUnit);
                $('#af_usd_freight_markup_rate').val(result.usdFreightMarkupRate);
                $('#af_usd_freight_markup_percentage').val(result.usdFreightMarkupPercentage);
                $('#af_usd_freight_unit_markedup_price').val(result.usdFreightUnitWithMarkedUp);


                $('#af_prd__price_with_usd_freight').val(result.prodUsdFreigtedPrice);
                $('#af_discount_percntg').val(result.prodDiscPercntg);
                $('#af_edit_deco_price').val(result.decoCostPrice);
                $('#af_edit_deco_markup').val(result.decoMarkupRate);
                $('#af_edit_deco_markedup_price').val(result.decoMarkedUpPrice);
                $('#af_edit_othercost_total').val(result.otherCostTotal);
                $('#af_edit_othercost_markup_rate').val(result.otherCostMarkUpRate);
                $('#af_edit_othercost_markup_percentage').val(result.otherCostMarkUpPercentage);
                $('#af_edit_othercost_markedup_price').val(result.otherCostMarkedUpPrice);
                $('#af_edit_subtotal').val(result.subTotal);
                $('#af_edit_itm_qty').val(result.itmQty);


                $('#af_logo_setup_charge').val(result.logoSetupCharge);
                /*
                 * new logo setup mark up values for product
                 * sent from front end web service
                 * 2018-10-10
                 * 
                 * */
                $('#af_unit_setup_charge').val(result.logoSetupUnitCost);
                $('#af_unit_setup_charge_markup_rate').val(result.logoSetupMarkupRate);
                $('#af_unit_setup_charge_markedup_price').val(result.logoSetupUnitCostWithMarkup);

                $('#af_edit_subtotal_with_setup').val(result.subTotalWithSetup);
                $('#af_freight_rate').val(result.freightRate);
                $('#af_freight_percentage').val(result.freightPercentage);
                $('#af_edit_total').val(result.total);
                $('#af_total_cost').val(result.totalCostPrice);
                $('#af_edit_tax_rate_id').val(result.systemTaxRateId);

                /**
                 * Set lock sell price
                 * */

                if (parseInt(result.aFLockSellPrice)) {
                    $('#aFLockSellPrice').prop('checked', true);
                } else {
                    $('#aFLockSellPrice').prop('checked', false);
                }


                $('#edit-other-cost-form').html(result.otherCostHtml);

                $('#multi-deco-edit-sec').html(result.multiDecoCalScreenHtml);

                $('#af_edit_gp_percentage').val(result.grossProfitPercentage);
                $('#af_edit_gp_in_doller').val(result.grossProfit);
                $('#af_edit_total_gross_profit').val(result.totalGrossProfit);
                $('#af_edit_total_line_value').val(result.lineTotal);


                if (result.hasDeco == true) {
                    $('#af_edit_deco_price').removeAttr("readonly");
                    $('#af_edit_deco_markup').removeAttr("readonly");
                    $('#af_logo_setup_charge').removeAttr("readonly");

                } else {
                    $('#af_edit_deco_price').prop('readonly', true);
                    $('#af_edit_deco_markup').prop('readonly', true);
                    $('#af_logo_setup_charge').prop('readonly', true);
                }
            },
            error: function (result) {
                console.log('Error in get detail prices');
            }
        });
    }


    function doMarginPlayingCalForProductCost() {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/doMarginPlayingCalForProductCost"); ?>',
            data: $("#edit_price_cal_row").serialize() + '&quoteDtlId=' + after_row_id,
            dataType: 'json',
            success: function (result) {

                //$('#af_prd__price_with_usd_freight').val(result.product_total);
                //$('#af_prd_markedup_discounted_price').val(result.discounted_price);
                $('#af_edit_prd_markup').val(result.product_cost_markup_rate);
                $('#af_edit_prd_markup_percentage').val(result.productCostMarkupPercentage);
                $('#af_prd_markedup_discounted_price').val(result.product_cost_markedup_with_discount);
                $('#af_prd__price_with_usd_freight').val(result.product_section_total);

                $('#af_edit_subtotal').val(result.subTotal);
                $('#af_edit_subtotal_with_setup').val(result.sub_total_with_setup_unit);
                $('#af_edit_total').val(result.grand_total);

                if (result.multiDecoLines) {

                    $.each(result.multiDecoLines, function (key, data) {
                        $.each(data, function (index, val) {
                            $('input[name="' + index + '"]').val(val);

                        });
                    });

                }

                $('#af_edit_decoration_total').val(result.decorationTotal);
                $('#af_edit_gp_percentage').val(result.grossProfitPercentage);
                $('#af_edit_gp_in_doller').val(result.grossProfit);
                $('#af_gross_profit_total').val(result.totalGrossProfit);

                //$('#sellunitpriceExVat_' + after_row_id).val(result.grand_total);

                //$('#selltotExVat_' + after_row_id).val(result.lineTotal);

            },
            error: function (result) {
                console.log('Error in doMarginPlayingCalForProductCost');
            }
        });
    }

    //change product
    $(document).on('click', '.edit-product', function () {
        after_row_id = $(this).attr('data-id');
        //show bootbox to select type of product entering
        bootbox.prompt({
            title: "Select product mode",
            message: '<p>Please select an option below:</p>',
            inputType: 'radio',
            inputOptions: [
                {
                    text: 'Create new product',
                    value: '1',
                },
                {
                    text: 'Select from local products',
                    value: '2',
                },
                {
                    text: 'Select from GWS API',
                    value: '3',
                }
            ],
            callback: function (result) {
                console.log(result);
            }
        });
        //if new product then show new product entering model
        //--- show new product entering mode
        //if product from DB then show DB product model
        //---showcentermodel('updateprdmodel');
        //if product from GWS show GWS product model
        //-- show GWS product selecting mode
        return false;
    });


    function showEditMultiDecoModal(id) {
        after_row_id = id;
        //set qty on edit decoration modal
        $('#edit-deco-qty').val($(`#qty_${after_row_id}`).val());
        
        showcentermodel('edit-line-multi-deco');

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/editMultiDeco"); ?>',
            data: {'quoteDetailID': id},
            dataType: 'json',
            success: function (result) {
                $('#edit-multi-deco-form').empty();
                $('#edit-multi-deco-form').html(result.html);
            },
            error: function (result) {
                console.log('Error in edit multi deco');
            }
        });
    }

    function deleteMultiDecoItem(id) {
        $('#editmultidecotr_' + id).remove();
    }

    function deleteTemporyDeco(id) {
        $('#temperydeco_' + id).remove();
    }

    function saveEditMultiDeco() {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/saveEditMultiDeco"); ?>',
            data: $("#edit-multi-deco-form").serialize(),
            dataType: 'json',
            success: function (result) {
                $('#multideco_' + after_row_id).empty();
                $('#multideco_' + after_row_id).html(result.html);
                calLinePrices(after_row_id);
            },
            error: function (result) {
                console.log('Error in edit multi deco');
            }
        });
    }


    function showMultiDecoSelectModel() {
        $("#edit-select-decoration-grid .select-on-check").prop('checked', false);
        showcentermodel('edit-line-select-deco-model');
    }

    function showEditCalDecorationPopup() {
        $("#edit-select-decoration-grid .select-on-check").prop('checked', false);
        showcentermodel('select-cal-deco-model');
    }


    function editLineSelectDecoFromGrid() {

        var values = new Array();
        $.each($("input[name='edit-select-decoration-grid_c0[]']:checked"), function () {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (values.length > 0) {
            addDecoLinesToEditMultiDeco(values);
        }


    }


    function addDecoLinesToEditMultiDeco(decoIds) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/getMultiDecoLineHtml"); ?>',
            data: {'decoIds': decoIds},
            dataType: 'json',
            success: function (result) {
                jQuery("#edit-multi-deco-form table:first > tbody:first").append(result.html);
            },
            error: function (result) {
                console.log('Error in get multi deco lines');
            }
        });
    }


    function doPricePlayingCal() {
        var sellPrice = $('#af_edit_subtotal_with_setup').val();
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/doPricePlayingCal"); ?>',
            data: $("#edit_price_cal_row").serialize() + '&quoteDtlId=' + after_row_id,
            dataType: 'json',
            success: function (result) {


                $('#af_prd_markedup_discounted_price').val(result.prodDiscountedPrice);
                $('#af_prd__price_with_usd_freight').val(result.prodUsdFreightedPrice);
                $('#af_edit_deco_markedup_price').val(result.decoMarkedUpPrice);
                $('#af_edit_othercost_markedup_price').val(result.otherCostMarkedUpPrice);
                $('#af_unit_setup_charge').val(result.unitSetupCharge);
                $('#af_edit_subtotal').val(result.subTotal);
                $('#af_edit_subtotal_with_setup').val(result.subTotalWithSetup);
                $('#af_edit_total').val(result.total);
                $('#af_total_cost').val(result.totalCost);
                // $('#af_edit_sell_price_ex_gst').val(result.extotal);

                //new freight markup values 2018-10-10
                $('#af_usd_freight_unit_cost').val(result.usdFreightUnitCost);
                $('#af_usd_freight_unit_markedup_price').val(result.usdFreightUnitCostWithMarkedUp);

                //new logo setup mark-up values 2018-10-10
                $('#af_unit_setup_charge_markedup_price').val(result.unitSetupChargeWithMarkedUpPrice);


                $('#cal_message').empty();
                $('#cal_message').html(result.error_message);

                if (result.multiDecoLines) {

                    $.each(result.multiDecoLines, function (key, data) {
                        $.each(data, function (index, val) {
                            $('input[name="' + index + '"]').val(val);

                        });
                    });

                }


                $('#af_edit_decoration_total').val(result.decorationTotal);
                $('#af_edit_gp_percentage').val(result.grossProfitPercentage);
                $('#af_edit_gp_in_doller').val(result.grossProfit);
                $('#af_edit_total_gross_profit').val(result.totalGrossProfit);
                $('#af_edit_total_line_value').val(result.lineTotal);


                if ($('#aFLockSellPrice').is(':checked')) {

                    $('#af_edit_subtotal_with_setup').val(sellPrice);
                    doMarginPlayingCalForProductCost();
                }



                //$('input[name="QuoteProductDecoration[14][decorationunitval]"]').val('1.25f');
            },
            error: function (result) {
                console.log('Error in doPricePlayingCal');
            }
        });
    }

    function updateDetailsPricesByTotExGST() {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/updateDetailsPricesByTotExGST"); ?>',
            data: $("#edit_price_cal_row").serialize() + '&' + $('#edit-other-cost-form').serialize() + '&quoteDtlId=' + after_row_id,
            dataType: 'json',
            success: function (result) {
                $('#sellunitpriceExVat_' + after_row_id).val(result.sellPriceExVat);
                //$('#sellunitpriceInVat_' + after_row_id).val(result.sellPriceIncVat);
                $('#selltotExVat_' + after_row_id).val(result.totExVat);
                $('#qty_' + after_row_id).val(result.quantity);
                calTotal(after_row_id);
            },
            error: function (result) {
                console.log('Error when update detail prices. Trying to create an error log detail.');
            }
        });
    }

    function calLinePrices(id) {

        bootbox.prompt({
            title: "You are quanity changing may effect to the cost price!",
            message: '<p>Please select an option below:</p>',
            inputType: 'radio',
            inputOptions: [
                {
                    text: 'Use the cost price entered',
                    value: '1',
                },
                {
                    text: 'Look up the current cost price',
                    value: '2',
                },
            ],
            callback: function (qtyOptionResult) {

                var qty = $('#qty_' + id).val();


                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl("quatationDetails/calLinePirces"); ?>',
                    data: {'id': id, 'qty': qty, 'qtyPriceOption': qtyOptionResult},
                    dataType: 'json',
                    success: function (result) {

                        $('#sellunitpriceExVat_' + id).val(result.sellPriceExGST);
                        //$('#sellunitpriceInVat_' + id).val(result.sellPriceIncVat);
                        $('#selltotExVat_' + id).val(result.totExVat);
                        //$('#selltotInVat_' + id).val(result.totIncVat);

                        showDtlSaveSucces(id);
                        calTotal(id);

                    },
                    error: function (result) {
                        console.log('Error in calculate sell price excluding GST!');
                    }
                });



            }
        });




    }

    function calTotal(id) {
        var type;
        if (id == null) {
            type = 'MDL';
            id = $('$modelId').val();
        } else {
            type = 'DTL';
        }

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatationDetails/calculateFullTotal"); ?>',
            data: {'id': id, 'type': type},
            dataType: 'json',
            success: function (result) {
                $('#subTotalVal').text(result.subTotal);
                $('#gstTotalVal').text(result.gstTotal);
                $('#fullTotalVal').text(result.total);
            },
            error: function (result) {
                console.log('Error in calculate total amounts');
            }
        });
    }

    function updateDetailField(id, attr, val) {
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("quatationDetails/updateField"); ?>',
            data: {'id': id, 'attr': attr, 'val': val},
            dataType: 'json',
            success: function (data) {
                showDtlSaveSucces(id);


            },
            error: function (data) {
                console.log('Error in "QuatationDetails:updateField"');
            },
        });
    }

    function showDtlSaveSucces(rowid) {

        $('#savemessage_' + rowid).fadeIn(500).fadeOut(1500);
    }

    function updateQuoteHeaderField(quoteid, fieldname, value) {

        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("quatation/updateQuoteField"); ?>',
            data: {'id': quoteid, 'field': fieldname, 'value': value},
            dataType: 'json',
            success: function (data) {
                if (data.success == true)
                    changessaved();


            },
            error: function (data) {
                console.log('error return from updateQuoteField function');
            },
        });
    }

    function printPDF(id) {

        var win = window.open('index.php?r=quatation/print&id=' + id);
    }

    function sendEmail(id, emailtype) {

        var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
    }


    var GST = 0;
    $(document).ready(function () {

        $("#add_quote_product_description,#add_quote_product_long_desc,#add_quote_decoration_description").dblclick(function () {
            var attrname = '';
            if ($(this).attr('id') === 'add_quote_product_description') {
                attrname = 'QuatationDetails[productname]';
            }

            if ($(this).attr('id') === 'add_quote_product_long_desc') {
                attrname = 'QuatationDetails[productdescription]';
            }

            if ($(this).attr('id') === 'add_quote_decoration_description') {
                attrname = 'QuoteProductDecoration[decorationdescription]';
            }



            var txtdetails = $(this).text();
            var textarea = $('<textarea   name="' + attrname + '" style="width: 95%;" rows="4" cols="50" />');
            textarea.text(txtdetails);
            $(this).empty();
            $(this).append(textarea);
        });

        if (GST == 0) {

            var url = '<?php echo Yii::app()->createUrl("globalVars/getVar"); ?>';
            $.ajax({
                type: 'POST',
                url: url,
                data: {'type': 'GST'},
                dataType: 'json',
                success: function (result) {
                    GST = result.GST;

                },
                error: function (result) {
                    console.log('error in get vat');
                }
            });

        }

    });






    function get3decimalpoint(value) {

        var str = value.toString();
        var arr = str.split('.');
        var decimalstr = '';
        var decimalarr = null;
        var with2decimalplace = '';
        if (arr.length == 2) {
            decimalstr = arr[1];
            decimalarr = decimalstr.split('');
            with2decimalplace = arr[0] + '.';
            $.each(decimalarr, function (index, value) {
                if (index < 3) {
                    with2decimalplace = with2decimalplace + '' + value;
                }

            });
        } else {
            with2decimalplace = arr[0] + '.00';
        }
        return with2decimalplace;
    }

    function setDetailsTotalFields(quoteID) {
        var url = '<?php echo Yii::app()->createUrl("quatation/fetchTotalValues"); ?>';
        $.ajax({
            type: 'POST',
            url: url,
            data: {'id': quoteID},
            dataType: 'json',
            success: function (result) {
                $('#subTotalVal').text(result.subTotal);
                $('#gstTotalVal').text(result.gstTotal);
                $('#fullTotalVal').text(result.total);
            },
            error: function (result) {
                console.log('error in fetch total fields');
            }
        });
    }

    function addmainrow(html) {

        var numberOfRows = $('.maincell').length;
        numberOfRows++;
        //$('#showhtml').text(html);

        var lastrowclass = $('#maintblbody > tr:last').attr('class');

        $('#maintblbody').append(html);

        // $('#maintblbody > tr:last .counter-no').html(numberOfRows);

        if (lastrowclass === 'foo') {
            $('#maintblbody > tr:last').attr('class', 'bar');
        } else {
            $('#maintblbody > tr:last').attr('class', 'foo');
        }



        //resetDetailsCount();

    }

    function clearadddetails() {

        $('#show_quote_product_img').attr('src', '');
        $('#adnew_prd_code').val('');
        $('#add_quote_productsku').val('');
        $('#add_quote_product_description').empty();
        $('#add_quote_product_long_desc').empty();
        $('#add_quote_decprtnam').val('');
        $('#add_quote_decoration_description').empty();
        $('#add_quote_prdqty').val('1');
        $('#add_quote_sellprice_ex_vat').val('0.0');
        $('#add_quote_supmargin').val('0');
        $('#add_quote_sellprice_inc_vat').val('0.0');
        $('#add_quote_totsell_ex_vat').val('0.0');
        $('#add_quote_totsell_inc_vat').val('0.0');
        $('#adnew_edit_itm_qty').val('1');



        $('#edit_cost_price').val('0.0');
        $('#edit_deco_price').val('0.0');
        $('#edit_sup_margin').val('1');
        $('#edit_sell_price_ex_gst').val('0.0');

        $('#add_multi_decoration_description').empty();
        $('#add_multi_decoration_form_container').empty();
        $('#adnew-multi-deco-edit-sec').empty();

        $('#stored-other-cost-ids').val("");
        $('#add-other-cost-new-dtl-tbl-body').empty();
        $('#other-cost-form').empty();
        $('#saved-other-cost-ids').val("");



    }


    function postquoteheader() {
        var fd = new FormData($("#quatation-header-form")[0]);

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("quatation/postquoteHeader"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function () {
                // do some loading options
            },
            success: function (result) {
                if (result == 'success')
                    changessaved();

            },
            complete: function () {

            },
            error: function (data) {
                console.log("There may be an error when uploading. Try again later");
            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }

    function changessaved() {
        $('#quote-header-msg').fadeIn(500).fadeOut(1500);
    }


    function setunitprice(qty) {

        if (qty != '' || qty != ' ') {
            var product_code = $("#QuatationDetails_productsku").val();
            if (product_code == '')
                product_code = $("#QuatationDetails_product_shortname_search").val();
            var deco_code = $("#QuoteProductDecoration_decprtnam").val();
            setProductPriceInRange(product_code, qty);
            setDecoPriceInRange(deco_code, qty);
        }
    }

    function setProductPriceInRange(pro_code, qty) {
        $("#QuatationDetails_productexunitprice").val('');
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("productPrice/priceInQtyRange"); ?>',
            data: {'productsku': pro_code, 'qty': qty},
            dataType: 'json',
            success: function (data) {

                if (data.prdprice > 0)
                    $("#QuatationDetails_productexunitprice").val(data.prdprice);

            },
            error: function (data) {

            },
        });
    }

    function setDecoPriceInRange(deco_code, qty) {
        $("#QuoteProductDecoration_decorationunitval").val('');
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("decorationPrice/priceInQtyRange"); ?>',
            data: {'decprtnam': deco_code, 'qty': qty},
            dataType: 'json',
            success: function (data) {

                if (data.decoprice > 0)
                    $("#QuoteProductDecoration_decorationunitval").val(data.decoprice);

            },
            error: function (data) {

            },
        });
    }

    var quote_dtl_visibility = false;
    function quotedetailshow() {
        if (quote_dtl_visibility == false) {
            $('#work-add-btn').val('Hide');
            $('#new-quote-detail-panel').show(1000);
            quote_dtl_visibility = true;
        } else {
            $('#work-add-btn').val('Show');
            $('#new-quote-detail-panel').hide(1000);
            quote_dtl_visibility = false;
        }
    }

    var prd_visibility = false;
    function addnewprdshow() {
        if (prd_visibility == false) {
            $('#add-prd-btn').val('Hide');
            $('#add-new-product-panel').show(1000);
            prd_visibility = true;
        } else {
            $('#add-prd-btn').val('Show');
            $('#add-new-product-panel').hide(1000);
            prd_visibility = false;
        }
    }



    function hide(id) {
        if ($('#' + id).is(":visible")) {
            $('#' + id).slideUp(500);
            $('#' + id + '-fold').attr("src", 'images/more_details.png');

            if (id == 'job-header-div') {
                $('#job_header_breif').show();
            }
        } else {
            $('#' + id).slideDown(500);
            $('#' + id + '-fold').attr("src", 'images/less_details.png');

            if (id == 'job-header-div') {
                $('#job_header_breif').hide();
            }
        }
    }


    function saveworkdetails(wrkodrID) {
        if ($('#add_quote_productsku').val() != '') {
            postquotedetail();
        }
        $('#wrkorder-chnges-msg').fadeIn(1500).fadeOut(1500);

    }

    function showcentermodel(id) {
        $("#" + id).modal('show').css(
                {
                    'margin-top': function () {
                        return -($(this).height() / 2);
                    },
                    'margin-left': function () {
                        return -($(this).width() / 2);
                    },
                })
    }

    function submitHeader() {
        $('#quote-editfinish-submit-btn').trigger('click');
    }

    function editcontent(id, attrname) {
        var txtdetails = $('#' + id).text();
        var textarea = $('<textarea   name="' + attrname + '" style="width: 95%;" rows="4" cols="50" />');
        textarea.text(txtdetails);
        $('#' + id).empty();
        $('#' + id).append(textarea);
    }

    var selectedDetailIds = [];

    $(document).on('change', '.quote-line-select', function () {
        var detailId = $(this).attr('detail-id');

        if ($(this).is(':checked')) {

            selectedDetailIds.push(detailId);
        } else {
            selectedDetailIds = jQuery.grep(selectedDetailIds, function (value) {
                return value != detailId;
            });
        }
        if (selectedDetailIds.length > 0) {
            toggleDetailOptionButtons(false);
        } else {
            toggleDetailOptionButtons(true);
        }

    });

    function toggleDetailOptionButtons(doDisable) {
        jQuery("#quote-del-all-btn").prop('disabled', doDisable);
        jQuery("#quote-copy-line-btn").prop('disabled', doDisable);
    }



    function deleteSelectedDtls() {
        deleteMultipleRecords(selectedDetailIds);

    }

    function copySelectedLines() {

        callCopyLines(selectedDetailIds);
    }

    function callCopyLines(selectedDetailIds) {
        $('#quote_rows_del_loding_icon').show();
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("quatation/copyLine"); ?>',
            type: 'POST',
            data: {'quoteId': $('#Quatation_id').val(), quoteDetalIdStr: selectedDetailIds + ''},
            datatype: 'json',

            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $.each(obj, function (index, rowhtml) {
                    addmainrow(rowhtml);
                });

                setDetailsTotalFields($('#Quatation_id').val());
                //enableDetailOptionButtons(false);
                $('#quote_rows_del_loding_icon').hide();


            },
            error: function (data) {
                $('#quote_rows_del_loding_icon').hide();
            }
        });
    }

    function deleteMultipleRecords(arr) {
        var s = confirm("Are you sure you want to delete these records?");

        if (s === true) {
            $('#quote_rows_del_loding_icon').show();
            var jsonString = JSON.stringify(arr);
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("quatationDetails/deleteMultipleRecords"); ?>',
                data: {'quoteDtlArr': jsonString},
                cache: false,
                success: function (result) {

                    $.each(arr, function (index, value) {
                        $('#quote_row_' + value).remove();
                    });

                    //resetDetailsCount();

                    setDetailsTotalFields($('#add_quote_quoteid').val());

                    toggleDetailOptionButtons(true);

                    $('#quote_rows_del_loding_icon').hide();

                },
                error: function (result) {
                    $('#quote_rows_del_loding_icon').hide();
                    console.log('error in delete');
                }
            });
        }

    }

    function resetDetailsCount() {
        var count = 0;
        $('.maintbl tr > td:first-child .counter-no').each(function () {
            count++;
            $(this).empty();
            $(this).html(count);

        });


        $('#maintblbody > tr').each(function () {
            count++;

            if ((count % 2) == 1)
                $(this).attr('class', 'bar');
            else
                $(this).attr('class', 'foo');
        });
    }
</script>
<input id="SupplierMarkUp" type="hidden" value="<?php echo GlobalVars::get('SupplierMarkUp'); ?>" />
<?php
include '_model_popup.php';
//if(isset( Yii::app()->session['try_new_quote']) && Yii::app()->session['try_new_quote'] > 1) echo  'try for new quote : ' . Yii::app()->session['try_new_quote'];
?>
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#header-sec" role="tab" data-toggle="tab" onclick="setTab('header-sec');">Header Details</a></li>    

    <li><a href="#crm-sec" role="tab" data-toggle="tab" onclick="setTab('crm-sec');">CRM</a></li>

    <li><a href="#quote-dtl-sec" role="tab" data-toggle="tab" onclick="setTab('quote-dtl-sec');">Quotation Details</a></li>

    <li><a href="#file-attachment-sec" role="tab" data-toggle="tab" onclick="setTab('file-attachment-sec');">File Attachments</a></li>

    <li><a href="#sign-off-sec" role="tab" data-toggle="tab" onclick="setTab('sign-off-sec');">Sign Off Terms</a></li>

    <li><a href="#all-in-one-sec" role="tab" data-toggle="tab" onclick="setTab('all-in-one-sec');">All</a></li>



</ul>
<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="header-sec" style="padding-top: 0;margin-top: 0;">
        <div id="load-feel" style="position: absolute;border-top: 2px solid #82B8D6;width: 0%;margin-top: 0;margin: 0;padding: 0;left: 10px;"></div>
        <div id="header-sec-wrap">
            <?php include '_form_header_section.php'; ?>
        </div>
    </div>
    <div class="tab-pane view" id="crm-sec" style="padding-top: 0;margin-top: 0;">
        <div id="crm-sec-wrap">
            <?php include '_crm_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="quote-dtl-sec" style="padding-top: 0;margin-top: 0;">
        <div id="quote-dtl-sec-wrap">
            <?php include '_form_quote_dtl_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="file-attachment-sec" style="padding-top: 0;margin-top: 0;">
        <div id="file-attachment-sec-wrap">
            <?php include '_file_attachment_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="sign-off-sec" style="padding-top: 0;margin-top: 0;">
        <div id="sign-off-sec-wrap">
            <?php include '_sign_off_section.php'; ?>
        </div>
    </div>

    <div class="tab-pane view" id="all-in-one-sec" style="padding-top: 0;margin-top: 0;">

    </div>

</div>


<div style="float: right;">
    <?php
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id);return false;", 'style' => 'float:right;'));
    echo CHtml::button('Send Quotation', array('onclick' => "sendEmail($model->id,'Quote');return false;", 'style' => 'float:right;'));
    ?>
</div> 
<!-- model area -->


<div id="editPriceInDetailsModel" class="modal-dialog modal fade" role="dialog" style="width:800px;display: none;">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">                

            <h3 style="text-align: center;">Edit Price</h3>

        </div>
        <div class="modal-body" style="max-height: 600px;">
            <div style="width: 100%;">
                <form id="edit_price_cal_row" method="POST">
                    <div style="border: 1px solid #B7D6E7;border-radius: 10px;width: 100%;padding: 5px;position: relative;">
                        <div style="position: absolute;left: 10px;top: -10px;background: #fff;padding-left: 5px;padding-right: 5px;font-weight: bold;">Product</div>
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;">Cost Price: <a onclick="showPriceLookUpOnEditCalScreen();return false;" href="javascript:void(0)">Price Look-up</a></td>
                                <td style="width: 30%;">
                                    <input name="af_edit_cost_price" type="text" id="af_edit_cost_price" style="text-align: center;"  value="0.0">
                                </td>
                                <td style="width: 20%;">Mark Up :</td>
                                <td style="width: 20%;">
                                    <input title="rate" mark-up="rate" name="af_edit_prd_markup" type="text" id="af_edit_prd_markup" style="text-align: center;width: 35%;" value="0.0"  /> 
                                    <input title="percentage(%)" mark-up="percentage" name="af_edit_prd_markup_percentage" type="text" id="af_edit_prd_markup_percentage" style="text-align: center;width: 30%;" value="0.0" />  (%)
                                </td>
                            </tr>
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;">Discount (%) :</td>
                                <td style="width: 30%;"><input name="af_discount_percntg" type="text" id="af_discount_percntg" style="text-align: center;" value="0.0"></td>
                                <td style="width: 20%;">Marked Up Price:</td>
                                <td style="width: 20%;"><input type="text" id="af_prd_markedup_discounted_price" style="text-align: center;" value="0.0" readonly></td>
                            </tr>    
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;">&nbsp;</td>
                                <td style="width: 30%;">&nbsp;</td>
                                <td style="width: 20%;">$$ Freight :</td>
                                <td style="width: 20%;"><input name="af_usd_freight" type="text" id="af_usd_freight" style="text-align: center;" value="0.0"></td>
                            </tr>
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;"><a title="Freight Unit : Calculated by deviding $$Freight by quantity">$$Freight Unit</a> :</td>
                                <td style="width: 30%;"><input name="af_usd_freight_unit_cost" type="text" id="af_usd_freight_unit_cost" style="text-align: center;" value="0.0" readonly></td>
                                <td style="width: 20%;">$$ Freight Mark-Up :</td>
                                <td style="width: 20%;">
                                    <input title="rate" mark-up="rate" name="af_usd_freight_markup_rate" type="text" id="af_usd_freight_markup_rate" style="text-align: center;width: 35%;" value="0.0">
                                    <input title="percentage(%)" mark-up="percentage" name="af_usd_freight_markup_percentage" type="text" id="af_usd_freight_markup_percentage" style="text-align: center;width: 30%;" value="0.0" />  (%)
                                </td>
                            </tr>
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;">&nbsp;</td>
                                <td style="width: 30%;">&nbsp;</td>
                                <td style="width: 20%;">$$ Marked Up Cost :</td>
                                <td style="width: 20%;"><input name="af_usd_freight_unit_markedup_price" type="text" id="af_usd_freight_unit_markedup_price" style="text-align: center;" value="0.0" readonly></td>
                            </tr>
                            <tr style="width: 100%;">
                                <td style="text-align: left;width: 30%;">&nbsp;</td>
                                <td style="width: 30%;">&nbsp;</td>
                                <td style="width: 20%;">Total :</td>
                                <td style="width: 20%;"><input type="text" id="af_prd__price_with_usd_freight" style="text-align: center;" value="0.0" readonly></td>
                            </tr>
                        </table>
                    </div>
                    <div style="border: 1px solid #B7D6E7;border-radius: 10px;width: 100%;padding: 5px;position: relative;margin-top: 10px;">
                        <div style="position: absolute;left: 10px;top: -10px;background: #fff;padding-left: 5px;padding-right: 5px;font-weight: bold;">Decoration</div>
                        <div id="multi-deco-edit-sec">
                            <!-- this section will be loaded with "Add decoration" button  and other related deocartion detials on the fly -->
                        </div>
                    </div>
                    <div style="border: 1px solid #B7D6E7;border-radius: 10px;width: 100%;padding: 5px;position: relative;margin-top: 10px;">
                        <div style="position: absolute;left: 10px;top: -10px;background: #fff;padding-left: 5px;padding-right: 5px;font-weight: bold;">Other Cost</div>
                        <table style="width: 100%;">
                            <tr>
                                <td style="text-align: left;width: 40%;"><button type="button" class="btn btn-default" onclick="showOtherCostModelEditDtl();">Costs</button></td>
                                <td style="width: 30%;"><input type="text" name="af_edit_othercost_total" id="af_edit_othercost_total" style="text-align: center;" value="0.0" readonly /></td>
                                <td style="width: 20%;">Mark Up :</td>
                                <td style="width: 20%;">
                                    <input title="rate" mark-up="rate" name="af_edit_othercost_markup_rate" type="text" id="af_edit_othercost_markup_rate" style="text-align: center;width: 30%;" value="0.0" />
                                    <input title="percentage(%)" mark-up="percentage" name="af_edit_othercost_markup_percentage" type="text" id="af_edit_othercost_markup_percentage" style="text-align: center;width: 30%;" value="0.0" />  (%)
                                </td>
                            </tr> 
                            <tr>
                                <td style="text-align: left;width: 40%;"></td>
                                <td style="width: 30%;"></td>
                                <td style="width: 20%;">Marked Up Price: </td>
                                <td style="width: 20%;"><input name="af_edit_othercost_markedup_price" type="text" id="af_edit_othercost_markedup_price" style="text-align: center;"  value="0.0" readonly></td>
                            </tr>  
                        </table>
                    </div>
                    <div style="border: 1px solid #B7D6E7;border-radius: 10px;width: 100%;padding: 5px;position: relative;margin-top: 10px;">
                        <div style="position: absolute;left: 10px;top: -10px;background: #fff;padding-left: 5px;padding-right: 5px;font-weight: bold;">Total</div>
                        <table style="width: 100%;">
                            <tr>
                                <td style="text-align: left;width: 40%;">Total Cost:</td>
                                <td style="width: 30%;"><input name="af_total_cost" type="text" id="af_total_cost" style="text-align: center;" value="0.0" readonly/></td>
                                <td style="width: 20%;">Item Quantity:</td>
                                <td style="width: 20%;"><input name="af_edit_itm_qty" type="text" id="af_edit_itm_qty" style="text-align: center;" value="1"></td>
                            </tr> 
                            <tr>
                                <td style="text-align: left;width: 40%;"></td>
                                <td style="width: 30%;"></td>
                                <td style="width: 20%;">Sub Total:</td>
                                <td style="width: 20%;"><input type="text" id="af_edit_subtotal" style="text-align: center;" value="0.0" readonly></td>
                            </tr>  

                            <tr>
                                <td style="text-align: left;width: 40%;">Freight :</td>
                                <td style="width: 30%;">
                                    <input title="rate" mark-up="rate" name="af_freight_rate" type="text" id="af_freight_rate" style="text-align: center;width: 30%;" value="0.0">
                                    <input title="percentage(%)" mark-up="percentage" name="af_freight_percentage" type="text" id="af_freight_percentage" style="text-align: center;width: 30%;" value="0.0" />  (%)
                                </td>
                                <td style="width: 20%;">
                                    <label style="display: inline-block;margin-left: 2px;"><input style="display: inline-block;" type="checkbox" name="aFLockSellPrice" id="aFLockSellPrice" value="1"/>&nbsp;Lock Sell Price</label>									
                                </td>
                                <td style="width: 20%;"><input type="text" name="af_edit_subtotal_with_setup" id="af_edit_subtotal_with_setup" style="text-align: center;" value="0.0"></td>
                            </tr> 
                            <tr>
                                <td style="text-align: left;width: 40%;">Gross Profit : </td>
                                <td style="width: 30%;">
                                    <input name="af_edit_gp_in_doller" type="text" id="af_edit_gp_in_doller" style="text-align: center;width: 30%;" value="0.0" readonly="readonly" />  
                                    <input name="af_edit_gp_percentage" type="text" id="af_edit_gp_percentage" style="text-align: center;width: 30%;" value="0.0" readonly="readonly" /> % 

                                </td>
                                <td style="width: 20%;">Total:</td>
                                <td style="width: 20%;"><input name="af_edit_total" type="text" id="af_edit_total" style="text-align: center;" value="0.0" readonly="readonly"></td>
                            </tr> 
                            <tr>
                                <td style="text-align: left;width: 40%;">Gross Profit Total : </td>
                                <td style="width: 30%;">
                                    <input name="af_gross_profit_total" type="text" id="af_gross_profit_total" style="text-align: center;" value="0.0" readonly/>
                                </td>
                                <td style="width: 20%;">Tax:</td>
                                <td style="width: 20%;">
                                    <?php
                                    echo CHtml::dropDownList('af_edit_tax_rate_id', '', CHtml::listData(SystemTaxCode::model()->findAll(), 'id', 'code'), array('empty' => 'Select Tax Rate'));
                                    ?>
                                </td>
                            </tr> 
                            <tr>
                                <td style="text-align: left;width: 40%;">Line Total : </td>
                                <td style="width: 30%;">
                                    <input name="af_edit_total_line_value" type="text" id="af_edit_total_line_value" style="text-align: center;" readonly/>
                                </td>
                                <td style="width: 20%;">&nbsp;</td>
                                <td style="width: 20%;">&nbsp;</td>
                            </tr> 
                        </table>
                    </div>                        
                </form>    
                <div id="edit-other-cost-html" style="display: none;">
                    <form id="edit-other-cost-form" method="POST">

                    </form>
                    <input type="hidden" id="edit-saved-other-cost-ids" />
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <span style="float: left;color: #C30;" id="cal_message"></span>

            <button title="This will clone data and create new line" id="af_edit_clone_line" style="" type="button" class="btn btn-default">Add another Qty</button>                
            <button title="Override all other markups and margins based on focused input" id="af_edit_override_markup_margin" style="" type="button" class="btn btn-default">Override Markup & Margin</button>
            <button style="margin-left: 2px;" type="button" class="btn btn-default">Calculate</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="updateDetailsPricesByTotExGST();">Save</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>


<div class="modal-dialog modal fade" id="edit-other-cost-model" role="dialog">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">

            <h3 style="text-align: center;">Other Costs</h3>
        </div>
        <div class="modal-body">
            <div style="float: right;">

                <button style="margin-bottom: 10px;" type="button" class="btn btn-default" onclick="showAddOtherCostModelEditDtl();">Add Cost Type</button>
            </div>
            <div>
                <form id="edit-manage-other-cost">


                    <table class="items" id="edit-add-other-cost-new-dtl">
                        <thead>
                            <tr>
                                <th style="display: none;">other cost id</th>  
                                <th>Group</th>
                                <th>Name</th>                
                                <th>Cost</th>
                                <th>Unit Cost</th>
                                <th>&nbsp;</th>                                
                            </tr>
                        </thead>
                        <tbody id="edit-add-other-cost-new-dtl-tbl-body">

                        </tbody>   
                        <div>
                            <input type="hidden" id="edit-stored-other-cost-ids" />
                        </div>
                    </table>
                </form>
            </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="saveEditOtherCosts();">Save</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>


<div id="edit-add-other-cost-model" class="modal fade modal-dialog" role="dialog">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">

            <h3 style="text-align: center;">Add Other Costs</h3>
        </div>
        <div class="modal-body">                
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'edit-other-cost-type-grid',
                'dataProvider' => $othercost->search(),
                'filter' => $othercost,
                'selectableRows' => 100,
                'columns' => array(
                    array(
                        'class' => 'CCheckBoxColumn',
                    ),
                    array(
                        'name' => 'cost_group_name_search',
                        'value' => '$data->other_cost_group_id ? OtherCostGroup::model()->findByPk($data->other_cost_group_id)->name : null',
                    ),
                    'name',
                    array(
                        'name' => 'default_cost',
                        'value' => 'number_format($data->default_cost,2)',
                        'htmlOptions' => array('style' => "text-align:right")
                    ),
                    array(
                        'name' => 'devide_by_qty',
                        'value' => '$data->devide_by_qty?"YES":"NO"'
                    ),
                ),
            ));
            ?>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="addOtherCostFromGridForEditDtl();">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>

<div class="clear"></div>
<style>
    .modal.fade {

        top: -250%;
        -webkit-transition: opacity 0.3s linear, top 0.3s ease-out;
        -moz-transition: opacity 0.3s linear, top 0.3s ease-out;
        -ms-transition: opacity 0.3s linear, top 0.3s ease-out;
        -o-transition: opacity 0.3s linear, top 0.3s ease-out;
        transition: opacity 0.3s linear, top 0.3s ease-out;
    }
</style>
<script type="text/javascript">

    $(document).on('change', '#edit-add-other-cost-new-dtl-tbl-body :input', function () {
        calculateEditOtherCostTotal();

    });

    function calculateEditOtherCostTotal() {
        var totalCost = 0;
        var itemQty = parseInt($('#af_edit_itm_qty').val());
        $.each($("#edit-add-other-cost-new-dtl-tbl-body :input[name='othercost[]']"), function () {
            if ($.isNumeric($(this).val())) {

                if ($(this).attr('qtybsd')) {
                    var numresult = (parseFloat($(this).val()) / itemQty);
                    totalCost += parseFloat(numresult.toFixed(2));
                    $(this).parent().next('td').empty();
                    $(this).parent().next('td').html(numresult.toFixed(2));
                } else {
                    totalCost += parseFloat($(this).val());
                    $(this).parent().next('td').empty();
                    $(this).parent().next('td').html(parseFloat($(this).val()));
                }

            }

        });


        $('.plokij').empty();
        $('.plokij').html('' + totalCost.toFixed(2));
    }

    function deleteEditOtherCostRow(id) {
        $('#edit-add-other-cost-new-dtl-tbl-body').find('#' + id).remove();
        calculateEditOtherCostTotal();
    }

    function saveEditOtherCosts() {
        /*
         var totalCost = 0;
         $.each($("#edit-add-other-cost-new-dtl-tbl-body :input[name='othercost[]']"), function () {
         if ($.isNumeric($(this).val())) {
         totalCost += parseFloat($(this).val());
         }
         
         });
         
         //update other cost total in main cal screen
         $('#af_edit_othercost_total').val(totalCost);
         $('#af_edit_othercost_total').trigger("change");
         */

        $("#edit-other-cost-form").empty();
        $('#edit-add-other-cost-new-dtl-tbl-body').children().appendTo("#edit-other-cost-form");

        saveEditOtherCostCalOnServer();

    }

    function saveEditOtherCostCalOnServer() {
        var quantity = $("#af_edit_itm_qty").val();

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("quatation/saveEditOtherCost"); ?>',
            data: $("#edit-other-cost-form").serialize() + '&quantity=' + quantity,
            dataType: 'json',
            success: function (result) {

                $("#edit-other-cost-form").empty();
                $("#edit-other-cost-form").html(result.html);
                $('#af_edit_othercost_total').val(result.otherCostTotal);
                $('#af_edit_othercost_total').trigger("change");

            },
            error: function (result) {
                //('error in add products');
            }
        });
    }


    function addOtherCostFromGridForEditDtl() {

        var values = new Array();
        $.each($("input[name='edit-other-cost-type-grid_c0[]']:checked"), function () {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (values.length > 0) {

            var newlySelectedOtherCostIds = values + "";

            $.each($("#edit-add-other-cost-new-dtl-tbl-body :input[name='othercostid[]']"), function () {

                newlySelectedOtherCostIds += ("," + $(this).val());

            });


            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("quatation/addOtherCostsForEditDtl"); ?>',
                data: $("#edit-manage-other-cost").serialize() + '&quoteDtlId=' + after_row_id + '&newlySelectedOtherCostIds=' + newlySelectedOtherCostIds,
                dataType: 'json',
                success: function (result) {

                    $('#edit-add-other-cost-new-dtl-tbl-body').empty();
                    $('#edit-add-other-cost-new-dtl-tbl-body').html(result.otherCostHtml);
                    $('#edit-other-cost-form').empty();
                    $('#edit-other-cost-form').html(result.otherCostHtml);
                    //$.fn.yiiGridView.update("product-by-size-grid");

                },
                error: function (result) {
                    //('error in add products');
                }
            });
        }
    }

    function showAddOtherCostModelEditDtl() {
        $.each($("input[name='edit-other-cost-type-grid_c0[]']:checked"), function () {
            $(this).prop('checked', false);
        });
        $('#edit-add-other-cost-model').modal('show');
    }

    function showOtherCostModelEditDtl() {

        $('#edit-add-other-cost-new-dtl-tbl-body').empty();
        $('#edit-other-cost-form').children().clone().appendTo("#edit-add-other-cost-new-dtl-tbl-body");
        $('#edit-other-cost-model').modal('show');
    }


    function setTab(id) {
        if (id == 'all-in-one-sec') {
            runloadfeel('all-in-one-sec');
            $('#header-sec-wrap').appendTo('#all-in-one-sec');
            $('#crm-sec-wrap').appendTo('#all-in-one-sec');
            $('#quote-dtl-sec-wrap').appendTo('#all-in-one-sec');
            $('#file-attachment-sec-wrap').appendTo('#all-in-one-sec');
            $('#sign-off-sec-wrap').appendTo('#all-in-one-sec');

        } else if (id == 'header-sec') {

            runloadfeel('header-sec');
            $('#header-sec-wrap').appendTo('#header-sec');
        } else if (id == 'crm-sec') {
            runloadfeel('crm-sec');
            $('#crm-sec-wrap').appendTo('#crm-sec');
        } else if (id == 'quote-dtl-sec') {
            runloadfeel('quote-dtl-sec');
            $('#quote-dtl-sec-wrap').appendTo('#quote-dtl-sec');
        } else if (id == 'file-attachment-sec') {
            runloadfeel('file-attachment-sec');
            $('#file-attachment-sec-wrap').appendTo('#file-attachment-sec');
        } else if (id == 'sign-off-sec') {
            runloadfeel('sign-off-sec');
            $('#sign-off-sec-wrap').appendTo('#sign-off-sec');
        }

    }

    function runloadfeel(into) {
        $('#load-feel').appendTo('#' + into);

        $('#load-feel').css('width', '0');
        $('#load-feel').animate({width: '97.8%'}, 500);
    }
</script>
<style>
    .loadfeel{
        position: absolute;border-top: 2px solid #82B8D6;width: 0%;margin-top: 0;margin: 0;padding: 0;left: 10px;
    }

    #edit-add-other-cost-new-dtl th{
        text-align: center;
    }

    #edit-add-other-cost-new-dtl tbody input{
        text-align: center;
    }

    #quatation-details-grid table thead tr th{
        background-image: none;
        background-color: #82B8D6;

    }

    .foo{
        background-color: #E5F1F4;
    }

    .bar{
        background-color: #FFFFFF;
    }

    .maindetailrow{
        width: 100%;
    }

    .maincell{
        width: 100%;        

    }

    .maintbl{
        width: 100%;

    }

    .maintbl tr{
        width: 100%;
    }

    .maintbl:first-child tr td:first-child{
        width: 3%;
    }

    .textinput{
        text-align: center;width: 5%;
    }

    .centercls{
        text-align: center;

    }   

    .rightcls{
        text-align: right;
    }   

    input.centercls{
        width: 40px;
    }

    input.rightcls{
        width: 50px;
    }

    td.button-column{
        width: 4%;
    }

    .button-column img{
        cursor: pointer;
        width: 20px;
        height: 20px;
    }

    .subrow{
        width: 100%;
        border: 1px solid #666;
        display: none;
    }

    .subrow:first-child td{
        background-color: #FFFFFF;
    }

    .subrow:first-child td{
        width: 100%;
        display: none;
    }

    .fullwidth{
        width: 100%;
    }

    .subrowgrid tr{
        width: 100%;
    }

    .subrowgrid:first-child tr{
        background-color: #e5eCf9;
    }

    .subrowgrid:last-child tr{
        border: 1px solid #DDD;
    }

    .column1{
        width: 10%;
    }

    .column2{
        width: 12%;
    }

    .column3{
        width: 28%
    }

    .column4{
        width: 14%
    }

    .qty-clm{
        width: 10%;
    }

    .price-clm{
        width:6%;
    }

    .tot-clm{
        width: 8%;
    }

    .column2half{
        width: 25%;
    }

    .column1half{
        width: 15%;
    }

    .subrowgrid tr th{
        text-align: center;
    }

    .subrowgrid textArea{
        width: 100%;height: 100%;
    }

    .subrowgrid img{
        width:100px;
        height:100px;
    }


    .viewsizecolor{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;    
    }

    .uploadimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 10px;

    }

    .saveimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 5px;
        display: none;

    }

    .mouseoverbutton{
        background-color: #DDD;
        border: 1px solid #FFD324;
    }

    .sizeqtycolordiv{
        display: none;
    }

    .sizeqtycolordiv table{
        width: 100%;
    }

    .sizeqtycolordiv table tr{
        width: 100%;
    }

    .sizeqtycolordiv table:first-child tr{
        background-color: #DDD;
    }

    .sizeqtycolordiv table tr th,td{
        text-align: center;
    }

    .sizeqtycolordiv table:first-child tr div{
        border: 1px solid #FFFFFF;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        width: 50%;
        margin: auto;
    }

    .sizeqtycolordiv table tr:not(:first-child){
        background-color: #E6EFC2;
    }

    .sizeqtycolordiv table input{
        width: 100%;
    }

    .counter{
        width: 2%;
    }

    .counter-no{

    }

    .savemessage{
        width: 100%;        
        font-weight: bold;
        color: #00aa00;
        display: none;

    }

    .prodecs{

    }

    .viewlongdesc{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        color: #BCE774;
        margin: 5px;
    }

    .prolngdesc{
        display: none;
    }

    #workorder-list-view tbody td{
        text-align: left;
        padding-left: 50px;

    }

    hr{
        border-color: #EEEEEE -moz-use-text-color #FFFFFF;
        border-style: solid none; 
        border-width: 1px 0;
        margin: 18px 0;
    }

    #edit-line-multi-deco{
        width: 650px;  

    }



</style>