<div class="view">
    <?php
    ob_start();
    $todayDate = date(GlobalVars::get("DateFormat")); // current date
    $currentTime = time() + 60 * 60 * 11 + 30 * 60; //Change date into time
    $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);
    Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
    $this->widget('CJuiDateTimePicker', array(
        'model' => $model, //Model object
        'attribute' => 'dueDate', //attribute name
        'mode' => 'date', //use "time","date" or "datetime" (default)
        'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
        'htmlOptions' => array('style' => 'text-align:center;', "id" => "dueDate_{$model->id}",),
        'language' => 'en-GB'
    ));

    $duedateDatetimepicker = ob_get_contents();
    ob_end_clean();
    ?>

    <div style="float: left;width: 50%;">
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'id' => 'quote-detail',
            'data' => $model,
            'attributes' => array(
                //'id',
                //'ws_id',
                'quoteno',
                array(
                    'name' => 'quotename',
                    'value' => $model->getTextFieldForQuoteView('quotename', $model->quotename, $model->id),
                    //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'text-align:center')
                ),
                //'systemfreight',
                array(
                    'name' => 'quotecomments',
                    'value' => $model->getTextAreaForQuoteView('quotecomments', $model->quotecomments, $model->id),
                    //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'text-align:center')
                ),
                array(
                    'name' => 'salesEstimate',
                    'value' => $model->getTextFieldForQuoteView('salesEstimate', $model->salesEstimate, $model->id),
                    //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'text-align:center')
                ),
                array(
                    'name' => 'probability',
                    'value' => $model->getTextFieldForQuoteView('probability', $model->probability, $model->id) . '<label style="display:inline;">%</label>',
                    //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'text-align:center')
                ),
                array(
                    'name' => 'followupStatus',
                    'value' => $model->getDropDown('followupStatus', $model->getFollowupStatusId(), $model->id, FollowupStatus::model()->findAll(array('condition' => "type = 'Quotation'", 'order' => '-status_sequence DESC, id DESC')), 'id', 'status', ''),
                    //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'text-align:center')
                ),
                array(
                    'name' => 'ws_user_id',
                    'value' => SalesPerson::model()->findByPk($model->ws_user_id)->name,
                //'value' => CHtml::textField('cusnam', $model->customer->cusnam, array("style" => "width:300px;", "id" => "cusname")),
                //'type' => 'raw',
                //'htmlOptions' => array('style' => 'text-align:center')
                ),
                array(
                    'name' => 'dueDate',
                    'value' => $duedateDatetimepicker,
                    'type' => 'raw',
                ),
                array(
                    'name' => 'quotecreated',
                    'value' => date(GlobalVars::get("DateFormat"), strtotime($model->quotecreated)),
                ),
            ),
        ));
        ?>
    </div>
    <div style="float: right;width: 50%;">

        <ul class="nav nav-tabs" role="tablist">

            <li class="active"><a href="#customer-office-address-sec" role="tab" data-toggle="tab" >Office Address</a></li>

            <li><a href="#customer-shipping-address-sec" role="tab" data-toggle="tab">Shipping Address</a></li>

        </ul>

        <div class="tab-content">
            <div class="tab-pane active view" id="customer-office-address-sec" style="padding-top: 0;margin-top: 0;">            
                <div id="customer-office-address-sec-wrap">
					<div style="float: left;display: inline;margin-right: 5px;">
                    <?php
						echo CHtml::checkBox('copyOfficeAddrToShip', false, array('id' => 'copyOfficeAddrToShip', 'style' => 'display: inline;'));
						?>
						<label style="width:150px;display: inline;">
							<?php echo "Shipping address details the same"; ?> 
						</label>
					</div>
					<br />
                    <?php
        $this->widget('zii.widgets.CDetailView', array(
            'id' => 'quote-detail-contact',
            'data' => $model,
            'attributes' => array(
                array(
                    'name' => 'cus_fref',
                    'value' => $model->getCustomerLink(),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusmcussno',
                    'value' => !empty($model->customer->master) ? $model->customer->master->mcusnam : '',
                ),
                array(
                    'name' => 'customer.cusmobtel',
                    'value' => $model->customer->cusmobtel,
                    'value' => $model->getTextFieldForQuoteView('customer.cusmobtel', $model->customer->cusmobtel, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.custel',
                    'value' => $model->customer->custel,
                    'value' => $model->getTextFieldForQuoteView('customer.custel', $model->customer->custel, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusemail',
                    'value' => $model->customer->cusemail,
                    'value' => $model->getTextFieldForQuoteView('customer.cusemail', $model->customer->cusemail, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cuscontact',
                    'value' => $model->getTextFieldForQuoteView('customer.cuscontact', $model->customer->cuscontact, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusadd1',
                    'value' => $model->getTextFieldForQuoteView('customer.cusadd1', $model->customer->cusadd1, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusadd2',
                    'value' => $model->getTextFieldForQuoteView('customer.cusadd2', $model->customer->cusadd2, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusadd3',
                    'value' => $model->getTextFieldForQuoteView('customer.cusadd3', $model->customer->cusadd3, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.custown',
                    'value' => $model->getTextFieldForQuoteView('customer.custown', $model->customer->custown, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cusstate',
                    'value' => $model->getTextFieldForQuoteView('customer.cusstate', $model->customer->cusstate, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'customer.cuspostcode',
                    'value' => $model->getTextFieldForQuoteView('customer.cuspostcode', $model->customer->cuspostcode, $model->id),
                    'type' => 'raw',
                ),
               
            ),
        ));
        ?>
                </div>

            </div>
            <div class="tab-pane view" id="customer-shipping-address-sec" style="padding-top: 0;margin-top: 0;">
                <div id="customer-shipping-address-sec-wrap">
                    <?php
        $this->widget('zii.widgets.CDetailView', array(
            'id' => 'quote-detail-contact',
            'data' => $model,
            'attributes' => array(
				array(
                    'name' => 'shipContactName',
                    'value' => $model->getTextFieldForQuoteView('shipContactName', $model->shipContactName ?: $model->customer->cuscontact, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipSendVia',
                    'value' => $model->getTextFieldForQuoteView('shipSendVia', $model->shipSendVia, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipAddress1',
                    'value' => $model->getTextFieldForQuoteView('shipAddress1', $model->shipAddress1 ?: $model->customer->shipAddress1, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipAddress2',
                    'value' => $model->getTextFieldForQuoteView('shipAddress2', $model->shipAddress2 ?: $model->customer->shipAddress2, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipAddress3',
                    'value' => $model->getTextFieldForQuoteView('shipAddress3', $model->shipAddress3 ?: $model->customer->shipAddress3, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipSub',
                    'value' => $model->getTextFieldForQuoteView('shipSub', $model->shipSub ?: $model->customer->shipSub, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipState',
                    'value' => $model->getTextFieldForQuoteView('shipState', $model->shipState ?: $model->customer->shipState, $model->id),
                    'type' => 'raw',
                ),
                array(
                    'name' => 'shipPostalCode',
                    'value' => $model->getTextFieldForQuoteView('shipPostalCode', $model->shipPostalCode ?: $model->customer->shipPostalCode, $model->id),
                    'type' => 'raw',
                ),
            ),
        ));
        ?>
                </div>
            </div>
        </div>
        
    </div>
    <div class="clear"></div>

</div>