<?php
$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}
$this->menu = array(
    $jobinfocusmenu,
    array('label' => 'Create Quote', 'url' => array('quatation/create')),
    array('label' => 'Quote Item Details', 'url' => array('quatationDetails/admin')),
    array('label' => 'Refresh web quotes', 'url' => array('processQuotations'), 'linkOptions' => array('style' => 'background-color:#32cd32;')),
    array('label' => 'Quote Dashboard', 'url' => array('dashboard')),
);



foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>

<h1>
    Load Web Quotes&nbsp;
<?php
if (isset($_GET['dtrng']) && $_GET['dtrng'] == Quatation::FILTER_THIS_WEEK)
    echo '[ THIS WEEK ]';
?>
</h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'quatation-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        //'ws_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'quotecreated',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->quotecreated))'
        ),
        array(
            'name' => 'quoteno',
            'value' => '$data->getQuoteHtml()',
            'type' => 'html',
            'htmlOptions' => array('style' => 'width:120px;text-align:center;'),
        ),
        'quotename',
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            // 'filter' => CHtml::listData(MasterCustomer::model()->findAll(array('order' => 'mcusnam')), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            //'filter' => CHtml::listData(Customer::model()->findAll(array('order' => 'cusnam')), 'cuscus_fref', 'cusnam'),
            'type' => 'raw',
        ),
        //'systemfreight',
        'quotecomments',
        array(
            'name' => 'ws_user_id',
            'value' => '$data->salesPersonRel->name',
        //'htmlOptions'=>array('style'=>'width:150px;')
        ),
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'Quotation'", 'order' => 'status ASC')), 'id', 'status'),
        // 'type' => 'raw',
        ),
        array(
            'name' => 'onlineQuoteAcceptanceStatusSearch',
            'value' => '$data->onlineAcceptenceLog ? $data->onlineAcceptenceLog->toString() : ""',
            'filter' => CHtml::dropDownList('Quatation[onlineQuoteAcceptanceStatusSearch]', $model->onlineQuoteAcceptanceStatusSearch, QuoteOnlineAcceptenceLog::LOG_STATUS_ARRAY, array('empty' => '-- SELECT STATUS --')
            ),
        ),        
        array(
            'name' => 'sellPriceAmountExGST',
            'value' => 'number_format($data->sellPriceAmountExGST, 2)'
        ),
        //'quotecreated',
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{update}{sep2}{print}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'update' => array(
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'print' => array(
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("quatation/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            )
        ),
    ),
));
?>
<div id="workingQuoteModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">

                <h3 style="text-align: center;">Confirm Action for Quotation</h3>
            </div>
            <div class="modal-body">
                <p style="font-size: 1.2em;">There is a quotation that is not saved properly. Do you need to discard it or save?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="discardQuote();">Discard</button>
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="saveQuote();">Save</button>
            </div>
        </div>

    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.3.3/bootbox.min.js"></script>
<script>

                    

                    function checkWorkingQuote() {

                        $.ajax({
                            type: 'POST',
                            url: '<?php echo Yii::app()->createUrl("quatation/checkWorkingQuote"); ?>',
                            data: {'CHECK_QUOTE': 'CHECK_QUOTE'},
                            dataType: 'json',
                            success: function (result) {
                                if (result.has_quote == true) {
                                    $('#workingQuoteModal').modal('show');
                                    return false;
                                } else {
                                    window.location.href = 'index.php?r=quatation/create';
                                }
                            },
                            error: function (result) {
                                alert('error in check for working quotation');
                            }
                        });
                        $('#confirmDModal').modal('show');
                    }

                    function discardQuote() {
                        window.location.href = 'index.php?r=quatation/create&type=discard';
                    }

                    function saveQuote() {
                        window.location.href = 'index.php?r=quatation/create&type=save';
                    }
</script>
