<?php
$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}



Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Sales person Report V2</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">

            <?php echo $form->labelEx($model, 'spersonDateFlag'); ?>

            <?php
            echo $form->radioButtonList($model, 'spersonDateFlag', array(1 => 'Quote Created Date', 2 => 'Quote Due Date'), array(
                'labelOptions' => array('style' => 'display:inline'),
                'separator' => '&nbsp;&nbsp;',
            ));
            ?>
        </div>
        <div class="clear"></div>

        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <?php echo $form->labelEx($model, 'ws_user_id'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['sperson_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['sperson_selcted']);
                foreach ($stsArr as $key => $val) {
                    $optionsselected[$val] = array('selected' => true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'ws_user_id', CHtml::listData(SalesPerson::model()->findAll(array('order' => 'name asc')), 'id', 'name'), 
					array(
						'empty' => 'Select Sales Persons', 
						'multiple' => true,
						'options' => $optionsselected
                
                    )
            );
            ?>
            <?php echo $form->error($model, 'ws_user_id'); ?>
            <div>[Ctrl + select] : To select multiple salesperson options</div>
        </div>   
		
		<div class="row">
            <?php echo $form->labelEx($model, 'followupStatus'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['sperson_sts_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['sperson_sts_selcted']);
                foreach ($stsArr as $key => $val) {
                    $optionsselected[$val] = array('selected' => true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'followupStatus', CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'Quotation'", 'order' => 'status')), 'id', 'status'), 
					array(
						'empty' => 'Select Follow-up Status', 
						'multiple' => true,
						'options' => $optionsselected
                
                    )
            );
            ?>
            <?php echo $form->error($model, 'followupStatus'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        <div class="clear"></div>


        <div style="float: left;">
            <?php
            echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
            echo CHtml::submitButton('Go', array('name' => 'go_btn'));
            ?>
        </div>
        <?php $this->endWidget(); ?>
        <div style="float: right;">
            <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>

        </div>

        <div class="clear"></div>
    </div>
</div>
<div class="clear"></div>

<?php
$this->widget('ext.groupgridview.GroupGridView', array(
    'id' => 'sales-person-jobs-grid',
    'dataProvider' => $model->searchSpersonV2(),
    'filter' => $model,
    'mergeColumns' => array('salesperson_search'),
    'extraRowColumns' => array('salesperson_search'),
    'extraRowPos' => 'below',
    'extraRowTotals' => function($data, $row, &$totals) {
        $quote = Quatation::model()->findByPk($data['id']);

        $totals['sub_tot'] += $quote->getTotalWithoutGST();
    },
    'extraRowExpression' => '"<span class=\"label label-success\">Sub Total : ".number_format($totals["sub_tot"], 2)."</span>"',
    'summaryText' => '',
    'columns' => array(
        array(
            'name' => 'salesperson_search',
            'value' => 'SalesPerson::model()->findByPk($data->ws_user_id)->name',
            'type' => 'raw',
        ),
        array(
            'name' => 'quotecreated',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->quotecreated))',
            'filter' => false,
        ),
        
        array(
            'name' => 'quoteno',
            'value' => '$data->getNameWithTotalExGst()',
            'type' => 'raw',
            'footer' => $model->footerTemplate()
        ),
        array(
            'name' => 'quotename',
            //'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'quotecomments',
            //'value' => 'CHtml::link($data->quoteNum,array("quatation/view","id"=>$data->quote_id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'Quotation'", 'order' => 'status ASC')), 'id', 'status'),
        // 'type' => 'raw',
        ),
        array(
            'name' => 'dueDate',
            'value' => 'Refiner::getdatetext($data->dueDate,GlobalVars::get("DateFormat"))',
            'filter' => false,
        ),
        
    ),
));
?>
<script>
    function generateExcel() {
        var win = window.open('index.php?r=quatation/generateOutstandingJobsExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=quatation/printSalespersonPDFV2');

    }


</script>

<style>
    div .flowstatus{
        width: 3%;
        height: 1.5em;
        border: 1px solid #C9E0ED;             
        float: right;
        display: inline;
    }
    div .statuslbl{
        float: right;
    }  
</style>