<?php




Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");


?>

<h1>Quotation Status Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'purchase-orders-form',
            'enableAjaxValidation' => false,
        ));
        ?>
        <div class="row">
            <label  for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="row">
            <label  for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>  
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'followupStatus'); ?>
            <?php
            $optionsselected = array();
            if (isset(Yii::app()->session['quote_sts_selcted'])) {
                $stsArr = explode(',', Yii::app()->session['quote_sts_selcted']);
                foreach ($stsArr as $key=>$val){
                    $optionsselected[$val] = array('selected'=>true);
                }
            }
            //echo $form->textField($model,'status_id',array('value'=> Status::model()->findByPk($model->status_id)->name)); 
            echo $form->dropDownList($model, 'followupStatus', 
                    CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = 'Quotation'", 'order'=>'status')), 'id', 'status'), 
                    array('empty' => '',
                        'multiple'=>true,
                            'options'=>$optionsselected
                        )
                    );
            ?>
            <?php echo $form->error($model, 'followupStatus'); ?>
            <div>[Ctrl + select] : To select multiple status options</div>
        </div>   
        
        
        <div class="clear"></div>
        <div>
            <?php 
            echo CHtml::submitButton('Go',array('name'=>'go_btn'));
            echo CHtml::submitButton('Reset',array('name'=>'reset_btn'));
            $this->endWidget();
           
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'purchase-orders-form',
                'enableAjaxValidation' => false,
                'action'=>Yii::app()->createUrl('//jobs/dueExportExcel'),
                'htmlOptions'=>array('style'=>'display:inline;')
            ));
            
            
            echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); 
            echo CHtml::button('Generate Excel', array('style' => 'float:right;', 'onclick' => 'generateExcel();')); 
        
        
            //echo CHtml::submitButton('Export to Excel', array( 'style' => 'margin-left:5px;float:right;'));
            //echo CHtml::button('Print PDF', array('onclick' => "printPDF();", 'style' => 'margin-left:5px;float:right;'));
            $this->endWidget();
            
            
            ?>
        </div>
        
    </div>
    <div class="clear"></div>
</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'quatation-grid',
    'dataProvider' => $model->searchStatus(),
    'filter' => $model,
    'columns' => array(
        //'id',
        //'ws_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'ws_date',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->ws_date))',
            'htmlOptions'=>array('style'=>'width:80px;text-align:center;'),
            'filter'=>false,
        ),
        array(
            'name' => 'quoteno',   
            'value' => '$data->getQuoteHtml()',
            'type' => 'raw',
            'htmlOptions'=>array('style'=>'width:120px;text-align:center;'),
        ),
        
        'quotename',
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
           // 'filter' => CHtml::listData(MasterCustomer::model()->findAll(array('order' => 'mcusnam')), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            //'filter' => CHtml::listData(Customer::model()->findAll(array('order' => 'cusnam')), 'cuscus_fref', 'cusnam'),
            'type' => 'raw',
        ),
        //'systemfreight',
        'quotecomments',
        'ws_user',
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            'filter' => false,
           // 'type' => 'raw',
        ),
        //'quotecreated',
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{print}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),                
                'print' => array(
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("quatation/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            )
        ),
    ),
));
?>
<script>
//    function printPDF() {
//        //alert(status_id);
//        var win = window.open('index.php?r=jobs/printDue');
//    }
    
    function generateExcel() {
        var win = window.open('index.php?r=quatation/generateStatusExcel');

    }

    function generatePDF() {
        var win = window.open('index.php?r=quatation/generateStatusPDF');

    }


</script>